/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ram.client;

import com.ibm.ram.client.RAMAsset;
import com.ibm.ram.client.RAMStateHistory;
import com.ibm.ram.client.RAMUser;
import com.ibm.ram.common.data.exception.RAMRuntimeException;
import com.ibm.ram.internal.client.AbstractRESTClient;
import com.ibm.ram.internal.client.RAMServiceException;
import com.ibm.ram.internal.jaxb.Asset;
import com.ibm.ram.internal.jaxb.Comment;
import com.ibm.ram.internal.jaxb.Link;
import com.ibm.ram.internal.jaxb.StateHistory;
import com.ibm.ram.internal.jaxb.Vote;
import com.ibm.ram.internal.jaxb.VoteChoice;
import com.ibm.ram.internal.jaxb.util.JAXBLinksUtil;

public class RAMVote {
    public static String APPROVE = VoteChoice.APPROVE;
    public static String REJECT = VoteChoice.REJECT;
    private Vote fVote = new Vote();
    private RAMStateHistory fStateHistory;
    private RAMUser fUser;

    public RAMVote() {
    }

    RAMVote(RAMStateHistory history, Vote vote) {
        this.fStateHistory = history;
        this.fVote = vote;
    }

    protected Vote getInternalVote() {
        return this.fVote;
    }

    protected void setInternalVote(Vote vote) {
        this.fVote = vote;
    }

    public String getComment() throws RAMRuntimeException {
        String comment = null;
        if (this.fVote.getComment() != null) {
            try {
                if (!this.fVote.getComment().isValueSet()) {
                    RAMAsset asset = this.getStateHistory().getAsset();
                    AbstractRESTClient client = asset.getSession().getRESTClient();
                    Link<Asset> restAssetRef = asset.getRestAssetRef();
                    String stateHistroyId = this.fStateHistory.getInternalStateHistory().getIdentifier();
                    Link<StateHistory> stateHistoryRef = JAXBLinksUtil.getStateHistoryLink(restAssetRef, stateHistroyId);
                    String commentId = JAXBLinksUtil.getCommentIdentifier(this.fVote.getComment());
                    Comment commentObj = client.getComment(stateHistoryRef, commentId);
                    this.fVote.getComment().setValue(commentObj);
                }
                comment = this.fVote.getComment().getValue().getBody();
            }
            catch (RAMServiceException e) {
                throw new RAMRuntimeException("Failed to load comment : " + this.fVote.getComment(), e);
            }
        }
        return comment;
    }

    public void setComment(String comment) {
        if (this.fVote.getComment() != null && this.fVote.getComment().isValueSet()) {
            this.fVote.getComment().getValue().setBody(comment);
        } else {
            Comment commentObj = new Comment();
            commentObj.setBody(comment);
            Link<Comment> commentRef = JAXBLinksUtil.getLink("new comment", "newCommentHref", commentObj);
            this.fVote.setComment(commentRef);
        }
    }

    public String getVoteChoice() {
        if (this.fVote.getChoice() == null) {
            return null;
        }
        return this.fVote.getChoice().getValue();
    }

    public void setVoteChoice(String voteChoice) {
        VoteChoice choice = new VoteChoice();
        choice.setValue(voteChoice);
        this.fVote.setChoice(choice);
    }

    public RAMStateHistory getStateHistory() {
        return this.fStateHistory;
    }

    public RAMUser getUser() {
        if (this.fUser == null && this.fVote.getUser() != null) {
            RAMUser user;
            String userId = JAXBLinksUtil.getUserIdentifier(this.fVote.getUser().getHref());
            this.fUser = user = this.getStateHistory().getAsset().getSession().getUser(userId);
        }
        return this.fUser;
    }
}

