/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ram.common.data;

import com.ibm.ram.common.data.ArtifactReference;
import com.ibm.ram.common.util.UtilitiesCommon;

public class Artifact {
    public static final String TYPE_FOLDER = "folder";
    public static final String TYPE_URL = "url";
    public static final String TYPE_FILE = "file";
    public static final String FILE_DELIM = "/";
    private String name;
    private String type;
    private long size;
    private long creationDate;
    private String path;
    private ArtifactReference reference;
    private String label;
    private String mimeType;
    private long checksum;

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getType() {
        if (this.type == null) {
            this.type = TYPE_FILE;
        }
        return this.type;
    }

    public void setType(String type) {
        this.type = TYPE_FILE.equals(type) ? TYPE_FILE : (TYPE_FOLDER.equals(type) ? TYPE_FOLDER : (TYPE_URL.equals(type) ? TYPE_URL : type));
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        if (!UtilitiesCommon.objectsEqual(path, this.path)) {
            this.path = path;
        }
    }

    protected void setInternalPath(String path) {
        this.path = path;
    }

    public long getSize() {
        return this.size;
    }

    public void setSize(long size) {
        this.size = size;
    }

    public long getCreationDate() {
        return this.creationDate;
    }

    public void setCreationDate(long creationDate) {
        this.creationDate = creationDate;
    }

    public ArtifactReference getReference() {
        return this.reference;
    }

    public void setReference(ArtifactReference reference) {
        this.reference = reference;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label != null && label.length() == 0 ? "" : label;
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public void setMimeType(String mimeType) {
        this.mimeType = mimeType;
    }

    public String toString() {
        String pathToMe = this.getPath();
        String fullPath = pathToMe == null ? "<root>" : ("".equals(pathToMe) ? this.getName() : String.valueOf(pathToMe) + FILE_DELIM + this.getName());
        String type = this.getType();
        if (type == null) {
            type = "Unknown";
        }
        return "[" + type + "] " + fullPath;
    }

    public long getChecksum() {
        return this.checksum;
    }

    public void setChecksum(long checksum) {
        this.checksum = checksum;
    }
}

