/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ram.common.util;

import com.ibm.ram.common.util.UtilitiesCommon;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.util.List;
import java.util.regex.Pattern;

public class CSVExporter {
    private boolean[] notNumberColumn;
    private StringBuilder sb = null;
    private static final Pattern ESCAPE_QUOTES = Pattern.compile("\\\"");

    public static CSVExporter create(Appendable appendable, String separator, String ... colHeaders) throws IOException {
        CSVExporter exporter = new CSVExporter(colHeaders.length);
        if (separator != null) {
            exporter.formatSeparator(appendable, separator);
            appendable.append('\n');
        }
        exporter.formatRecord(appendable, colHeaders);
        return exporter;
    }

    public static CSVExporter create(Appendable appendable, String separator, List<String> colHeaders) throws IOException {
        CSVExporter exporter = new CSVExporter(colHeaders.size());
        if (separator != null) {
            exporter.formatSeparator(appendable, separator);
            appendable.append('\n');
        }
        exporter.formatRecord(appendable, colHeaders);
        return exporter;
    }

    public CSVExporter(int columns) {
        this.notNumberColumn = new boolean[columns];
        this.sb = new StringBuilder();
    }

    public CSVExporter(String ... colHeaders) {
        this.notNumberColumn = new boolean[colHeaders.length];
        this.sb = new StringBuilder();
        this.appendRecord(colHeaders);
    }

    public void setColumnNotNumber(int colNumber, boolean notNumberColumn) {
        if (colNumber >= 0 && colNumber < this.notNumberColumn.length) {
            this.notNumberColumn[colNumber] = notNumberColumn;
        }
    }

    public boolean appendRecord(String ... line) {
        try {
            return this.formatRecord((Appendable)this.sb, line);
        }
        catch (IOException iOException) {
            return true;
        }
    }

    public boolean formatRecord(Appendable to, String ... columns) throws IOException {
        if (columns.length != this.notNumberColumn.length) {
            return false;
        }
        int colNumber = 0;
        while (colNumber < columns.length) {
            String column = columns[colNumber];
            if (colNumber > 0) {
                to.append(',');
            }
            this.formatColumn(column, to, colNumber);
            ++colNumber;
        }
        to.append('\n');
        return true;
    }

    public boolean formatRecord(Appendable to, List<String> columns) throws IOException {
        if (columns.size() != this.notNumberColumn.length) {
            return false;
        }
        int colNumber = 0;
        while (colNumber < this.notNumberColumn.length) {
            String column = columns.get(colNumber);
            if (colNumber > 0) {
                to.append(',');
            }
            this.formatColumn(column, to, colNumber);
            ++colNumber;
        }
        to.append('\n');
        return true;
    }

    private void formatColumn(String string, Appendable lsb, int colNumber) throws IOException {
        if (UtilitiesCommon.isEmptyString(string)) {
            return;
        }
        if ((string = ESCAPE_QUOTES.matcher(string).replaceAll("\\\"\\\"")).indexOf(44) >= 0 || string.indexOf(34) >= 0 || string.indexOf(10) >= 0) {
            lsb.append("\"").append(string).append("\"");
        } else if (colNumber >= 0 && this.notNumberColumn[colNumber]) {
            lsb.append('\t').append(string);
        } else {
            lsb.append(string);
        }
    }

    public InputStream getFile() {
        try {
            return new ByteArrayInputStream(this.getFileContents().getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return new ByteArrayInputStream(this.getFileContents().getBytes());
        }
    }

    public Reader getReader() {
        return new StringReader(this.getFileContents());
    }

    public String getFileContents() {
        return this.sb.toString();
    }

    public void appendSeparator(String string) {
        try {
            this.formatSeparator(this.sb, string);
        }
        catch (IOException iOException) {}
    }

    public void formatSeparator(Appendable to, String string) throws IOException {
        to.append('\n');
        to.append("#-------------------------\n");
        to.append("# ");
        this.formatColumn(string, to, -1);
        to.append('\n');
        to.append("#-------------------------\n");
        to.append('\n');
    }
}

