/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ram.common.util;

import com.ibm.ram.common.util.InputStreamInformation;
import com.ibm.ram.common.util.UtilitiesCommon;
import com.ibm.ram.internal.common.util.ArtifactUtilities;
import com.ibm.ram.internal.common.util.BaseParallelOutputStreamInputStream;
import com.ibm.ram.internal.common.util.ParallelOutputStreamInputStream;
import com.ibm.ram.io.zip.ZipEntry;
import com.ibm.ram.io.zip.ZipFile;
import com.ibm.ram.io.zip.ZipOutputStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import java.util.zip.ZipException;
import org.apache.log4j.Logger;

public class DeltaAssetFileBuilder {
    private static final Logger LOGGER = Logger.getLogger(DeltaAssetFileBuilder.class);
    public static final String DELETE_FILE = "META-INF/ibm-partialapp-delete.props";
    private static final String ZIPBASE = "zip";
    private static final String ARTIFACTBASE = "artifact";
    private File mergeBase;
    private File zipBase;
    private File artifactBase;
    private List<MergeEntry> deltaEntries = new ArrayList<MergeEntry>();
    private String zipBasePath = "";
    private String artifactBasePath = "";
    private File deltaFile;
    private File deleteFile;
    private Set<String> processedFiles = new HashSet<String>();
    private Set<String> deletedFiles = new HashSet<String>();
    private boolean deleteFileCreated = false;
    private boolean update;
    public static final String MERGE_DIR = "upload";
    private final Set<String> unmodifiedDeletedFiles = Collections.unmodifiableSet(this.deletedFiles);

    public DeltaAssetFileBuilder(File mergeBase, boolean update) {
        this.update = update;
        this.mergeBase = new File(mergeBase, MERGE_DIR);
        this.zipBase = new File(this.mergeBase, ZIPBASE);
        this.artifactBase = new File(this.mergeBase, ARTIFACTBASE);
        if (this.mergeBase.exists()) {
            DeltaAssetFileBuilder.deldir(this.mergeBase, false);
        }
        this.zipBase.mkdirs();
        this.artifactBase.mkdirs();
        this.zipBasePath = DeltaAssetFileBuilder.normalizePath(this.zipBase.getAbsolutePath());
        this.artifactBasePath = DeltaAssetFileBuilder.normalizePath(this.artifactBase.getAbsolutePath());
    }

    public File getMergeBase() {
        return this.mergeBase.getParentFile();
    }

    public static String normalizePath(String path) {
        return path.replace('\\', '/');
    }

    public void close() {
        DeltaAssetFileBuilder.deldir(this.mergeBase, true);
    }

    private static void deldir(File dir, boolean includeDir) {
        File[] children = dir.listFiles();
        if (children == null) {
            return;
        }
        int i = 0;
        while (i < children.length) {
            File child = children[i];
            if (child.isDirectory()) {
                DeltaAssetFileBuilder.deldir(child, true);
            } else {
                child.delete();
            }
            ++i;
        }
        if (includeDir) {
            dir.delete();
        }
    }

    public File createZipFile(String currentPath) {
        File zipParent;
        File file = zipParent = (currentPath = this.makeRelativePath(currentPath)).length() == 0 ? this.zipBase : new File(this.zipBase, currentPath);
        if (!ArtifactUtilities.isValidArtifactPath(this.zipBase, zipParent)) {
            throw new IllegalArgumentException("The specified folder name is not valid: " + currentPath);
        }
        if (!zipParent.exists()) {
            zipParent.mkdirs();
        }
        try {
            return File.createTempFile(MERGE_DIR, ".zip", zipParent);
        }
        catch (IOException e) {
            LOGGER.error((Object)"Create delta zip error", (Throwable)e);
            return new File(zipParent, MERGE_DIR + System.currentTimeMillis() + ".zip");
        }
    }

    public File createArtifactFile(String artifactPath, String artifactName) throws IllegalArgumentException {
        File artifactFile;
        File artifactParent;
        if (!ArtifactUtilities.isValidArtifactPath(artifactPath = this.makeRelativePath(artifactPath))) {
            throw new IllegalArgumentException("The specified folder name is not valid: " + artifactPath);
        }
        File file = artifactParent = artifactPath.length() == 0 ? this.artifactBase : new File(this.artifactBase, artifactPath);
        if (!ArtifactUtilities.isValidArtifactPath(this.artifactBase, artifactParent)) {
            throw new IllegalArgumentException("The specified folder name is not valid: " + artifactPath);
        }
        if (!artifactParent.exists()) {
            artifactParent.mkdirs();
        }
        if (!ArtifactUtilities.isValidArtifactPath(this.artifactBase, artifactFile = new File(artifactParent, artifactName))) {
            throw new IllegalArgumentException("The specified folder name is not valid: " + artifactPath);
        }
        return artifactFile;
    }

    private String makeRelativePath(String currentPath) {
        if (currentPath.length() > 0) {
            if (currentPath.charAt(0) == '/') {
                currentPath = currentPath.length() == 1 ? "" : (currentPath.charAt(currentPath.length() - 1) != '/' ? currentPath.substring(1) : currentPath.substring(1, currentPath.length() - 2));
            } else if (currentPath.charAt(currentPath.length() - 1) == '/') {
                currentPath = currentPath.substring(0, currentPath.length() - 2);
            }
        }
        return currentPath;
    }

    public void addFileToDelta(File fileToMerge) {
        this.deltaEntries.add(new MergeEntry(false, fileToMerge, this.artifactBasePath, ""));
    }

    public void addFileToDelta(File fileToMerge, String baseFolderToStrip, String newBasePath) {
        this.deltaEntries.add(new MergeEntry(false, fileToMerge, baseFolderToStrip == null ? null : DeltaAssetFileBuilder.normalizePath(baseFolderToStrip), newBasePath));
    }

    public void addFileToDelta(File fileToMerge, String fileRename) {
        this.deltaEntries.add(new MergeEntry(fileToMerge, fileRename));
    }

    public void addZipFileToDelta(File zipfileToMerge, boolean setAsFirstEntry) {
        if (setAsFirstEntry) {
            this.deltaEntries.add(0, new MergeEntry(true, zipfileToMerge, this.zipBasePath, ""));
        } else {
            this.deltaEntries.add(new MergeEntry(true, zipfileToMerge, this.zipBasePath, ""));
        }
    }

    public void addZipFileToDelta(File zipfileToMerge, String baseFolderToStrip, String newBasePath) {
        this.deltaEntries.add(new MergeEntry(true, zipfileToMerge, baseFolderToStrip == null ? null : DeltaAssetFileBuilder.normalizePath(baseFolderToStrip), newBasePath));
    }

    public File createDeltaFile() throws IOException {
        this.createDeleteFile();
        if (this.deleteFile == null && this.deltaEntries.size() <= 1 && this.processedFiles.isEmpty()) {
            if (this.deltaEntries.size() == 1) {
                MergeEntry file0 = this.deltaEntries.get(0);
                if (file0.isZip() && file0.getRelativePath().length() == 0) {
                    File deltaFile = file0.getFile();
                    if (deltaFile.exists()) {
                        return deltaFile;
                    }
                    throw new IOException("The merge file could not be found.");
                }
            } else {
                return null;
            }
        }
        this.deltaFile = new File(this.mergeBase, "delta.zip");
        boolean completed = false;
        try {
            UtilitiesCommon.copyStreams(this.getDeltaStream(), new FileOutputStream(this.deltaFile), null, true, true);
            completed = true;
        }
        finally {
            if (completed) {
                DeltaAssetFileBuilder.deldir(this.zipBase, false);
                this.deltaEntries.clear();
                DeltaAssetFileBuilder.deldir(this.artifactBase, false);
                if (this.deleteFile != null) {
                    this.deleteFile.delete();
                }
                this.deleteFile = null;
                this.processedFiles.clear();
            } else {
                File df = this.deltaFile;
                this.deltaFile = null;
                df.delete();
            }
        }
        return this.deltaFile;
    }

    public InputStream getDeltaStream() throws IOException {
        this.createDeleteFile();
        if (this.deleteFile == null && this.deltaEntries.size() <= 1 && this.processedFiles.isEmpty()) {
            if (this.deltaEntries.size() == 1) {
                MergeEntry file0 = this.deltaEntries.get(0);
                if (file0.isZip() && file0.getRelativePath().length() == 0) {
                    File deltaFile = file0.getFile();
                    if (deltaFile.exists()) {
                        return new FileInputStream(deltaFile);
                    }
                    throw new IOException("The merge file could not be found.");
                }
            } else {
                return null;
            }
        }
        return new ParallelOutputStreamInputStream(new BaseParallelOutputStreamInputStream.OutputRunnable(){

            @Override
            public String getThreadName() {
                return "Create asset delta stream";
            }

            @Override
            public void run(OutputStream os) throws IOException {
                ZipOutputStream zos = null;
                byte[] buffer = new byte[10000];
                boolean completed = false;
                try {
                    zos = new ZipOutputStream(os);
                    if (DeltaAssetFileBuilder.this.deleteFile != null) {
                        DeltaAssetFileBuilder.writeFile(zos, DeltaAssetFileBuilder.this.deleteFile, DeltaAssetFileBuilder.DELETE_FILE, buffer);
                        DeltaAssetFileBuilder.this.processedFiles.add(DeltaAssetFileBuilder.DELETE_FILE);
                    }
                    ListIterator iter = DeltaAssetFileBuilder.this.deltaEntries.listIterator(DeltaAssetFileBuilder.this.deltaEntries.size());
                    while (iter.hasPrevious()) {
                        MergeEntry mfe = (MergeEntry)iter.previous();
                        if (mfe.isZip()) {
                            DeltaAssetFileBuilder.writeZip(zos, mfe.getFile(), mfe.getRelativePath(), buffer, DeltaAssetFileBuilder.this.processedFiles);
                            continue;
                        }
                        if (DeltaAssetFileBuilder.this.processedFiles.contains(mfe.getRelativePath())) continue;
                        DeltaAssetFileBuilder.writeFile(zos, mfe.getFile(), mfe.getRelativePath(), buffer);
                        DeltaAssetFileBuilder.this.processedFiles.add(mfe.getRelativePath());
                    }
                    completed = true;
                }
                catch (Throwable throwable) {
                    if (zos != null) {
                        try {
                            zos.close();
                        }
                        catch (IOException iOException) {}
                    }
                    if (completed) {
                        DeltaAssetFileBuilder.deldir(DeltaAssetFileBuilder.this.zipBase, false);
                        DeltaAssetFileBuilder.this.deltaEntries.clear();
                        DeltaAssetFileBuilder.deldir(DeltaAssetFileBuilder.this.artifactBase, false);
                        if (DeltaAssetFileBuilder.this.deleteFile != null) {
                            DeltaAssetFileBuilder.this.deleteFile.delete();
                        }
                        DeltaAssetFileBuilder.this.deleteFile = null;
                        DeltaAssetFileBuilder.this.processedFiles.clear();
                    }
                    throw throwable;
                }
                if (zos != null) {
                    try {
                        zos.close();
                    }
                    catch (IOException iOException) {}
                }
                if (completed) {
                    DeltaAssetFileBuilder.deldir(DeltaAssetFileBuilder.this.zipBase, false);
                    DeltaAssetFileBuilder.this.deltaEntries.clear();
                    DeltaAssetFileBuilder.deldir(DeltaAssetFileBuilder.this.artifactBase, false);
                    if (DeltaAssetFileBuilder.this.deleteFile != null) {
                        DeltaAssetFileBuilder.this.deleteFile.delete();
                    }
                    DeltaAssetFileBuilder.this.deleteFile = null;
                    DeltaAssetFileBuilder.this.processedFiles.clear();
                }
            }
        });
    }

    private static void writeFile(ZipOutputStream zos, File file, String name, byte[] buffer) throws IOException {
        FileInputStream fileIn = null;
        try {
            try {
                fileIn = new FileInputStream(file);
            }
            catch (FileNotFoundException fileNotFoundException) {
                if (fileIn != null) {
                    try {
                        ((InputStream)fileIn).close();
                    }
                    catch (IOException iOException) {}
                }
                zos.closeEntry();
                return;
            }
        }
        catch (Throwable throwable) {
            if (fileIn != null) {
                try {
                    ((InputStream)fileIn).close();
                }
                catch (IOException iOException) {}
            }
            zos.closeEntry();
            throw throwable;
        }
        ZipEntry entry = new ZipEntry(name);
        entry.setTime(file.lastModified());
        zos.putNextEntry(entry);
        UtilitiesCommon.copyStreams(fileIn, zos, buffer, true, false);
        fileIn = null;
        if (fileIn != null) {
            try {
                ((InputStream)fileIn).close();
            }
            catch (IOException iOException) {}
        }
        zos.closeEntry();
    }

    private static void writeZip(ZipOutputStream zos, File zip, String rootPath, byte[] buffer, Set processed) throws IOException {
        ZipFile zipFile = null;
        try {
            zipFile = new ZipFile(zip);
        }
        catch (FileNotFoundException fileNotFoundException) {
            if (zipFile != null) {
                try {
                    zipFile.close();
                }
                catch (IOException iOException) {}
            }
            return;
        }
        try {
            ZipEntry inEntry = null;
            Enumeration zipEntries = zipFile.entries();
            while (zipEntries.hasMoreElements()) {
                String name;
                inEntry = (ZipEntry)zipEntries.nextElement();
                String string = name = rootPath.length() == 0 ? inEntry.getName() : String.valueOf(rootPath) + '/' + inEntry.getName();
                if (processed.contains(name)) continue;
                ZipEntry newEntry = ZipEntry.createZipEntry(name, inEntry);
                zos.putNextEntry(newEntry);
                if (!inEntry.isDirectory()) {
                    InputStream zin = zipFile.getInputStream(inEntry);
                    UtilitiesCommon.copyStreams(zin, zos, buffer, true, false);
                }
                zos.closeEntry();
                processed.add(name);
            }
        }
        catch (Throwable throwable) {
            if (zipFile != null) {
                try {
                    zipFile.close();
                }
                catch (IOException iOException) {}
            }
            throw throwable;
        }
        if (zipFile != null) {
            try {
                zipFile.close();
            }
            catch (IOException iOException) {}
        }
    }

    public void updateDeleteFile(Collection<String> paths) throws IOException {
        if (paths.isEmpty()) {
            return;
        }
        this.deleteFileCreated = false;
        for (String path : paths) {
            if (path.length() > 0 && path.charAt(0) == '/') {
                this.deletedFiles.add(path.substring(1));
                continue;
            }
            this.deletedFiles.add(path);
        }
    }

    public Set<String> getDeletedFiles() {
        return this.unmodifiedDeletedFiles;
    }

    public InputStream getArtifactStream(String artifactPath, String artifactName) {
        InputStreamInformation ifs = this.getArtifactStreamInformation(artifactPath, artifactName);
        return ifs != null ? ifs.getIs() : null;
    }

    /*
     * Exception decompiling
     */
    public InputStreamInformation getArtifactStreamInformation(String artifactPath, String artifactName) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void createDeleteFile() throws IOException {
        if (!this.deletedFiles.isEmpty() && !this.deleteFileCreated) {
            if (this.deleteFile != null) {
                this.deleteFile.delete();
                this.deleteFile = null;
            }
            if (this.update) {
                this.deleteFile = File.createTempFile("delete", ".txt", this.mergeBase);
                BufferedWriter writer = null;
                try {
                    writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.deleteFile), "UTF-8"));
                    for (String path : this.deletedFiles) {
                        writer.write(path);
                        writer.newLine();
                    }
                }
                finally {
                    if (writer != null) {
                        writer.close();
                    }
                }
            }
            this.processedFiles.addAll(this.deletedFiles);
            this.deleteFileCreated = true;
        }
    }

    public static boolean mergeZips(File baseDir, File zipFile) {
        boolean result = false;
        if (baseDir == null) {
            return result;
        }
        try {
            ZipOutputStream zos = null;
            try {
                zos = new ZipOutputStream(new FileOutputStream(zipFile));
                result = DeltaAssetFileBuilder.mergeZips(baseDir, zos, baseDir.getAbsolutePath().length());
            }
            finally {
                if (zos != null) {
                    zos.close();
                }
            }
        }
        catch (ZipException zipException) {
        }
        catch (IOException iOException) {}
        if (!zipFile.exists()) {
            result = false;
        }
        return result;
    }

    /*
     * Unable to fully structure code
     */
    public static boolean mergeZips(File[] files, File zipFile) {
        result = false;
        try {
            zos = null;
            try {
                zos = new ZipOutputStream(new FileOutputStream(zipFile));
                buffer = new byte[100000];
                zip = null;
                i = 0;
                while (i < files.length) {
                    block26: {
                        block25: {
                            if (files[i] != null) break block25;
                            ** if (zip == null) goto lbl-1000
lbl-1000:
                            // 1 sources

                            {
                                zip.close();
                            }
lbl-1000:
                            // 2 sources

                            {
                                break block26;
                            }
                        }
                        try {
                            zip = new ZipFile(files[i]);
                            entries = zip.entries();
                            while (entries.hasMoreElements()) {
                                entry = (ZipEntry)entries.nextElement();
                                is = null;
                                try {
                                    is = zip.getInputStream(entry);
                                    tmpEntry = ZipEntry.createZipEntry(entry);
                                    zos.putNextEntry(tmpEntry);
                                    UtilitiesCommon.copyStreams(is, zos, buffer, true, false);
                                    result = true;
                                }
                                finally {
                                    zos.closeEntry();
                                    if (is != null) {
                                        is.close();
                                    }
                                }
                            }
                        }
                        catch (ZipException v0) {
                            if (zip != null) {
                                zip.close();
                            }
                            break block26;
                        }
                        catch (IOException v1) {
                            try {
                                break block26;
                            }
                            catch (Throwable var12_12) {
                                throw var12_12;
                            }
                            finally {
                                if (zip != null) {
                                    zip.close();
                                }
                            }
                        }
                        if (zip == null) break block26;
                        zip.close();
                    }
                    ++i;
                }
            }
            finally {
                if (zos != null) {
                    zos.close();
                }
            }
        }
        catch (ZipException v2) {
        }
        catch (IOException v3) {}
        if (!zipFile.exists()) {
            result = false;
        }
        return result;
    }

    public static boolean populateZip(File baseDir, File zipFile) throws IOException {
        boolean result = false;
        if (baseDir == null) {
            return result;
        }
        String[] files = baseDir.list();
        if (files == null || files.length == 0) {
            return result;
        }
        ZipOutputStream zos = null;
        try {
            zos = new ZipOutputStream(new FileOutputStream(zipFile));
            result = DeltaAssetFileBuilder.writeDirectory(baseDir, zos, baseDir.getAbsolutePath().length());
        }
        finally {
            if (zos != null) {
                zos.close();
            }
        }
        if (!zipFile.exists()) {
            result = false;
        }
        return result;
    }

    private static boolean mergeZips(File directory, ZipOutputStream zos, int basePathLength) {
        boolean result = false;
        if (!directory.isDirectory()) {
            return result;
        }
        byte[] buffer = new byte[100000];
        File[] files = directory.listFiles();
        int i = 0;
        while (i < files.length) {
            if (files[i].isDirectory()) {
                result = DeltaAssetFileBuilder.mergeZips(files[i], zos, basePathLength) || result;
            } else {
                try {
                    String path = files[i].getAbsolutePath().substring(basePathLength).replace('\\', '/');
                    int lastSlash = path.lastIndexOf(47);
                    if (lastSlash != -1) {
                        path = path.substring(0, lastSlash);
                    }
                    if (path.startsWith("/")) {
                        path = path.substring(1);
                    }
                    ZipFile zip = new ZipFile(files[i]);
                    try {
                        Enumeration entries = zip.entries();
                        while (entries.hasMoreElements()) {
                            ZipEntry entry = (ZipEntry)entries.nextElement();
                            InputStream is = null;
                            try {
                                is = zip.getInputStream(entry);
                                String entryPath = entry.getName();
                                if (path.length() > 0) {
                                    entryPath = String.valueOf(path) + "/" + entryPath;
                                }
                                ZipEntry zipEntry = ZipEntry.createZipEntry(entryPath, entry);
                                zos.putNextEntry(zipEntry);
                                UtilitiesCommon.copyStreams(is, zos, buffer, true, false);
                                result = true;
                            }
                            catch (Throwable throwable) {
                                if (is != null) {
                                    try {
                                        is.close();
                                    }
                                    catch (IOException iOException) {}
                                }
                                zos.closeEntry();
                                throw throwable;
                            }
                            if (is != null) {
                                try {
                                    is.close();
                                }
                                catch (IOException iOException) {}
                            }
                            zos.closeEntry();
                        }
                    }
                    catch (Throwable throwable) {
                        if (zip != null) {
                            try {
                                zip.close();
                            }
                            catch (IOException iOException) {}
                        }
                        throw throwable;
                    }
                    if (zip != null) {
                        try {
                            zip.close();
                        }
                        catch (IOException iOException) {}
                    }
                }
                catch (ZipException zipException) {
                }
                catch (IOException iOException) {}
            }
            ++i;
        }
        return result;
    }

    private static boolean writeDirectory(File directory, ZipOutputStream zos, int basePathLength) throws IOException {
        boolean result = false;
        if (!directory.isDirectory()) {
            return result;
        }
        byte[] buffer = new byte[1024];
        File[] files = directory.listFiles();
        int i = 0;
        while (i < files.length) {
            if (files[i].isDirectory()) {
                result = result || DeltaAssetFileBuilder.writeDirectory(files[i], zos, basePathLength);
            } else {
                FileInputStream fis = null;
                try {
                    int length;
                    fis = new FileInputStream(files[i]);
                    String path = files[i].getAbsolutePath().substring(basePathLength).replace('\\', '/');
                    if (path.startsWith("/")) {
                        path = path.substring(1);
                    }
                    ZipEntry zipEntry = new ZipEntry(path);
                    zipEntry.setTime(files[i].lastModified());
                    zos.putNextEntry(zipEntry);
                    while ((length = fis.read(buffer)) > 0) {
                        zos.write(buffer, 0, length);
                    }
                    result = true;
                }
                catch (Throwable throwable) {
                    if (fis != null) {
                        try {
                            fis.close();
                        }
                        catch (IOException iOException) {}
                    }
                    zos.closeEntry();
                    throw throwable;
                }
                if (fis != null) {
                    try {
                        fis.close();
                    }
                    catch (IOException iOException) {}
                }
                zos.closeEntry();
            }
            ++i;
        }
        return result;
    }

    private static class MergeEntry {
        private final boolean zip;
        private File file;
        private String relativePath;

        public MergeEntry(boolean zip, File file, String basePath, String newBase) {
            this.zip = zip;
            this.file = file;
            if (basePath == null) {
                this.relativePath = zip ? "" : file.getName();
            } else {
                String path = DeltaAssetFileBuilder.normalizePath(zip ? file.getParent() : file.getAbsolutePath());
                if (!path.startsWith(basePath)) {
                    throw new IllegalArgumentException("path=\"" + path + "\" basePath=\"" + basePath + "\"");
                }
                if (basePath.endsWith("/")) {
                    this.relativePath = path.length() == basePath.length() ? "" : path.substring(basePath.length());
                } else {
                    String string = this.relativePath = path.length() == basePath.length() ? "" : path.substring(basePath.length() + 1);
                }
            }
            if (newBase.length() > 0) {
                this.relativePath = this.relativePath.length() > 0 ? String.valueOf(newBase) + '/' + this.relativePath : newBase;
            }
        }

        public MergeEntry(File file, String fileRename) {
            this.zip = false;
            this.file = file;
            this.relativePath = DeltaAssetFileBuilder.normalizePath(fileRename);
            if (new File(this.relativePath).isAbsolute()) {
                throw new IllegalArgumentException(" File rename must be relative: \"" + fileRename + '\"');
            }
        }

        public File getFile() {
            return this.file;
        }

        public String getRelativePath() {
            return this.relativePath;
        }

        public boolean isZip() {
            return this.zip;
        }
    }
}

