/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ram.fix;

import com.ibm.ram.fix.Apply;
import com.ibm.ram.fix.Fixes;
import com.ibm.ram.fix.FixesSysout;
import com.ibm.ram.fix.FolderFileAccess;
import com.ibm.ram.fix.ZipFileAccess;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.ZipException;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.SAXException;

public class Main {
    private static final String VERSION = "3.2.2";

    public static void main(String[] args) {
        block38: {
            int arglength = args.length;
            if (arglength < 1) {
                Main.printHelp();
                return;
            }
            if ("apply".equalsIgnoreCase(args[0])) {
                Map<String, String> moduleMap = Collections.emptyMap();
                int argndx = 0;
                boolean tomcat = false;
                if (arglength > 2 && "tomcat".equalsIgnoreCase(args[argndx + 1])) {
                    argndx = 1;
                    --arglength;
                    tomcat = true;
                }
                File testfix = new File(args[argndx + 1]);
                File to = arglength > 2 ? new File(args[argndx + 2]) : new File(".");
                File work = arglength > 3 ? new File(args[argndx + 3]) : null;
                if (tomcat) {
                    moduleMap = new HashMap();
                    if (to.isDirectory()) {
                        File lib = new File(to, "lib");
                        if (lib.exists()) {
                            if (!new File(lib, "com.ibm.ram.common.jar").exists()) {
                                System.err.println("Cannot apply. This Tomcat installation doesn't have any of the lib.zip files installed.");
                                Main.printHelp();
                                return;
                            }
                            moduleMap.put("lib", "lib");
                            if (!new File(lib, "tomcat-jdbc.jar").exists()) {
                                moduleMap.put("lib.v6", "lib");
                            } else {
                                moduleMap.put("lib.v6", null);
                            }
                            File war = new File(to, "webapps/ram");
                            if (!war.exists()) {
                                System.err.println("Couldn't find a webapps/ram to apply update to.");
                                Main.printHelp();
                                return;
                            }
                            war = new File(to, "webapps/ram.ws");
                            if (!war.exists()) {
                                System.err.println("Couldn't find a webapps/ram.ws to apply update to.");
                                Main.printHelp();
                                return;
                            }
                        } else {
                            int nullcnt = 0;
                            File zip = new File(to, "com.ibm.ram.repository.web.tomcat_runtime.war");
                            if (zip.exists()) {
                                moduleMap.put("webapps/ram", "com.ibm.ram.repository.web.tomcat_runtime.war");
                            } else {
                                zip = new File(to, "ram.war");
                                if (zip.exists()) {
                                    moduleMap.put("webapps/ram", "ram.war");
                                    System.out.println("Found ram.war and will update that instead of default com.ibm.ram.repository.web.tomcat_runtime.war.");
                                } else {
                                    moduleMap.put("webapps/ram", null);
                                    System.out.println("Could not find a ram.war or com.ibm.ram.repository.web.tomcat_runtime.war so this war update will be skipped.");
                                    ++nullcnt;
                                }
                            }
                            zip = new File(to, "com.ibm.ram.repository.web.ws.tomcat_runtime.war");
                            if (zip.exists()) {
                                moduleMap.put("webapps/ram.ws", "com.ibm.ram.repository.web.ws.tomcat_runtime.war");
                            } else {
                                zip = new File(to, "ram.ws.war");
                                if (zip.exists()) {
                                    moduleMap.put("webapps/ram.ws", "ram.ws.war");
                                    System.out.println("Found ram.ws.war and will update that instead of default com.ibm.ram.repository.web.ws.tomcat_runtime.war.");
                                } else {
                                    moduleMap.put("webapps/ram.ws", null);
                                    System.out.println("Could not find a ram.ws.war or com.ibm.ram.repository.web.ws.tomcat_runtime.war so this war update will be skipped.");
                                    ++nullcnt;
                                }
                            }
                            zip = new File(to, "lib.zip");
                            if (zip.exists()) {
                                moduleMap.put("lib", "lib.zip");
                            } else {
                                moduleMap.put("lib", null);
                                System.out.println("Could not find lib.zip so this will be skipped.");
                                ++nullcnt;
                            }
                            zip = new File(to, "lib.v6.zip");
                            if (zip.exists()) {
                                moduleMap.put("lib.v6", "lib.v6.zip");
                            } else {
                                moduleMap.put("lib.v6", null);
                                System.out.println("Could not find lib.v6.zip so this will be skipped.");
                                ++nullcnt;
                            }
                            if (nullcnt == 4) {
                                System.err.println("Couldn't find any zip files to update for Tomcat.");
                                Main.printHelp();
                                return;
                            }
                        }
                    }
                    if (moduleMap.isEmpty()) {
                        moduleMap = Collections.emptyMap();
                    }
                }
                try {
                    Main.doApply(testfix, to, work, moduleMap);
                }
                catch (ZipException e) {
                    e.printStackTrace();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            } else if ("installed".equalsIgnoreCase(args[0])) {
                File testfix = new File(args[1]);
                if (!testfix.exists()) {
                    System.err.println("The fix file cannot be found. " + testfix);
                    Main.printHelp();
                    return;
                }
                FixesSysout fixes = null;
                try {
                    try {
                        fixes = testfix.isDirectory() ? new FixesSysout(new FolderFileAccess(testfix, null, null)) : new FixesSysout(new ZipFileAccess(testfix, null, null));
                        System.out.println("List installed fixes for " + testfix);
                        Fixes.logFixes(fixes.getInstalledFixes(), fixes);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                        Apply.close(fixes);
                        break block38;
                    }
                }
                catch (Throwable throwable) {
                    Apply.close(fixes);
                    throw throwable;
                }
                Apply.close(fixes);
            } else {
                Main.printHelp();
            }
        }
    }

    private static void doApply(File testfix, File to, File work, Map<String, String> moduleMap) throws ZipException, IOException {
        System.out.println("Applying fix " + testfix + " to " + to);
        Apply apply = new Apply(testfix, to, work, moduleMap);
        try {
            Collection<String> msgs = apply.apply();
            if (msgs.isEmpty()) {
                System.out.println("Application of " + testfix + " was succesful.");
            } else {
                System.out.println("Application of " + testfix + " was not completely succesful. The messages are:");
                for (String msg : msgs) {
                    System.out.print(" ");
                    System.out.println(msg);
                }
            }
        }
        catch (ZipException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
    }

    private static void printHelp() {
        System.out.print("Version: ");
        System.out.println(VERSION);
        System.out.println();
        System.out.println("Apply Tomcat - To apply a Tomcat fix:");
        System.out.println("Call with:");
        System.out.println("apply tomcat fix {to} {work}");
        System.out.println("{...} means optional. Do not include the braces, they are only for showing optional.");
        System.out.println("Cannot omit an earlier argument if a trailing argument is being supplied.");
        System.out.println("If any argument contains spaces then it must be quoted on the command line.");
        System.out.println("  fix - The tomcat fix zip file.");
        System.out.println("  to - The directory/zip file to apply the test fix to. The current directory if omitted. Use \".\" for current directory if supplying a following argument");
        System.out.println("       This should be either a Tomcat directory (i.e. the directory that contains the shared and webapps directories) to apply to.");
        System.out.println("       Or it should be a directory containing the four GA'ed zips (the com.ibm.ram.repository.web.ws.tomcat_runtime.war, com.ibm.ram.repository.web.tomcat_runtime.war, lib.zip, and and lib.v6.zip.");
        System.out.println("       In the case of the four zips it will update the zips to this fix so that the zips can be used to install a new Tomcat installation with the fix already applied.");
        System.out.println("  work - The directory where temporary work files will be created. If omitted then it defaults to \"java.io.tmpdir\" property.");
        System.out.println();
        System.out.println();
        System.out.println("Apply - To apply a fix:");
        System.out.println("Call with:");
        System.out.println("apply fix {to} {work}");
        System.out.println("{...} means optional. Do not include the braces, they are only for showing optional.");
        System.out.println("Cannot omit an earlier argument if a trailing argument is being supplied.");
        System.out.println("If any argument contains spaces then it must be quoted on the command line.");
        System.out.println("  fix - The fix zip file.");
        System.out.println("  to - The directory/zip file to apply the fix to. The current directory if omitted. Use \".\" for current directory if supplying a following argument");
        System.out.println("  work - The directory where temporary work files will be created. If omitted then it defaults to \"java.io.tmpdir\" property.");
        System.out.println();
        System.out.println();
        System.out.println("Installed - To see what fixes are installed:");
        System.out.println("Call with:");
        System.out.println("installed {root}");
        System.out.println("{...} means optional. Do not include the braces, they are only for showing optional.");
        System.out.println("  root - The root to see what is installed. The current directory if omitted.");
    }
}

