/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ram.fix;

import com.ibm.ram.fix.FileAccess;
import com.ibm.ram.fix.ZipAccess;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.zip.ZipException;
import java.util.zip.ZipOutputStream;

public class ZipFileAccess
extends ZipAccess {
    private final File zipfile;
    private File zipOutFile;

    public ZipFileAccess(File zipfile, byte[] copybuffer, File workDir) throws ZipException, IOException {
        super(zipfile, copybuffer, workDir);
        this.zipfile = zipfile;
    }

    ZipFileAccess(File zipfile, FileAccess nestedFA, String path) throws ZipException, IOException {
        super(zipfile, nestedFA, path);
        this.zipfile = zipfile;
    }

    @Override
    protected ZipOutputStream createZipOutputStream() throws IOException {
        if (this.zipOutFile != null) {
            throw new IllegalStateException("Already created zip out stream once for this zip: " + this.zipfile.getName());
        }
        this.zipOutFile = File.createTempFile(this.zipfile.getName(), null, this.zipfile.getParentFile());
        return new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(this.zipOutFile)));
    }

    @Override
    public void doFinish() throws IOException {
        super.doFinish();
        this.closeZipFile();
        this.closeZipout();
        if (this.zipOutFile != null) {
            File tmpFile = File.createTempFile(this.zipfile.getName(), null, this.zipfile.getParentFile());
            tmpFile.delete();
            try {
                if (!this.zipfile.renameTo(tmpFile)) {
                    throw new IOException("Couldn't rename " + this.zipfile.getName() + " to a backup name to allow replace update with changes.");
                }
                if (!this.zipOutFile.renameTo(this.zipfile)) {
                    if (tmpFile.renameTo(this.zipfile)) {
                        tmpFile = null;
                    }
                    throw new IOException("Couldn't rename the updated file for module " + this.zipfile.getName() + " to replace original with updates.");
                }
                this.zipOutFile = null;
            }
            finally {
                if (tmpFile != null) {
                    tmpFile.delete();
                }
            }
        }
    }

    @Override
    protected void doClose() throws IOException {
        super.doClose();
        if (this.zipOutFile != null) {
            this.zipOutFile.delete();
            this.zipOutFile = null;
        }
    }
}

