/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ram.internal.activities;

import com.ibm.ram.common.data.AssetActivity;
import com.ibm.ram.internal.activities.RAMActivityTeamInfo;
import com.ibm.ram.internal.common.util.Utilities;
import java.util.HashMap;
import java.util.Map;

public class AssetBuildActivity
extends AssetActivity {
    public static final String BUILD_ID = "BUILD_ID";
    public static final String TEAM_SERVER = "TEAM_SERVER";
    public static final String TEAM_AREA = "TEAM_AREA";
    public static final String TEAM_TYPE = "TEAM_TYPE";
    public static final int TYPEID = 621;
    private String artifact;
    private String buildId;
    private RAMActivityTeamInfo teamInfo = null;
    private String teamInfoString;

    public AssetBuildActivity(RAMActivityTeamInfo teamInfo) {
        this.teamInfo = teamInfo;
        this.setTypeId(621);
        this.initTeamInfoPropertiesString();
    }

    public AssetBuildActivity(String buildId, String artifact, String teamInfoString) {
        this.artifact = artifact;
        this.buildId = buildId;
        this.teamInfoString = teamInfoString;
        this.setTypeId(621);
        this.initTeamInfoFromString();
    }

    public AssetBuildActivity(String buildId, String artifact, RAMActivityTeamInfo teamInfo) {
        this.buildId = buildId;
        this.artifact = artifact;
        this.teamInfo = teamInfo;
        this.initTeamInfoPropertiesString();
        this.setTypeId(621);
    }

    public String getTeamInfo() {
        this.initTeamInfoPropertiesString();
        return this.teamInfoString;
    }

    public String getTeamServer() {
        String teamServer = null;
        if (this.teamInfo != null) {
            teamServer = this.teamInfo.getTeamServer();
        }
        return teamServer;
    }

    public String getTeamArea() {
        String teamArea = null;
        if (this.teamInfo != null) {
            teamArea = this.teamInfo.getTeamArea();
        }
        return teamArea;
    }

    public String getTeamType() {
        String obj;
        String teamType = null;
        if (this.teamInfo != null && (obj = this.teamInfo.getProperties().get(TEAM_TYPE)) != null) {
            teamType = obj;
        }
        return teamType;
    }

    public String getBuildId() {
        return this.buildId;
    }

    public String getArtifact() {
        return this.artifact;
    }

    public void setArtifact(String artifact) {
        this.artifact = artifact;
    }

    public void setBuildId(String buildId) {
        this.buildId = buildId;
    }

    private void initTeamInfoPropertiesString() {
        if (this.teamInfoString == null && this.teamInfo != null) {
            this.teamInfoString = Utilities.encodeToString(this.teamInfo.getProperties());
        }
    }

    private void initTeamInfoFromString() {
        if (this.teamInfoString != null) {
            this.teamInfo = new RAMActivityTeamInfo();
            Map decodedObj = (Map)Utilities.decodeFromString(this.teamInfoString);
            if (decodedObj != null) {
                this.teamInfo.initialize(decodedObj);
            }
        }
    }

    public static String serializeLongData(String buildId, RAMActivityTeamInfo teamInfo) {
        HashMap<? super String, String> map = new HashMap<String, String>();
        map.put(BUILD_ID, buildId);
        if (teamInfo != null) {
            map.putAll(teamInfo.getProperties());
        }
        return Utilities.encodeToString(map);
    }

    public String serializeLongData() {
        return AssetBuildActivity.serializeLongData(this.buildId, this.teamInfo);
    }

    public void setTeamInfo(String teamInfoString) {
        this.teamInfoString = teamInfoString;
        this.initTeamInfoFromString();
    }
}

