/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ram.internal.client.util;

import com.ibm.ram.common.util.UtilitiesCommon;
import com.ibm.ram.internal.common.util.RAMDateFormat;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.nio.charset.Charset;
import java.util.Date;
import java.util.StringTokenizer;

public class StringUtils {
    public static final String EMPTY_STRING = "";

    public static boolean equals(String s1, String s2) {
        return UtilitiesCommon.objectsEqual(s2, s1);
    }

    public static boolean isBlank(String s) {
        return UtilitiesCommon.isEmptyStringTrimmed(s);
    }

    public static String getCleanFileName(String s) {
        if (StringUtils.isBlank(s)) {
            return EMPTY_STRING;
        }
        char[] chars = s.toCharArray();
        boolean mod = false;
        int i = 0;
        while (i < chars.length) {
            if (chars[i] == '*' || chars[i] == '|' || chars[i] == '\\' || chars[i] == '/' || chars[i] == ':' || chars[i] == '\"' || chars[i] == '<' || chars[i] == '>' || chars[i] == '?' || chars[i] == '[' || chars[i] == ']') {
                chars[i] = 95;
                mod = true;
            }
            ++i;
        }
        return mod ? new String(chars) : s;
    }

    public static String cleanFromUnsuitableFilechars(String s) {
        if (StringUtils.isBlank(s)) {
            return EMPTY_STRING;
        }
        char[] chars = s.toCharArray();
        boolean mod = false;
        int i = 0;
        while (i < chars.length) {
            if (chars[i] != '-' && !Character.isJavaIdentifierPart(chars[i])) {
                chars[i] = 95;
                mod = true;
            }
            ++i;
        }
        return mod ? new String(chars) : s;
    }

    public static String getValidFileName(String s) {
        if (StringUtils.isBlank(s)) {
            return EMPTY_STRING;
        }
        String invalidChars = new String("\\/:;?\"<>|");
        char[] chars = s.toCharArray();
        boolean mod = false;
        int i = 0;
        while (i < chars.length) {
            if (invalidChars.indexOf(chars[i]) > -1) {
                chars[i] = 95;
                mod = true;
            }
            ++i;
        }
        return mod ? new String(chars) : s;
    }

    public static String cleanNewLines(String s) {
        String cleaned = null;
        if (s != null) {
            cleaned = s;
            StringTokenizer tokenizer = new StringTokenizer(s, "\r\n", false);
            if (tokenizer.countTokens() > 1) {
                cleaned = EMPTY_STRING;
                while (tokenizer.hasMoreTokens()) {
                    String token = tokenizer.nextToken();
                    cleaned = String.valueOf(cleaned) + token;
                }
            }
        }
        return cleaned;
    }

    public static String getStreamAsString(InputStream stream) throws IOException {
        StringWriter wtr = new StringWriter();
        UtilitiesCommon.copyReader(new InputStreamReader(stream, Charset.forName("UTF-8")), wtr, null, false, true);
        return wtr.toString();
    }

    public static String stripSlashSuffix(String url) {
        if (url == null) {
            return null;
        }
        if (url.endsWith("/")) {
            url = url.substring(0, url.length() - 1);
            return StringUtils.stripSlashSuffix(url);
        }
        return url.trim();
    }

    public static String stripSlashPrefix(String url) {
        String fixed = url;
        if (url != null && url.startsWith("/")) {
            fixed = url.substring(1);
        }
        return fixed;
    }

    public static String getDateDisplay(long date) {
        if (date < 0L) {
            return Long.toString(date);
        }
        return RAMDateFormat.getDateTimeInstance(1, 1).format(new Date(date));
    }
}

