/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ram.internal.common.bundles;

import com.ibm.ram.internal.common.bundles.AbstractMessages;
import com.ibm.ram.internal.common.util.SessionHandler;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class CommonMessages
extends AbstractMessages {
    public static final String STATE_SUBMITTED = "Submitted";
    public static final String STATE_DRAFT = "Draft";
    public static final String STATE_PLAN_REVIEW = "Plan review";
    public static final String STATE_REVIEW = "Review";
    public static final String STATE_EVALUATE_REVIEW = "Evaluate review";
    public static final String STATE_APPROVED = "Approved";
    public static final String STATE_RETIRED = "Retired";
    public static final String STATE_ASIS = "As is";
    public static final String STATE_ARCHIVED = "Archived";
    public static final String STATE_LOADED = "Loaded";
    public static final String STATE_UNLOADED = "Unloaded";
    public static final String STATE_NO_STATE = "[no state]";
    public static final String STATE_ERROR = "Error";
    public static final String REVIEW_STATUS_AWAITING_ACTION = "Awaiting action";
    public static final String REVIEW_STATUS_CLAIMED = "Claimed";
    public static final String REVIEW_STATUS_IN_PROGRESS = "In progress";
    public static final String REVIEW_STATUS_ACCEPTED = "Accepted";
    public static final String REVIEW_STATUS_REJECTED = "Rejected";
    public static final String STATE_DRAFT_KEY = "state_draft";
    public static final String STATE_PLAN_REVIEW_KEY = "state_plan_review";
    public static final String STATE_REVIEW_KEY = "state_review";
    public static final String STATE_EVALUATE_REVIEW_KEY = "state_evaluate_review";
    public static final String STATE_APPROVED_KEY = "state_approved";
    public static final String STATE_RETIRED_KEY = "state_retired";
    public static final String STATE_ASIS_KEY = "state_as_is";
    public static final String STATE_ARCHIVED_KEY = "state_archived";
    public static final String STATE_LOADED_KEY = "state_loaded";
    public static final String STATE_UNLOADED_KEY = "state_unloaded";
    public static final String STATE_NO_STATE_KEY = "state_no_state";
    public static final String STATE_ERROR_KEY = "state_error";
    public static final String REVIEW_STATUS_AWAITING_ACTION_KEY = "review_status_awaiting_action";
    public static final String REVIEW_STATUS_CLAIMED_KEY = "review_status_claimed";
    public static final String REVIEW_STATUS_IN_PROGRESS_KEY = "review_status_in_progress";
    public static final String REVIEW_STATUS_ACCEPTED_KEY = "review_status_accepted";
    public static final String REVIEW_STATUS_REJECTED_KEY = "review_status_rejected";
    public static final Map<String, String> STATUS_TO_KEY = new HashMap<String, String>();
    public static final String BUNDLE_NAME = "com.ibm.ram.internal.common.bundles.commonMessages";

    static {
        STATUS_TO_KEY.put(REVIEW_STATUS_AWAITING_ACTION, REVIEW_STATUS_AWAITING_ACTION_KEY);
        STATUS_TO_KEY.put(REVIEW_STATUS_CLAIMED, REVIEW_STATUS_CLAIMED_KEY);
        STATUS_TO_KEY.put(REVIEW_STATUS_IN_PROGRESS, REVIEW_STATUS_IN_PROGRESS_KEY);
        STATUS_TO_KEY.put(REVIEW_STATUS_ACCEPTED, REVIEW_STATUS_ACCEPTED_KEY);
        STATUS_TO_KEY.put(REVIEW_STATUS_REJECTED, REVIEW_STATUS_REJECTED_KEY);
    }

    public static String getString(String key, Locale locale) {
        return CommonMessages.getStringWithDefault(key, null, locale);
    }

    public static String getStringWithDefault(String key, String defaultString, Locale locale) {
        try {
            return ResourceBundle.getBundle(BUNDLE_NAME, locale == null ? SessionHandler.getSessionHandler().getLocale() : locale).getString(key);
        }
        catch (MissingResourceException missingResourceException) {
            return defaultString != null ? defaultString : String.valueOf('!') + key + '!';
        }
    }

    public static String getString(String key) {
        return CommonMessages.getString(key, null);
    }

    @Override
    public String getStringMethod(String key) {
        return CommonMessages.getString(key);
    }

    @Override
    public String getStringMethod(String key, Locale locale) {
        return CommonMessages.getString(key, locale);
    }

    @Override
    public String getStringWithDefaultMethod(String key, String defaultString, Locale locale) {
        return CommonMessages.getStringWithDefault(key, defaultString, locale);
    }

    public static String getNLSKey(String value) {
        return STATUS_TO_KEY.get(value);
    }

    public static String getDisplayName(String value, Locale locale) {
        String nlsKey = CommonMessages.getNLSKey(value);
        if (nlsKey == null) {
            return value;
        }
        return CommonMessages.getString(nlsKey, locale);
    }

    public static String getDisplayName(String value) {
        return CommonMessages.getDisplayName(value, CommonMessages.getSupportedLocale(SessionHandler.getSessionHandler().getLocale()));
    }
}

