/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ram.internal.common.logging;

import java.io.File;
import java.io.IOException;
import org.apache.log4j.Layout;
import org.apache.log4j.RollingFileAppender;
import org.apache.log4j.helpers.CountingQuietWriter;
import org.apache.log4j.helpers.LogLog;

public class RAMRollingFileAppender
extends RollingFileAppender {
    public RAMRollingFileAppender() {
    }

    public RAMRollingFileAppender(Layout layout, String filename) throws IOException {
        super(layout, filename);
    }

    public RAMRollingFileAppender(Layout layout, String filename, boolean append) throws IOException {
        super(layout, filename, append);
    }

    public void rollOver() {
        LogLog.debug((String)("rolling over count=" + ((CountingQuietWriter)this.qw).getCount()));
        LogLog.debug((String)("maxBackupIndex=" + this.maxBackupIndex));
        if (this.maxBackupIndex > 0) {
            File target;
            String extension;
            String fn;
            int extNdx = this.fileName.lastIndexOf(46);
            if (extNdx > -1) {
                fn = this.fileName.substring(0, extNdx);
                extension = this.fileName.substring(extNdx);
            } else {
                fn = this.fileName;
                extension = "";
            }
            File file = new File(String.valueOf(fn) + '.' + this.maxBackupIndex + extension);
            if (file.exists()) {
                file.delete();
            }
            int i = this.maxBackupIndex - 1;
            while (i >= 1) {
                file = new File(String.valueOf(fn) + '.' + i + extension);
                if (file.exists()) {
                    target = new File(String.valueOf(fn) + '.' + (i + 1) + extension);
                    LogLog.debug((String)("Renaming file " + file + " to " + target));
                    file.renameTo(target);
                }
                --i;
            }
            target = new File(String.valueOf(fn) + "." + 1 + extension);
            this.closeFile();
            file = new File(this.fileName);
            LogLog.debug((String)("Renaming file " + file + " to " + target));
            file.renameTo(target);
        }
        try {
            this.setFile(this.fileName, false, this.bufferedIO, this.bufferSize);
        }
        catch (IOException e) {
            LogLog.error((String)("setFile(" + this.fileName + ", false) call failed."), (Throwable)e);
        }
    }
}

