/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ram.internal.common.util;

import java.io.IOException;
import java.nio.Buffer;

public abstract class BufferPipe<B extends Buffer> {
    private final int buffersize;
    private final int maxBufferCount;
    private int bufferAllocatedCount;
    public static final int GOOD_CLOSE = 0;
    public static final int NOT_GOOD_CLOSE = -23;
    public static final int READ_PIPE_CLOSED = -24;
    public static final int NOT_CLOSED = -1;
    private int putClosed = -1;
    private int getClosed = -1;
    private Queue freeBufferQ = new Queue();
    private Queue fullBufferQ = new Queue();

    protected abstract B[] createBufferQueue(int var1);

    public BufferPipe(int buffersize, int maxBufferCount) {
        this.buffersize = buffersize;
        this.maxBufferCount = maxBufferCount;
        if (maxBufferCount < 1) {
            throw new IllegalArgumentException("Buffer count must be at least one. (" + maxBufferCount + ')');
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getPutStatus() {
        Queue queue = this.fullBufferQ;
        synchronized (queue) {
            block4: {
                if (this.putClosed != 0 || this.fullBufferQ.size() <= 0) break block4;
                return -1;
            }
            return this.putClosed;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getGetStatus() {
        Queue queue = this.freeBufferQ;
        synchronized (queue) {
            return this.getClosed;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPutStatus(int status) {
        Queue queue = this.fullBufferQ;
        synchronized (queue) {
            this.putClosed = status;
            this.fullBufferQ.notifyQueue();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setGetStatus(int status) {
        Queue queue = this.freeBufferQ;
        synchronized (queue) {
            this.getClosed = status;
            this.freeBufferQ.notifyQueue();
        }
    }

    protected abstract B allocateBuffer(int var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public B getFree(long wait) {
        Object buff;
        Queue queue = this.freeBufferQ;
        synchronized (queue) {
            buff = this.freeBufferQ.get(0L);
            if (this.getGetStatus() != -1) {
                return null;
            }
        }
        if (buff == null && this.bufferAllocatedCount < this.maxBufferCount) {
            buff = this.allocateBuffer(this.buffersize);
            ++this.bufferAllocatedCount;
        }
        if (buff == null) {
            buff = this.freeBufferQ.get(wait);
        }
        return buff;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int waitForGetClose(long wait, int closeStatus) {
        this.setPutStatus(closeStatus);
        Queue queue = this.freeBufferQ;
        synchronized (queue) {
            if (this.getGetStatus() == -1) {
                this.freeBufferQ.get(wait);
            }
            return this.getGetStatus();
        }
    }

    public void putFull(B buff) {
        this.fullBufferQ.put(buff);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public B getFull(long wait) {
        Queue queue = this.fullBufferQ;
        synchronized (queue) {
            return this.getPutStatus() == -1 ? (B)this.fullBufferQ.get(wait) : null;
        }
    }

    public void putFree(B buff) {
        ((Buffer)buff).clear();
        this.freeBufferQ.put(buff);
    }

    private class Queue {
        private B[] queue;
        private int nextGet;
        private int nextPut;

        public Queue() {
            this.queue = BufferPipe.this.createBufferQueue(2);
        }

        public synchronized void notifyQueue() {
            this.notifyAll();
        }

        public synchronized int size() {
            return this.nextPut >= this.nextGet ? this.nextPut - this.nextGet : this.queue.length - this.nextGet + this.nextPut;
        }

        public synchronized B get(long wait) {
            if (this.nextGet == this.nextPut && wait != 0L) {
                while (true) {
                    try {
                        if (wait == -1L) {
                            this.wait();
                            break;
                        }
                        this.wait(wait);
                    }
                    catch (InterruptedException interruptedException) {
                        continue;
                    }
                    break;
                }
            }
            if (this.nextGet != this.nextPut) {
                Object buf = this.queue[this.nextGet++];
                if (this.nextGet >= this.queue.length) {
                    this.nextGet = 0;
                }
                return buf;
            }
            return null;
        }

        public synchronized void put(B buf) {
            this.queue[this.nextPut++] = buf;
            if (this.nextPut >= this.queue.length) {
                this.nextPut = 0;
            }
            if (this.nextPut == this.nextGet) {
                Buffer[] newQ = BufferPipe.this.createBufferQueue(this.queue.length * 2);
                int bufcnt = this.queue.length - this.nextGet;
                System.arraycopy(this.queue, this.nextGet, newQ, 0, bufcnt);
                System.arraycopy(this.queue, 0, newQ, bufcnt, this.nextPut);
                this.nextPut = this.queue.length;
                this.nextGet = 0;
                this.queue = newQ;
            }
            this.notifyAll();
        }
    }

    public static class ReaderClosedException
    extends IOException {
        private static final long serialVersionUID = 1L;

        public ReaderClosedException(String msg) {
            super(msg);
        }
    }
}

