/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ram.internal.common.util;

import com.ibm.ram.common.util.UtilitiesCommon;
import com.ibm.ram.internal.common.util.BufferPipe;
import com.ibm.ram.internal.common.util.CharBufferPipe;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.nio.CharBuffer;
import java.util.Map;
import org.apache.log4j.Logger;
import org.eclipse.emf.ecore.xmi.XMLResource;

public class ParallelWriterReader
extends Reader {
    private static Logger LOGGER = Logger.getLogger(ParallelWriterReader.class);
    private CharBufferPipe pipe = new CharBufferPipe(1000, 2);
    private Thread saveThread;
    private long bytesWritten = -1L;
    private long charsRead = -1L;
    private CharBuffer readBuffer;
    private boolean eofRead;

    public ParallelWriterReader(XMLResource res) {
        this(new XMLResourceWriterRunnable(res));
    }

    public ParallelWriterReader(final WriterRunnable runnable) {
        String tname = runnable.getThreadName();
        if (UtilitiesCommon.isEmptyString(tname)) {
            tname = "Parallel Writer thread.";
        }
        this.saveThread = new Thread(tname){
            final CharBufferPipe outpipe;
            {
                super($anonymous0);
                this.outpipe = ParallelWriterReader.this.pipe;
            }

            /*
             * Loose catch block
             */
            @Override
            public void run() {
                block39: {
                    Writer wrtr = new Writer(){
                        private CharBuffer writeBuffer;

                        private void getBuffer() throws IOException {
                            if (this.writeBuffer != null) {
                                return;
                            }
                            this.writeBuffer = (CharBuffer)outpipe.getFree(-1L);
                            if (this.writeBuffer == null) {
                                if (outpipe.getGetStatus() == -24) {
                                    throw new BufferPipe.ReaderClosedException("Reader closed without error before reading all of the data.");
                                }
                                LOGGER.error((Object)("Read side of parallel output prematurely closed with status " + outpipe.getGetStatus()));
                                throw new IOException("Read side of parallel output prematurely closed with status " + outpipe.getGetStatus());
                            }
                        }

                        private void putBuffer() {
                            if (this.writeBuffer == null || this.writeBuffer.position() == 0) {
                                return;
                            }
                            if (outpipe.getGetStatus() == -1) {
                                this.writeBuffer.flip();
                                ParallelWriterReader parallelWriterReader = ParallelWriterReader.this;
                                parallelWriterReader.bytesWritten = parallelWriterReader.bytesWritten + (long)this.writeBuffer.limit();
                                outpipe.putFull(this.writeBuffer);
                            } else {
                                outpipe.putFree(this.writeBuffer);
                            }
                            this.writeBuffer = null;
                        }

                        @Override
                        public void write(int b) throws IOException {
                            this.getBuffer();
                            this.writeBuffer.put((char)b);
                            if (!this.writeBuffer.hasRemaining()) {
                                this.putBuffer();
                            }
                        }

                        @Override
                        public void write(char[] b, int off, int len) throws IOException {
                            while (len > 0) {
                                this.getBuffer();
                                int copyAmount = Math.min(this.writeBuffer.remaining(), len);
                                this.writeBuffer.put(b, off, copyAmount);
                                off += copyAmount;
                                len -= copyAmount;
                                if (this.writeBuffer.hasRemaining()) continue;
                                this.putBuffer();
                            }
                        }

                        @Override
                        public void write(String str, int off, int len) throws IOException {
                            while (len > 0) {
                                this.getBuffer();
                                int copyAmount = Math.min(this.writeBuffer.remaining(), len);
                                this.writeBuffer.put(str, off, off + copyAmount);
                                off += copyAmount;
                                len -= copyAmount;
                                if (this.writeBuffer.hasRemaining()) continue;
                                this.putBuffer();
                            }
                        }

                        @Override
                        public void flush() throws IOException {
                            this.putBuffer();
                        }

                        @Override
                        public void close() throws IOException {
                            this.putBuffer();
                        }
                    };
                    boolean finished = false;
                    try {
                        runnable.run(wrtr);
                        finished = true;
                    }
                    catch (BufferPipe.ReaderClosedException e) {
                        LOGGER.info((Object)e.getMessage());
                        try {
                            wrtr.close();
                        }
                        catch (BufferPipe.ReaderClosedException readerClosedException) {
                        }
                        catch (IOException e2) {
                            LOGGER.error((Object)"Error closing writing resource stream.", (Throwable)e2);
                            finished = false;
                        }
                        if (!finished) {
                            if (this.outpipe.getGetStatus() != -24) {
                                LOGGER.error((Object)("Put side closed with error status " + this.outpipe.getGetStatus()));
                            }
                            this.outpipe.setPutStatus(-23);
                        } else {
                            this.outpipe.setPutStatus(0);
                        }
                        break block39;
                    }
                    catch (IOException e) {
                        LOGGER.error((Object)"Error writing.", (Throwable)e);
                        try {
                            wrtr.close();
                        }
                        catch (BufferPipe.ReaderClosedException readerClosedException) {
                        }
                        catch (IOException e3) {
                            LOGGER.error((Object)"Error closing writing resource stream.", (Throwable)e3);
                            finished = false;
                        }
                        if (!finished) {
                            if (this.outpipe.getGetStatus() != -24) {
                                LOGGER.error((Object)("Put side closed with error status " + this.outpipe.getGetStatus()));
                            }
                            this.outpipe.setPutStatus(-23);
                        } else {
                            this.outpipe.setPutStatus(0);
                        }
                        break block39;
                    }
                    catch (RuntimeException e) {
                        LOGGER.error((Object)"Error writing.", (Throwable)e);
                        {
                            catch (Throwable throwable) {
                                try {
                                    wrtr.close();
                                }
                                catch (BufferPipe.ReaderClosedException readerClosedException) {
                                }
                                catch (IOException e4) {
                                    LOGGER.error((Object)"Error closing writing resource stream.", (Throwable)e4);
                                    finished = false;
                                }
                                if (!finished) {
                                    if (this.outpipe.getGetStatus() != -24) {
                                        LOGGER.error((Object)("Put side closed with error status " + this.outpipe.getGetStatus()));
                                    }
                                    this.outpipe.setPutStatus(-23);
                                } else {
                                    this.outpipe.setPutStatus(0);
                                }
                                throw throwable;
                            }
                        }
                        try {
                            wrtr.close();
                        }
                        catch (BufferPipe.ReaderClosedException readerClosedException) {
                        }
                        catch (IOException e5) {
                            LOGGER.error((Object)"Error closing writing resource stream.", (Throwable)e5);
                            finished = false;
                        }
                        if (!finished) {
                            if (this.outpipe.getGetStatus() != -24) {
                                LOGGER.error((Object)("Put side closed with error status " + this.outpipe.getGetStatus()));
                            }
                            this.outpipe.setPutStatus(-23);
                        } else {
                            this.outpipe.setPutStatus(0);
                        }
                        break block39;
                    }
                    try {
                        wrtr.close();
                    }
                    catch (BufferPipe.ReaderClosedException readerClosedException) {
                    }
                    catch (IOException e) {
                        LOGGER.error((Object)"Error closing writing resource stream.", (Throwable)e);
                        finished = false;
                    }
                    if (!finished) {
                        if (this.outpipe.getGetStatus() != -24) {
                            LOGGER.error((Object)("Put side closed with error status " + this.outpipe.getGetStatus()));
                        }
                        this.outpipe.setPutStatus(-23);
                    } else {
                        this.outpipe.setPutStatus(0);
                    }
                }
            }
        };
        this.saveThread.start();
    }

    private boolean getBuffer() throws IOException {
        int pipeStatus;
        if (this.eofRead) {
            return true;
        }
        if (this.readBuffer != null && this.readBuffer.hasRemaining()) {
            return false;
        }
        if (this.readBuffer != null) {
            this.pipe.putFree(this.readBuffer);
            this.readBuffer = null;
        }
        block4: while (true) {
            pipeStatus = this.pipe.getPutStatus();
            switch (pipeStatus) {
                case -1: {
                    this.readBuffer = (CharBuffer)this.pipe.getFull(-1L);
                    if (this.readBuffer == null) continue block4;
                    return false;
                }
                case 0: {
                    this.eofRead = true;
                    return true;
                }
            }
            break;
        }
        LOGGER.error((Object)("Save of resource terminated early with status " + pipeStatus));
        throw new IOException("Save of resource terminated early with status " + pipeStatus);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public int read() throws IOException {
        try {
            if (this.getBuffer()) {
                return -1;
            }
            try {
                ++this.charsRead;
                char c = this.readBuffer.get();
                return c;
            }
            finally {
                this.returnEmptyBuffer();
            }
        }
        catch (IOException e) {
            this.pipe.setGetStatus(-23);
            throw e;
        }
    }

    private void returnEmptyBuffer() {
        if (this.readBuffer != null && !this.readBuffer.hasRemaining()) {
            this.pipe.putFree(this.readBuffer);
            this.readBuffer = null;
        }
    }

    @Override
    public int read(char[] b, int off, int len) throws IOException {
        block4: {
            if (!this.getBuffer()) break block4;
            return -1;
        }
        try {
            int read = 0;
            while (len > 0) {
                if (this.getBuffer()) break;
                int copyAmount = Math.min(len, this.readBuffer.remaining());
                this.readBuffer.get(b, off, copyAmount);
                off += copyAmount;
                len -= copyAmount;
                read += copyAmount;
            }
            this.returnEmptyBuffer();
            this.charsRead += (long)read;
            return read;
        }
        catch (IOException e) {
            this.pipe.setGetStatus(-23);
            throw e;
        }
    }

    @Override
    public int read(CharBuffer target) throws IOException {
        block4: {
            if (!this.getBuffer()) break block4;
            return -1;
        }
        try {
            int read = 0;
            while (!this.getBuffer()) {
                int copyAmount = this.readBuffer.read(target);
                if (copyAmount == -1) continue;
                if (copyAmount == 0) break;
                read += copyAmount;
            }
            this.returnEmptyBuffer();
            this.charsRead += (long)read;
            return read;
        }
        catch (IOException e) {
            this.pipe.setGetStatus(-23);
            throw e;
        }
    }

    @Override
    public void close() throws IOException {
        if (this.pipe != null) {
            try {
                if (this.pipe.getGetStatus() == -1) {
                    if (!this.eofRead) {
                        if (LOGGER.isInfoEnabled()) {
                            LOGGER.info((Object)"Read side closed before reading all of the data.", (Throwable)new RuntimeException());
                        }
                        this.pipe.setGetStatus(-24);
                    } else if (this.pipe.getPutStatus() != 0) {
                        LOGGER.error((Object)("Read side closed with error due to put site closed with " + this.pipe.getPutStatus()));
                        this.pipe.setGetStatus(-23);
                    } else {
                        this.pipe.setGetStatus(0);
                    }
                    while (true) {
                        try {
                            this.saveThread.join(60000L);
                        }
                        catch (InterruptedException interruptedException) {
                            continue;
                        }
                        break;
                    }
                    if (this.saveThread.isAlive()) {
                        LOGGER.warn((Object)"Save resource thread wouldn't finish in one minute time");
                    }
                    if (this.pipe.getGetStatus() != 0) {
                        LOGGER.error((Object)"Save resource Inputstream did not close successfully");
                        throw new IOException("Save resource Inputstream did not close successfully");
                    }
                    if (this.pipe.getGetStatus() != -24 && this.bytesWritten != this.charsRead) {
                        LOGGER.error((Object)("Full amount not read: written=" + this.bytesWritten + " read=" + this.charsRead));
                    }
                }
            }
            finally {
                this.saveThread = null;
                this.pipe = null;
                this.readBuffer = null;
            }
        }
    }

    public static class StringWriterRunnable
    implements WriterRunnable {
        private final String threadname;
        private final Object object;

        public StringWriterRunnable(String threadname, Object object) {
            this.threadname = threadname;
            this.object = object;
        }

        @Override
        public String getThreadName() {
            return this.threadname;
        }

        @Override
        public void run(Writer writer) throws IOException {
            writer.write(String.valueOf(this.object));
        }
    }

    public static interface WriterRunnable {
        public String getThreadName();

        public void run(Writer var1) throws IOException;
    }

    public static class XMLResourceWriterRunnable
    implements WriterRunnable {
        private final XMLResource res;
        private final Map<?, ?> options;
        private final String threadName;

        public XMLResourceWriterRunnable(XMLResource res) {
            this(res, "Save Resource \"" + res.getURI() + "\"");
        }

        public XMLResourceWriterRunnable(XMLResource res, String threadName) {
            this(res, null, threadName);
        }

        public XMLResourceWriterRunnable(XMLResource res, Map<?, ?> options) {
            this(res, options, "Save Resource \"" + res.getURI() + "\"");
        }

        public XMLResourceWriterRunnable(XMLResource res, Map<?, ?> options, String threadName) {
            this.res = res;
            this.options = options;
            this.threadName = threadName;
        }

        @Override
        public String getThreadName() {
            return this.threadName;
        }

        @Override
        public void run(Writer writer) throws IOException {
            this.res.save(writer, this.options);
        }
    }
}

