/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ram.internal.common.util;

import com.ibm.ram.common.data.RelationshipInfo;
import com.ibm.ram.common.data.RelationshipRange;
import com.ibm.ram.common.util.UtilitiesCommon;
import com.ibm.ram.defaultprofile.RelatedAsset;
import com.ibm.ram.internal.common.util.Utilities;
import java.io.IOException;
import java.util.Arrays;
import java.util.Properties;
import java.util.regex.Pattern;

public class RelationshipRangeUtility {
    public static final char RANGE_START_INCLUDES = '[';
    public static final char RANGE_END_INCLUDES = ']';
    public static final char RANGE_START_EXCLUDES = '(';
    public static final char RANGE_END_EXCLUDES = ')';
    public static final String ALL_ARE_RANGE_INVALID = "<There are no assets visible within the range>";
    public static final String RETIRED = "<Retired>";
    private static final String RANGE_PROPERTY_NAME = "com.ibm.ram.asset.related.range";
    private static final String RANGE_TYPE_PROPERTY_NAME = "com.ibm.ram.asset.related.rangeType";
    private static final String REVERSE_RANGE_RELATIONSHIP_VALUE = "reverse";
    public static final String REVERSE_RANGE_RELATIONSHIP = "com.ibm.ram.asset.related.range=reverse";
    private static final String RELATIONSHIP_IDENTIFIER = "com.ibm.ram.asset.related.id";
    private static final String RELATIONSHIP_STATE_IDENTIFIER = "com.ibm.ram.asset.related.stateid";
    private static final String RELATIONSHIP_SOURCE = "com.ibm.ram.asset.related.source";
    private static final String RELATIONSHIP_ASSET_DBID = "com.ibm.ram.asset.related.asset.dbid";
    private static final Pattern RELATIONSHIP_INFO_PATTERN = Pattern.compile("com\\.ibm\\.ram\\.asset\\.related\\.\\S+?=");

    public static RelationshipRange getRange(RelatedAsset relatedAsset) {
        if (RelationshipRangeUtility.isRangeRelationship(relatedAsset)) {
            return RelationshipRangeUtility.parseRange(relatedAsset.getDescription().getValue()).getRange();
        }
        return null;
    }

    public static RelationshipInfo getInfo(RelatedAsset relatedAsset) {
        if (RelationshipRangeUtility.isRelationshipInfo(relatedAsset)) {
            return RelationshipRangeUtility.parseRange(relatedAsset.getDescription().getValue());
        }
        return null;
    }

    public static boolean isRangeRelationship(RelatedAsset relatedAsset) {
        if (relatedAsset.getDescription() != null && relatedAsset.getDescription().getValue() != null) {
            return RelationshipRangeUtility.isRangeRelationship(relatedAsset.getDescription().getValue());
        }
        return false;
    }

    private static boolean isRangeRelationship(String range) {
        int index;
        return range != null && (index = range.indexOf(RANGE_TYPE_PROPERTY_NAME)) != -1;
    }

    public static boolean isRelationshipInfo(RelatedAsset relatedAsset) {
        if (relatedAsset.getDescription() != null && relatedAsset.getDescription().getValue() != null) {
            return RelationshipRangeUtility.isRelationshipInfo(relatedAsset.getDescription().getValue());
        }
        return false;
    }

    private static boolean isRelationshipInfo(String desc) {
        if (desc != null) {
            return RELATIONSHIP_INFO_PATTERN.matcher(desc).find();
        }
        return false;
    }

    private static RelationshipInfo parseRange(String range) {
        if (RelationshipRangeUtility.isRelationshipInfo(range)) {
            try {
                Properties properties = com.ibm.ram.internal.scm.Utilities.deSerializeProperties(range);
                String rangeValue = properties.getProperty(RANGE_PROPERTY_NAME);
                String typeValue = properties.getProperty(RANGE_TYPE_PROPERTY_NAME);
                String idValue = properties.getProperty(RELATIONSHIP_IDENTIFIER, "0");
                String stateidValue = properties.getProperty(RELATIONSHIP_STATE_IDENTIFIER, "0");
                String sourceValue = properties.getProperty(RELATIONSHIP_SOURCE, "false");
                String toassetValue = properties.getProperty(RELATIONSHIP_ASSET_DBID, "0");
                int id = 0;
                try {
                    id = Integer.valueOf(idValue);
                }
                catch (NumberFormatException numberFormatException) {}
                int stateid = 0;
                try {
                    stateid = Integer.valueOf(stateidValue);
                }
                catch (NumberFormatException numberFormatException) {}
                int toassetid = 0;
                try {
                    toassetid = Integer.valueOf(toassetValue);
                }
                catch (NumberFormatException numberFormatException) {}
                boolean source = Boolean.valueOf(sourceValue);
                boolean reverseRange = false;
                RelationshipRange relationshipRange = null;
                if (rangeValue != null) {
                    if (REVERSE_RANGE_RELATIONSHIP_VALUE.equals(rangeValue)) {
                        reverseRange = true;
                    } else if (typeValue != null) {
                        relationshipRange = new RelationshipRange(new RangeInfo(rangeValue), "Highest".equals(typeValue));
                    }
                }
                return new RelationshipInfo(id, stateid, toassetid, relationshipRange, source, reverseRange);
            }
            catch (IOException iOException) {
                return null;
            }
        }
        return null;
    }

    public static boolean isReverseRangeRelationship(RelatedAsset relatedAsset) {
        return relatedAsset != null && relatedAsset.getDescription() != null && relatedAsset.getDescription().getValue() != null && relatedAsset.getDescription().getValue().indexOf(REVERSE_RANGE_RELATIONSHIP) != -1;
    }

    public static String convertToString(RelationshipRange range) {
        if (range != null) {
            RangeInfo ri = range.getRangeInfo();
            String rangeType = null;
            rangeType = UtilitiesCommon.isEmptyString(range.getType()) ? "Highest" : range.getType();
            Properties properties = new Properties();
            properties.put(RANGE_PROPERTY_NAME, ri.toString());
            properties.put(RANGE_TYPE_PROPERTY_NAME, rangeType);
            try {
                return com.ibm.ram.internal.scm.Utilities.serializeProperties(properties);
            }
            catch (IOException iOException) {
                return null;
            }
        }
        return null;
    }

    public static String convertToString(RelationshipInfo relInfo) {
        if (relInfo == null || relInfo.getId() == 0 && relInfo.getRange() == null && !relInfo.isSource() && !relInfo.isReverseRange()) {
            return null;
        }
        Properties properties = new Properties();
        if (relInfo.isReverseRange()) {
            properties.put(RANGE_PROPERTY_NAME, REVERSE_RANGE_RELATIONSHIP_VALUE);
        } else {
            RelationshipRange range = relInfo.getRange();
            if (range != null) {
                RangeInfo ri = range.getRangeInfo();
                String rangeType = null;
                rangeType = UtilitiesCommon.isEmptyString(range.getType()) ? "Highest" : range.getType();
                properties.put(RANGE_PROPERTY_NAME, ri.toString());
                properties.put(RANGE_TYPE_PROPERTY_NAME, rangeType);
            }
        }
        if (relInfo.getId() != 0) {
            properties.put(RELATIONSHIP_IDENTIFIER, Integer.toString(relInfo.getId()));
        }
        if (relInfo.getStateId() != 0) {
            properties.put(RELATIONSHIP_STATE_IDENTIFIER, Integer.toString(relInfo.getStateId()));
        }
        if (relInfo.getToAssetId() != 0) {
            properties.put(RELATIONSHIP_ASSET_DBID, Integer.toString(relInfo.getToAssetId()));
        }
        if (relInfo.isSource() && !relInfo.isReverseRange()) {
            properties.put(RELATIONSHIP_SOURCE, Boolean.TRUE.toString());
        }
        try {
            return com.ibm.ram.internal.scm.Utilities.serializeProperties(properties);
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public static boolean isVersionInRange(RelationshipRange range, String version) {
        return range.getRangeInfo().isInRange(version);
    }

    public static class RangeInfo {
        private final Object[] fromVersion;
        private final Object[] toVersion;
        private final boolean fromIncludes;
        private final boolean toIncludes;

        public RangeInfo(String range) throws IllegalArgumentException {
            if (UtilitiesCommon.isEmptyString(range)) {
                this.toIncludes = true;
                this.fromIncludes = true;
                this.toVersion = null;
                this.fromVersion = null;
            } else {
                int start = 0;
                int end = range.length() - 1;
                if (range.charAt(0) == '[') {
                    this.fromIncludes = true;
                    start = 1;
                } else if (range.charAt(0) == '(') {
                    this.fromIncludes = false;
                    start = 1;
                } else {
                    this.fromIncludes = true;
                }
                if (range.charAt(end) == ']') {
                    this.toIncludes = true;
                } else if (range.charAt(end) == ')') {
                    this.toIncludes = false;
                } else {
                    this.toIncludes = true;
                    ++end;
                }
                int rangeSplit = range.indexOf(44, start);
                if (rangeSplit != -1) {
                    if (range.indexOf(44, rangeSplit + 1) != -1) {
                        throw new IllegalArgumentException("\"" + range + "\" is invalid. More than one ','.");
                    }
                    this.fromVersion = Utilities.getVersionArray(range.substring(start, rangeSplit));
                    this.toVersion = Utilities.getVersionArray(range.substring(rangeSplit + 1, end));
                } else if (start == 0) {
                    if (end == range.length()) {
                        this.fromVersion = Utilities.getVersionArray(range);
                        this.toVersion = null;
                    } else {
                        this.fromVersion = null;
                        this.toVersion = Utilities.getVersionArray(range.substring(0, end));
                    }
                } else {
                    throw new IllegalArgumentException("\"" + range + "\" is invalid. There is no to version.");
                }
            }
        }

        public RangeInfo(RelationshipRange relRange) {
            if (!UtilitiesCommon.isEmptyString(relRange.getLowestVersion())) {
                this.fromVersion = Utilities.getVersionArray(relRange.getLowestVersion());
                this.fromIncludes = relRange.isLowerVersionIncluded();
            } else {
                this.fromVersion = null;
                this.fromIncludes = true;
            }
            if (!UtilitiesCommon.isEmptyString(relRange.getHighestVersion())) {
                this.toVersion = Utilities.getVersionArray(relRange.getHighestVersion());
                this.toIncludes = relRange.isHigherVersionIncluded();
            } else {
                this.toVersion = null;
                this.toIncludes = true;
            }
        }

        public boolean isInRange(String version) {
            return this.isInRange(Utilities.getVersionArray(version));
        }

        public boolean isInRange(Object[] versionArray) {
            switch (Utilities.compareVersions(this.fromVersion, versionArray)) {
                case 1: {
                    return false;
                }
                case 0: {
                    if (this.fromIncludes) break;
                    return false;
                }
            }
            if (this.toVersion != null) {
                switch (Utilities.compareVersions(versionArray, this.toVersion)) {
                    case 1: {
                        return false;
                    }
                    case 0: {
                        return this.toIncludes;
                    }
                }
                return true;
            }
            return true;
        }

        public String toString() {
            if (this.fromVersion == null) {
                if (this.toVersion == null) {
                    return "";
                }
                return Utilities.getVersionString(this.toVersion, new StringBuilder()).append(this.toIncludes ? (char)']' : ')').toString();
            }
            if (this.toVersion == null) {
                return Utilities.getVersionString(this.fromVersion);
            }
            StringBuilder sb = new StringBuilder();
            sb.append(this.fromIncludes ? (char)'[' : '(');
            Utilities.getVersionString(this.fromVersion, sb).append(',');
            Utilities.getVersionString(this.toVersion, sb).append(this.toIncludes ? (char)']' : ')');
            return sb.toString();
        }

        public int hashCode() {
            return ((Arrays.hashCode(this.fromVersion) * 31 + Arrays.hashCode(this.toVersion)) * 31 + Boolean.valueOf(this.fromIncludes).hashCode()) * 31 + Boolean.valueOf(this.toIncludes).hashCode();
        }

        public boolean equals(Object obj) {
            if (super.equals(obj)) {
                return true;
            }
            if (!(obj instanceof RangeInfo)) {
                return false;
            }
            RangeInfo ori = (RangeInfo)obj;
            return Arrays.equals(this.fromVersion, ori.fromVersion) && Arrays.equals(this.toVersion, ori.toVersion) && this.fromIncludes == ori.fromIncludes && this.toIncludes == ori.toIncludes;
        }

        public static String createRange(String from, boolean fromIncludes, String to, boolean toIncludes) {
            if (to == null) {
                return from != null ? from : "";
            }
            StringBuilder sb = new StringBuilder();
            if (from != null) {
                if (from.indexOf(44) >= 0) {
                    throw new IllegalArgumentException("\"" + from + "\" is invalid. ',' is not valid in a range version.");
                }
                if (fromIncludes) {
                    sb.append('[');
                } else {
                    sb.append('(');
                }
                sb.append(from);
            }
            if (to != null) {
                if (to.indexOf(44) >= 0) {
                    throw new IllegalArgumentException("\"" + to + "\" is invalid. ',' is not valid in a range version.");
                }
                if (from != null) {
                    sb.append(',');
                }
                sb.append(to);
            }
            if (toIncludes) {
                sb.append(']');
            } else {
                sb.append(')');
            }
            return sb.toString();
        }

        public void fillInRelationshipRange(RelationshipRange range) {
            if (this.fromIncludes) {
                range.setLowestVersionType("GREATER_THAN_OR_EQUAL_TO");
            } else {
                range.setLowestVersionType("GREATER_THAN");
            }
            if (this.toIncludes) {
                range.setHighestVersionType("LESS_THAN_OR_EQUAL_TO");
            } else {
                range.setHighestVersionType("LESS_THAN");
            }
            range.setLowestVersion(Utilities.getVersionString(this.fromVersion));
            range.setHighestVersion(Utilities.getVersionString(this.toVersion));
        }
    }

    public static class RelatedIdKey
    extends RelatedKey {
        public RelatedIdKey(RelatedAsset ra) {
            this(ra, RelationshipRangeUtility.getInfo(ra));
        }

        public RelatedIdKey(RelatedAsset ra, RelationshipInfo info) {
            this(ra.getAssetId(), ra.getAssetVersion(), ra.getRelationshipType(), info);
        }

        public RelatedIdKey(String assetId, String assetVersion, String relationType, RelationshipInfo info) {
            super(assetId, assetVersion, relationType, info);
        }
    }

    public static class RelatedInfoKey
    extends RelatedKey {
        public RelatedInfoKey(RelatedAsset ra) {
            this(ra, RelationshipRangeUtility.getInfo(ra));
        }

        public RelatedInfoKey(RelatedAsset ra, RelationshipInfo info) {
            this(ra.getAssetId(), ra.getAssetVersion(), ra.getRelationshipType(), info);
        }

        public RelatedInfoKey(String assetId, String assetVersion, String relationshipType, RelationshipInfo info) {
            super(assetId, assetVersion, relationshipType, RelationshipInfo.getInfoWithoutId(info));
        }

        public RelatedInfoKey(RelatedIdKey idKey) {
            this(idKey.getToGuid(), idKey.getToVersion(), idKey.getRelTypeId(), idKey.getInfo());
        }
    }

    public static abstract class RelatedKey {
        private final String toGuid;
        private final String relTypeId;
        private final RelationshipInfo info;
        private final String toVersion;

        protected RelatedKey(String toGuid, String toVersion, String relTypeId, RelationshipInfo info) {
            this.toGuid = toGuid;
            this.relTypeId = relTypeId;
            this.info = info != null ? info : RelationshipInfo.EMPTY_INFO;
            this.toVersion = info.getToAssetId() != 0 || toVersion == null ? "" : toVersion;
        }

        public int hashCode() {
            return ((this.toGuid.hashCode() * 31 + this.relTypeId.hashCode()) * 31 + this.toVersion.hashCode()) * 31 + this.info.hashCode();
        }

        public boolean equals(Object o) {
            if (super.equals(o)) {
                return true;
            }
            if (!(o instanceof RelatedKey)) {
                return false;
            }
            RelatedKey okey = (RelatedKey)o;
            return this.toGuid.equals(okey.toGuid) && this.toVersion.equals(okey.toVersion) && this.relTypeId.equals(okey.relTypeId) && this.info.equals(okey.info);
        }

        public String getToGuid() {
            return this.toGuid;
        }

        public String getRelTypeId() {
            return this.relTypeId;
        }

        public RelationshipInfo getInfo() {
            return this.info;
        }

        public String getToVersion() {
            return this.toVersion;
        }

        public String toString() {
            return String.valueOf(this.getClass().getName()) + "(toGuid: " + this.toGuid + ", toVersion: " + this.toVersion + ", toRelType: " + this.relTypeId + ", info: " + this.info + ')';
        }
    }

    public static class RelatedRangeInfoKey
    extends RelatedInfoKey {
        public RelatedRangeInfoKey(RelatedAsset ra) {
            this(ra, RelationshipRangeUtility.getInfo(ra));
        }

        public RelatedRangeInfoKey(RelatedAsset ra, RelationshipInfo info) {
            this(ra.getAssetId(), ra.getRelationshipType(), info);
        }

        public RelatedRangeInfoKey(String assetId, String relationType, RelationshipInfo info) {
            super(assetId, "", relationType, info);
        }
    }
}

