/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ram.internal.common.util;

import com.ibm.ram.common.util.UtilitiesCommon;
import com.ibm.ram.internal.common.bundles.StoredMessage;
import java.io.IOException;
import java.io.PushbackReader;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EmptyStackException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamResult;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.AttributesImpl;
import org.xml.sax.helpers.DefaultHandler;

public class SerializationHelper {
    private static final String ELEMENT_MAP_TAGNAME = "map";
    private static final String ELEMENT_MAPENTRY_TAGNAME = "mapentry";
    private static final String ELEMENT_ARRAY_MAP_TAGNAME = "maparray";
    private static final String ELEMENT_LIST_TAGNAME = "list";
    private static final String ELEMENT_SET_TAGNAME = "set";
    private static final String ELEMENT_LISTENTRY_TAGNAME = "listentry";
    private static final String ELEMENT_SETENTRY_TAGNAME = "setentry";
    private static final String ELEMENT_STORED_MESSAGE_TAGNAME = "storedmessage";
    private static final String ELEMENT_STRING_TAGNAME = "string";
    private static final String ELEMENT_INTEGER_TAGNAME = "int";
    private static final String ELEMENT_LONG_TAGNAME = "long";
    private static final String ELEMENT_DOUBLE_TAGNAME = "double";
    private static final String ELEMENT_BOOLEAN_TAGNAME = "boolean";
    private static final String ELEMENT_NULL_TAGNAME = "null";
    private static final String ELEMENT_ARRAY_DOUBLE_TAGNAME = "doublearray";
    private static final String ELEMENT_ARRAY_STRING_TAGNAME = "stringarray";
    private static final String ELEMENT_ARRAY_INT_TAGNAME = "intarray";
    private static final String ELEMENT_ARRAY_BOOLEAN_TAGNAME = "booleanarray";
    private static final String ELEMENT_ARRAY_LONG_TAGNAME = "longarray";
    private static final String ELEMENT_ARRAY_OBJECT_TAGNAME = "objectarray";
    private static final String ELEMENT_COLLECTION_ATTR_LENGTH = "length";
    private static final String ELEMENT_ARRAY_ATTR_DIMENSIONS = "dims";
    private static final String ELEMENT_ARRAY_ATTR_TYPE = "type";
    private Object toSerializeObject = null;
    private String toDeserializeXML = null;
    private Reader toDeserializeRdr = null;
    private static BlockingQueue<Transformer> transformerPool = new ArrayBlockingQueue<Transformer>(10);
    private static Boolean doResetFix;
    public static final String INDENT_DEFAULT = "2";
    private String indent = "2";
    public static final String nsURI = "";
    public static final String ATTRIBUTE_TYPE = "CDATA";
    private static BlockingQueue<SAXParser> saxParserPool;
    private static final String LEADING_XML = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>";
    public static final int PUSHBACK_SIZE;

    static {
        saxParserPool = new ArrayBlockingQueue<SAXParser>(10);
        PUSHBACK_SIZE = LEADING_XML.length() + 10;
    }

    public SerializationHelper(Object object) {
        this.toSerializeObject = object;
    }

    public SerializationHelper(String toDeserializeXML) {
        this.toDeserializeXML = toDeserializeXML;
    }

    public SerializationHelper(Reader toDeserializeRdr) {
        this.toDeserializeRdr = toDeserializeRdr;
    }

    public String serialize() throws TransformerConfigurationException, TransformerException, ParserConfigurationException {
        StringWriter stringWriter = new StringWriter();
        this.serialize(stringWriter);
        return stringWriter.toString();
    }

    public static Transformer getTransformer(String indent) throws TransformerConfigurationException {
        Transformer t = (Transformer)transformerPool.poll();
        if (t == null) {
            TransformerFactory factory = TransformerFactory.newInstance();
            t = factory.newTransformer();
        }
        if (indent != null) {
            t.setOutputProperty("indent", "yes");
            t.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", indent);
            t.setOutputProperty("{http://xml.apache.org/xalan}line-separator", "\n");
        }
        return t;
    }

    public static void returnTransformer(Transformer t) {
        if (t != null && transformerPool.offer(t)) {
            if (doResetFix == null) {
                String v = System.getProperty("java.version");
                doResetFix = v != null && v.startsWith("1.5") ? ((v = System.getProperty("java.vendor")) != null && v.startsWith("IBM") ? Boolean.valueOf(true) : Boolean.valueOf(false)) : Boolean.valueOf(false);
            }
            if (doResetFix.booleanValue()) {
                t.setParameter("yada", nsURI);
            }
            t.reset();
        }
    }

    public void setIndent(Integer indent) {
        this.indent = indent == null ? null : (indent == -1 ? INDENT_DEFAULT : indent.toString());
    }

    public void serialize(Writer writer) throws TransformerConfigurationException, TransformerException {
        Transformer transformer = null;
        try {
            transformer = SerializationHelper.getTransformer(this.indent);
            transformer.transform(new SAXSource(new SerializeXMLReader<Object>(new ObjectXMLEncoder()), new EncodeSource()), new StreamResult(writer));
        }
        catch (Throwable throwable) {
            SerializationHelper.returnTransformer(transformer);
            try {
                writer.close();
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        SerializationHelper.returnTransformer(transformer);
        try {
            writer.close();
        }
        catch (IOException iOException) {}
    }

    public static SAXParser getSAXParser() throws ParserConfigurationException, SAXException {
        SAXParser p = (SAXParser)saxParserPool.poll();
        if (p == null) {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            return factory.newSAXParser();
        }
        return p;
    }

    public static void returnSAXParser(SAXParser p) {
        if (p != null && saxParserPool.offer(p)) {
            p.reset();
        }
    }

    public <T> T deserialize() throws ParserConfigurationException, SAXException, IOException {
        Object v;
        block11: {
            SAXParser p = null;
            Reader rdr = this.toDeserializeXML != null ? new StringReader(this.toDeserializeXML) : this.toDeserializeRdr;
            try {
                p = SerializationHelper.getSAXParser();
                ObjectDeSerializationHandler objectHandler = new ObjectDeSerializationHandler();
                p.parse(new InputSource(rdr), (DefaultHandler)new DeserializationHandlerWrapper(objectHandler));
                v = objectHandler.getResult();
            }
            catch (Throwable throwable) {
                block13: {
                    try {
                        try {
                            rdr.close();
                        }
                        catch (IOException iOException) {
                            SerializationHelper.returnSAXParser(p);
                            break block13;
                        }
                    }
                    catch (Throwable throwable2) {
                        SerializationHelper.returnSAXParser(p);
                        throw throwable2;
                    }
                    SerializationHelper.returnSAXParser(p);
                }
                throw throwable;
            }
            try {
                try {
                    rdr.close();
                }
                catch (IOException iOException) {
                    SerializationHelper.returnSAXParser(p);
                    break block11;
                }
            }
            catch (Throwable throwable) {
                SerializationHelper.returnSAXParser(p);
                throw throwable;
            }
            SerializationHelper.returnSAXParser(p);
        }
        return (T)v;
    }

    public static boolean isValidXMLToDecode(String s) {
        if (UtilitiesCommon.isEmptyString(s)) {
            return false;
        }
        return s.startsWith(LEADING_XML);
    }

    public static boolean isValidXMLToDecode(PushbackReader pbr) throws IOException {
        char[] buffer = new char[PUSHBACK_SIZE];
        int read = pbr.read(buffer);
        try {
            boolean bl = read != -1 ? SerializationHelper.isValidXMLToDecode(new String(buffer, 0, read)) : false;
            return bl;
        }
        finally {
            if (read != -1) {
                pbr.unread(buffer, 0, read);
            }
        }
    }

    public static PushbackReader createXMLDecoderReader(Reader rdr) {
        return new PushbackReader(rdr, PUSHBACK_SIZE);
    }

    public static abstract class DeSerializationHandler<V>
    extends DefaultHandler {
        private DeserializationHandlerWrapper wrapper;
        private StringBuilder stringContent;
        private boolean retrievingCharacters;

        public DeserializationHandlerWrapper getWrapper() {
            return this.wrapper;
        }

        public void setWrapper(DeserializationHandlerWrapper wrapper) {
            this.wrapper = wrapper;
        }

        public abstract V getResult();

        protected void setRetrievingCharacters(boolean retrievingCharacters, boolean clear) {
            this.retrievingCharacters = retrievingCharacters;
            if (clear) {
                this.clearCharactersContent();
            }
        }

        protected void clearCharactersContent() {
            if (this.stringContent != null) {
                this.stringContent.setLength(0);
            }
        }

        protected String getCharactersContent(boolean emptyString) {
            if (this.stringContent != null && this.stringContent.length() > 0) {
                return this.stringContent.toString();
            }
            return emptyString ? SerializationHelper.nsURI : null;
        }

        protected void charactersHandler(char[] ch, int start, int length) {
            if (this.retrievingCharacters) {
                if (this.stringContent == null) {
                    this.stringContent = new StringBuilder();
                }
                this.stringContent.append(ch, start, length);
            }
        }
    }

    public static final class DeserializationHandlerWrapper
    extends DefaultHandler {
        private Stack<HandlerStackEntry<DefaultHandler>> nestedHandlerStack;
        private DefaultHandler topHandler = this;

        public DeserializationHandlerWrapper() {
        }

        public DeserializationHandlerWrapper(DefaultHandler startingHandler) {
            this.pushNestedHandler(startingHandler, null);
        }

        public <V> DeserializationHandlerWrapper(DeSerializationHandler<V> startingHandler) {
            this.pushNestedHandler(startingHandler, (NestedCallback<DeSerializationHandler<V>>)null);
        }

        public DefaultHandler getCurrentNestedHandler() {
            return this.topHandler;
        }

        public <H extends DefaultHandler> void pushNestedHandler(H nestedHandler, NestedCallback<H> callback) {
            this.pushNestedHandlerPrim(nestedHandler, callback);
        }

        private <H extends DefaultHandler> void pushNestedHandlerPrim(H nestedHandler, NestedCallback<H> callback) {
            if (this.nestedHandlerStack == null) {
                this.nestedHandlerStack = new Stack();
            }
            this.nestedHandlerStack.add(new HandlerStackEntry(this, nestedHandler, callback));
            this.topHandler = nestedHandler;
        }

        public <V> void pushNestedHandler(DeSerializationHandler<V> nestedHandler, NestedCallback<DeSerializationHandler<V>> callback) {
            this.pushNestedHandlerPrim(nestedHandler, callback);
            nestedHandler.setWrapper(this);
        }

        public DefaultHandler popNestedHandler() {
            if (this.nestedHandlerStack == null || this.nestedHandlerStack.isEmpty()) {
                return this;
            }
            HandlerStackEntry<DefaultHandler> poppedStack = this.nestedHandlerStack.pop();
            if (poppedStack.handler instanceof DeSerializationHandler) {
                ((DeSerializationHandler)poppedStack.handler).setWrapper(null);
            }
            try {
                this.topHandler = this.nestedHandlerStack.peek().handler;
            }
            catch (EmptyStackException emptyStackException) {
                this.topHandler = this;
            }
            poppedStack.callback();
            return poppedStack.handler;
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
            if (this.topHandler == this) {
                super.characters(ch, start, length);
            } else {
                this.topHandler.characters(ch, start, length);
            }
        }

        @Override
        public void endDocument() throws SAXException {
            if (this.topHandler == this) {
                super.endDocument();
            } else {
                this.topHandler.endDocument();
            }
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            if (this.topHandler == this) {
                super.endElement(uri, localName, qName);
            } else {
                this.topHandler.endElement(uri, localName, qName);
            }
        }

        @Override
        public void endPrefixMapping(String prefix) throws SAXException {
            if (this.topHandler == this) {
                super.endPrefixMapping(prefix);
            } else {
                this.topHandler.endPrefixMapping(prefix);
            }
        }

        @Override
        public void error(SAXParseException e) throws SAXException {
            if (this.topHandler == this) {
                super.error(e);
            } else {
                this.topHandler.error(e);
            }
        }

        @Override
        public void fatalError(SAXParseException e) throws SAXException {
            if (this.topHandler == this) {
                super.fatalError(e);
            } else {
                this.topHandler.fatalError(e);
            }
        }

        @Override
        public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
            if (this.topHandler == this) {
                super.ignorableWhitespace(ch, start, length);
            } else {
                this.topHandler.ignorableWhitespace(ch, start, length);
            }
        }

        @Override
        public void notationDecl(String name, String publicId, String systemId) throws SAXException {
            if (this.topHandler == this) {
                super.notationDecl(name, publicId, systemId);
            } else {
                this.topHandler.notationDecl(name, publicId, systemId);
            }
        }

        @Override
        public void processingInstruction(String target, String data) throws SAXException {
            if (this.topHandler == this) {
                super.processingInstruction(target, data);
            } else {
                this.topHandler.processingInstruction(target, data);
            }
        }

        @Override
        public InputSource resolveEntity(String publicId, String systemId) throws IOException, SAXException {
            if (this.topHandler == this) {
                return super.resolveEntity(publicId, systemId);
            }
            return this.topHandler.resolveEntity(publicId, systemId);
        }

        @Override
        public void setDocumentLocator(Locator locator) {
            if (this.topHandler == this) {
                super.setDocumentLocator(locator);
            } else {
                this.topHandler.setDocumentLocator(locator);
            }
        }

        @Override
        public void skippedEntity(String name) throws SAXException {
            if (this.topHandler == this) {
                super.skippedEntity(name);
            } else {
                this.topHandler.skippedEntity(name);
            }
        }

        @Override
        public void startDocument() throws SAXException {
            if (this.topHandler == this) {
                super.startDocument();
            } else {
                this.topHandler.startDocument();
            }
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            if (this.topHandler == this) {
                super.startElement(uri, localName, qName, attributes);
            } else {
                this.topHandler.startElement(uri, localName, qName, attributes);
            }
        }

        @Override
        public void startPrefixMapping(String prefix, String uri) throws SAXException {
            if (this.topHandler == this) {
                super.startPrefixMapping(prefix, uri);
            } else {
                this.topHandler.startPrefixMapping(prefix, uri);
            }
        }

        @Override
        public void unparsedEntityDecl(String name, String publicId, String systemId, String notationName) throws SAXException {
            if (this.topHandler == this) {
                super.unparsedEntityDecl(name, publicId, systemId, notationName);
            } else {
                this.topHandler.unparsedEntityDecl(name, publicId, systemId, notationName);
            }
        }

        @Override
        public void warning(SAXParseException e) throws SAXException {
            if (this.topHandler == this) {
                super.warning(e);
            } else {
                this.topHandler.warning(e);
            }
        }

        private static class HandlerStackEntry<H extends DefaultHandler> {
            public final H handler;
            private final NestedCallback<H> callback;
            final /* synthetic */ DeserializationHandlerWrapper this$1;

            public HandlerStackEntry(H handler, NestedCallback<H> callback) {
                this.this$1 = var1_1;
                this.handler = handler;
                this.callback = callback;
            }

            public void callback() {
                if (this.callback != null) {
                    this.callback.popped(this.handler);
                }
            }
        }

        public static interface NestedCallback<H extends DefaultHandler> {
            public void popped(H var1);
        }
    }

    private class EncodeSource
    extends SerializeSource<Object> {
        private EncodeSource() {
        }

        @Override
        public Object getSource() {
            return SerializationHelper.this.toSerializeObject;
        }
    }

    private static class ObjectDeSerializationHandler<V>
    extends DeSerializationHandler<V> {
        private Object deSerializedObject = null;
        private Stack<Object> deSerializedStack = new Stack();
        private boolean unknownElementFound = false;
        private final Object openArray = this;

        private ObjectDeSerializationHandler() {
        }

        private void startArray(Attributes attributes, Class<?> finalType) {
            Object oa;
            int length = Integer.parseInt(attributes.getValue(SerializationHelper.ELEMENT_COLLECTION_ATTR_LENGTH));
            String sdims = attributes.getValue(SerializationHelper.ELEMENT_ARRAY_ATTR_DIMENSIONS);
            if (sdims == null) {
                oa = Array.newInstance(finalType, length);
            } else {
                int dims = Integer.parseInt(sdims);
                int[] diminit = new int[dims];
                diminit[0] = length;
                oa = Array.newInstance(finalType, diminit);
            }
            this.deSerializedStack.push(oa);
            this.deSerializedStack.push(this.openArray);
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            if (this.unknownElementFound) {
                return;
            }
            if (SerializationHelper.ELEMENT_MAP_TAGNAME.equals(qName)) {
                String slength = attributes.getValue(SerializationHelper.ELEMENT_COLLECTION_ATTR_LENGTH);
                int length = -1;
                if (slength != null && (length = Integer.parseInt(slength)) == 1) {
                    ++length;
                }
                if (length < 0) {
                    this.deSerializedStack.push(new HashMap());
                } else {
                    this.deSerializedStack.push(new HashMap(length));
                }
            } else if (SerializationHelper.ELEMENT_LIST_TAGNAME.equals(qName)) {
                String slength = attributes.getValue(SerializationHelper.ELEMENT_COLLECTION_ATTR_LENGTH);
                int length = -1;
                if (slength != null) {
                    length = Integer.parseInt(slength);
                }
                if (length < 0) {
                    this.deSerializedStack.push(new ArrayList());
                } else {
                    this.deSerializedStack.push(new ArrayList(length));
                }
            } else if (SerializationHelper.ELEMENT_SET_TAGNAME.equals(qName)) {
                String slength = attributes.getValue(SerializationHelper.ELEMENT_COLLECTION_ATTR_LENGTH);
                int length = -1;
                if (slength != null && (length = Integer.parseInt(slength)) == 1) {
                    ++length;
                }
                if (length < 0) {
                    this.deSerializedStack.push(new HashSet());
                } else {
                    this.deSerializedStack.push(new HashSet(length));
                }
            } else if (SerializationHelper.ELEMENT_ARRAY_STRING_TAGNAME.equals(qName)) {
                this.startArray(attributes, String.class);
            } else if (SerializationHelper.ELEMENT_ARRAY_MAP_TAGNAME.equals(qName)) {
                this.startArray(attributes, Map.class);
            } else if (SerializationHelper.ELEMENT_ARRAY_INT_TAGNAME.equals(qName)) {
                this.startArray(attributes, Integer.TYPE);
            } else if (SerializationHelper.ELEMENT_ARRAY_LONG_TAGNAME.equals(qName)) {
                this.startArray(attributes, Long.TYPE);
            } else if (SerializationHelper.ELEMENT_ARRAY_BOOLEAN_TAGNAME.equals(qName)) {
                this.startArray(attributes, Boolean.TYPE);
            } else if (SerializationHelper.ELEMENT_ARRAY_DOUBLE_TAGNAME.equals(qName)) {
                this.startArray(attributes, Double.TYPE);
            } else if (SerializationHelper.ELEMENT_ARRAY_OBJECT_TAGNAME.equals(qName)) {
                String type = attributes.getValue(SerializationHelper.ELEMENT_ARRAY_ATTR_TYPE);
                if (SerializationHelper.ELEMENT_INTEGER_TAGNAME.equals(type)) {
                    this.startArray(attributes, Integer.class);
                } else if (SerializationHelper.ELEMENT_LONG_TAGNAME.equals(type)) {
                    this.startArray(attributes, Long.class);
                } else if (SerializationHelper.ELEMENT_BOOLEAN_TAGNAME.equals(type)) {
                    this.startArray(attributes, Boolean.class);
                } else if (SerializationHelper.ELEMENT_DOUBLE_TAGNAME.equals(type)) {
                    this.startArray(attributes, Double.class);
                } else if (SerializationHelper.ELEMENT_SET_TAGNAME.equals(type)) {
                    this.startArray(attributes, Set.class);
                } else if (SerializationHelper.ELEMENT_LIST_TAGNAME.equals(type)) {
                    this.startArray(attributes, List.class);
                } else if ("messages".equals(type)) {
                    this.startArray(attributes, StoredMessage.class);
                } else {
                    this.startArray(attributes, Object.class);
                }
            } else if (SerializationHelper.ELEMENT_BOOLEAN_TAGNAME.equals(qName)) {
                this.setRetrievingCharacters(true, true);
            } else if (SerializationHelper.ELEMENT_INTEGER_TAGNAME.equals(qName)) {
                this.setRetrievingCharacters(true, true);
            } else if (!SerializationHelper.ELEMENT_LISTENTRY_TAGNAME.equals(qName) && !SerializationHelper.ELEMENT_SETENTRY_TAGNAME.equals(qName)) {
                if (SerializationHelper.ELEMENT_LONG_TAGNAME.equals(qName)) {
                    this.setRetrievingCharacters(true, true);
                } else if (SerializationHelper.ELEMENT_DOUBLE_TAGNAME.equals(qName)) {
                    this.setRetrievingCharacters(true, true);
                } else if (!SerializationHelper.ELEMENT_MAPENTRY_TAGNAME.equals(qName) && !SerializationHelper.ELEMENT_NULL_TAGNAME.equals(qName)) {
                    if (SerializationHelper.ELEMENT_STRING_TAGNAME.equals(qName)) {
                        this.setRetrievingCharacters(true, true);
                    } else if (SerializationHelper.ELEMENT_STORED_MESSAGE_TAGNAME.equals(qName)) {
                        this.setRetrievingCharacters(true, true);
                    } else if ("messages".equals(qName)) {
                        this.getWrapper().pushNestedHandler(StoredMessage.getDefaultHandler(), new DeserializationHandlerWrapper.NestedCallback<DeSerializationHandler<StoredMessage>>(){

                            @Override
                            public void popped(DeSerializationHandler<StoredMessage> handler) {
                                ObjectDeSerializationHandler.this.deSerializedStack.push(handler.getResult());
                            }
                        });
                        this.getWrapper().startElement(uri, localName, qName, attributes);
                    } else {
                        this.unknownElementFound = true;
                    }
                }
            }
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            if (this.unknownElementFound) {
                return;
            }
            if (SerializationHelper.ELEMENT_STORED_MESSAGE_TAGNAME.equals(qName)) {
                this.deSerializedStack.push(StoredMessage.createFromSerializedStoredMessage(this.getCharactersContent(true)));
            } else if (SerializationHelper.ELEMENT_STRING_TAGNAME.equals(qName)) {
                this.deSerializedStack.push(this.getCharactersContent(true));
            } else if (SerializationHelper.ELEMENT_LONG_TAGNAME.equals(qName)) {
                this.deSerializedStack.push(Long.parseLong(this.getCharactersContent(false)));
            } else if (SerializationHelper.ELEMENT_DOUBLE_TAGNAME.equals(qName)) {
                this.deSerializedStack.push(Double.parseDouble(this.getCharactersContent(false)));
            } else if (SerializationHelper.ELEMENT_INTEGER_TAGNAME.equals(qName)) {
                this.deSerializedStack.push(Integer.parseInt(this.getCharactersContent(false)));
            } else if (SerializationHelper.ELEMENT_BOOLEAN_TAGNAME.equals(qName)) {
                this.deSerializedStack.push(Boolean.parseBoolean(this.getCharactersContent(false)));
            } else if (SerializationHelper.ELEMENT_NULL_TAGNAME.equals(qName)) {
                this.deSerializedStack.push(null);
            } else if (SerializationHelper.ELEMENT_MAPENTRY_TAGNAME.equals(qName)) {
                Object value = this.deSerializedStack.pop();
                Object key = this.deSerializedStack.pop();
                Entry entry = new Entry(key, value);
                this.deSerializedStack.push(entry);
            } else if (SerializationHelper.ELEMENT_LISTENTRY_TAGNAME.equals(qName)) {
                Object value = this.deSerializedStack.pop();
                Entry entry = new Entry(value);
                this.deSerializedStack.push(entry);
            } else if (SerializationHelper.ELEMENT_LIST_TAGNAME.equals(qName)) {
                int c = this.deSerializedStack.size() - 1;
                while (c >= 0) {
                    Object o = this.deSerializedStack.elementAt(c);
                    if (o instanceof List) {
                        List list = (List)o;
                        Object topObject = this.deSerializedStack.peek();
                        while (topObject instanceof Entry) {
                            Entry entry = (Entry)this.deSerializedStack.pop();
                            list.add(0, entry.value);
                            topObject = this.deSerializedStack.peek();
                        }
                        break;
                    }
                    --c;
                }
            } else if (SerializationHelper.ELEMENT_SETENTRY_TAGNAME.equals(qName)) {
                Object value = this.deSerializedStack.pop();
                Entry entry = new Entry(value);
                this.deSerializedStack.push(entry);
            } else if (SerializationHelper.ELEMENT_SET_TAGNAME.equals(qName)) {
                int c = this.deSerializedStack.size() - 1;
                while (c >= 0) {
                    Object o = this.deSerializedStack.elementAt(c);
                    if (o instanceof Set) {
                        Set set = (Set)o;
                        Object topObject = this.deSerializedStack.peek();
                        while (topObject instanceof Entry) {
                            Entry entry = (Entry)this.deSerializedStack.pop();
                            set.add(entry.value);
                            topObject = this.deSerializedStack.peek();
                        }
                        break;
                    }
                    --c;
                }
            } else if (SerializationHelper.ELEMENT_MAP_TAGNAME.equals(qName)) {
                int c = this.deSerializedStack.size() - 1;
                while (c >= 0) {
                    Object o = this.deSerializedStack.elementAt(c);
                    if (o instanceof Map) {
                        Map map = (Map)o;
                        Object topObject = this.deSerializedStack.peek();
                        while (topObject instanceof Entry) {
                            Entry entry = (Entry)this.deSerializedStack.pop();
                            map.put(entry.key, entry.value);
                            topObject = this.deSerializedStack.peek();
                        }
                        break;
                    }
                    --c;
                }
            } else if (SerializationHelper.ELEMENT_ARRAY_STRING_TAGNAME.equals(qName)) {
                this.endArray();
            } else if (SerializationHelper.ELEMENT_ARRAY_MAP_TAGNAME.equals(qName)) {
                this.endArray();
            } else if (SerializationHelper.ELEMENT_ARRAY_INT_TAGNAME.equals(qName)) {
                this.endArray();
            } else if (SerializationHelper.ELEMENT_ARRAY_LONG_TAGNAME.equals(qName)) {
                this.endArray();
            } else if (SerializationHelper.ELEMENT_ARRAY_DOUBLE_TAGNAME.equals(qName)) {
                this.endArray();
            } else if (SerializationHelper.ELEMENT_ARRAY_BOOLEAN_TAGNAME.equals(qName)) {
                this.endArray();
            } else if (SerializationHelper.ELEMENT_ARRAY_OBJECT_TAGNAME.equals(qName)) {
                this.endArray();
            } else {
                "messages".equals(qName);
            }
            this.setRetrievingCharacters(false, true);
        }

        private void endArray() {
            int c = this.deSerializedStack.size() - 1;
            while (c >= 1) {
                Object o = this.deSerializedStack.elementAt(c);
                if (o == this.openArray && (o = this.deSerializedStack.elementAt(--c)) != null && o.getClass().isArray()) {
                    int count = Array.getLength(o) - 1;
                    Object topObject = this.deSerializedStack.pop();
                    while (topObject != this.openArray) {
                        Object entry = topObject;
                        Array.set(o, count--, entry);
                        topObject = this.deSerializedStack.pop();
                    }
                    break;
                }
                --c;
            }
        }

        @Override
        public void characters(char[] ch, int start, int length) {
            this.charactersHandler(ch, start, length);
        }

        @Override
        public V getResult() {
            if (!this.deSerializedStack.isEmpty()) {
                this.deSerializedObject = this.deSerializedStack.pop();
            }
            return (V)this.deSerializedObject;
        }

        private static class Entry {
            public Object key;
            public Object value;

            public Entry(Object key, Object value) {
                this.key = key;
                this.value = value;
            }

            public Entry(Object value) {
                this(null, value);
            }
        }
    }

    private static class ObjectXMLEncoder
    extends SerializeXMLEncoder<Object> {
        private ObjectXMLEncoder() {
        }

        @Override
        public void encode(Object v) throws SAXException {
            if (v == null) {
                this.encodeNull();
            } else if (v instanceof Map) {
                this.encode((Map)v);
            } else if (v instanceof StoredMessage) {
                this.encode((StoredMessage)v);
            } else if (v instanceof String) {
                this.encode((String)v);
            } else if (v instanceof Integer) {
                this.encode((Integer)v);
            } else if (v instanceof Long) {
                this.encode((Long)v);
            } else if (v instanceof Double) {
                this.encode((Double)v);
            } else if (v instanceof Boolean) {
                this.encode((Boolean)v);
            } else if (v instanceof List) {
                this.encode((List)v);
            } else if (v instanceof Set) {
                this.encode((Set)v);
            } else if (v.getClass().isArray()) {
                this.encodeArray(v);
            } else {
                this.encodeNull();
            }
        }

        @Override
        private void encode(Map<?, ?> map) throws SAXException {
            AttributesImpl attrs = new AttributesImpl();
            attrs.addAttribute(SerializationHelper.nsURI, SerializationHelper.ELEMENT_COLLECTION_ATTR_LENGTH, SerializationHelper.ELEMENT_COLLECTION_ATTR_LENGTH, SerializationHelper.ATTRIBUTE_TYPE, Integer.toString(map.size()));
            this.getContentHandler().startElement(SerializationHelper.nsURI, SerializationHelper.ELEMENT_MAP_TAGNAME, SerializationHelper.ELEMENT_MAP_TAGNAME, attrs);
            for (Map.Entry<?, ?> entry : map.entrySet()) {
                this.getContentHandler().startElement(SerializationHelper.nsURI, SerializationHelper.ELEMENT_MAPENTRY_TAGNAME, SerializationHelper.ELEMENT_MAPENTRY_TAGNAME, new AttributesImpl());
                this.encode(entry.getKey());
                this.encode(entry.getValue());
                this.getContentHandler().endElement(SerializationHelper.nsURI, SerializationHelper.ELEMENT_MAPENTRY_TAGNAME, SerializationHelper.ELEMENT_MAPENTRY_TAGNAME);
            }
            this.getContentHandler().endElement(SerializationHelper.nsURI, SerializationHelper.ELEMENT_MAP_TAGNAME, SerializationHelper.ELEMENT_MAP_TAGNAME);
        }

        @Override
        private void encode(String string) throws SAXException {
            this.getContentHandler().startElement(SerializationHelper.nsURI, SerializationHelper.ELEMENT_STRING_TAGNAME, SerializationHelper.ELEMENT_STRING_TAGNAME, new AttributesImpl());
            this.characters(string);
            this.getContentHandler().endElement(SerializationHelper.nsURI, SerializationHelper.ELEMENT_STRING_TAGNAME, SerializationHelper.ELEMENT_STRING_TAGNAME);
        }

        @Override
        private void encode(StoredMessage storedMessage) throws SAXException {
            if (storedMessage != null) {
                storedMessage.serialize(this.getXMLReader());
            } else {
                this.encodeNull();
            }
        }

        private void encodeNull() throws SAXException {
            this.getContentHandler().startElement(SerializationHelper.nsURI, SerializationHelper.ELEMENT_NULL_TAGNAME, SerializationHelper.ELEMENT_NULL_TAGNAME, new AttributesImpl());
            this.getContentHandler().endElement(SerializationHelper.nsURI, SerializationHelper.ELEMENT_NULL_TAGNAME, SerializationHelper.ELEMENT_NULL_TAGNAME);
        }

        @Override
        private void encode(int integer) throws SAXException {
            this.getContentHandler().startElement(SerializationHelper.nsURI, SerializationHelper.ELEMENT_INTEGER_TAGNAME, SerializationHelper.ELEMENT_INTEGER_TAGNAME, new AttributesImpl());
            this.characters(Integer.toString(integer));
            this.getContentHandler().endElement(SerializationHelper.nsURI, SerializationHelper.ELEMENT_INTEGER_TAGNAME, SerializationHelper.ELEMENT_INTEGER_TAGNAME);
        }

        @Override
        private void encode(long loong) throws SAXException {
            this.getContentHandler().startElement(SerializationHelper.nsURI, SerializationHelper.ELEMENT_LONG_TAGNAME, SerializationHelper.ELEMENT_LONG_TAGNAME, new AttributesImpl());
            this.characters(Long.toString(loong));
            this.getContentHandler().endElement(SerializationHelper.nsURI, SerializationHelper.ELEMENT_LONG_TAGNAME, SerializationHelper.ELEMENT_LONG_TAGNAME);
        }

        @Override
        private void encode(double doouble) throws SAXException {
            this.getContentHandler().startElement(SerializationHelper.nsURI, SerializationHelper.ELEMENT_DOUBLE_TAGNAME, SerializationHelper.ELEMENT_DOUBLE_TAGNAME, new AttributesImpl());
            this.characters(Double.toString(doouble));
            this.getContentHandler().endElement(SerializationHelper.nsURI, SerializationHelper.ELEMENT_DOUBLE_TAGNAME, SerializationHelper.ELEMENT_DOUBLE_TAGNAME);
        }

        @Override
        private void encode(boolean bool) throws SAXException {
            this.getContentHandler().startElement(SerializationHelper.nsURI, SerializationHelper.ELEMENT_BOOLEAN_TAGNAME, SerializationHelper.ELEMENT_BOOLEAN_TAGNAME, new AttributesImpl());
            this.characters(Boolean.toString(bool));
            this.getContentHandler().endElement(SerializationHelper.nsURI, SerializationHelper.ELEMENT_BOOLEAN_TAGNAME, SerializationHelper.ELEMENT_BOOLEAN_TAGNAME);
        }

        private void encode(Collection<?> collection, String collectionElementType, String collectionEntryType) throws SAXException {
            AttributesImpl atts = new AttributesImpl();
            atts.addAttribute(SerializationHelper.nsURI, SerializationHelper.ELEMENT_COLLECTION_ATTR_LENGTH, SerializationHelper.ELEMENT_COLLECTION_ATTR_LENGTH, SerializationHelper.ATTRIBUTE_TYPE, Integer.toString(collection.size()));
            this.getContentHandler().startElement(SerializationHelper.nsURI, collectionElementType, collectionElementType, atts);
            for (Object item : collection) {
                this.getContentHandler().startElement(SerializationHelper.nsURI, collectionEntryType, collectionEntryType, new AttributesImpl());
                this.encode(item);
                this.getContentHandler().endElement(SerializationHelper.nsURI, collectionEntryType, collectionEntryType);
            }
            this.getContentHandler().endElement(SerializationHelper.nsURI, collectionElementType, collectionElementType);
        }

        @Override
        private void encode(List<?> list) throws SAXException {
            this.encode(list, SerializationHelper.ELEMENT_LIST_TAGNAME, SerializationHelper.ELEMENT_LISTENTRY_TAGNAME);
        }

        @Override
        private void encode(Set<?> set) throws SAXException {
            this.encode(set, SerializationHelper.ELEMENT_SET_TAGNAME, SerializationHelper.ELEMENT_SETENTRY_TAGNAME);
        }

        private <T> void encode(T[] array, String arrayElementType) throws SAXException {
            AttributesImpl atts = new AttributesImpl();
            atts.addAttribute(SerializationHelper.nsURI, SerializationHelper.ELEMENT_COLLECTION_ATTR_LENGTH, SerializationHelper.ELEMENT_COLLECTION_ATTR_LENGTH, SerializationHelper.ATTRIBUTE_TYPE, Integer.toString(array.length));
            this.getContentHandler().startElement(SerializationHelper.nsURI, arrayElementType, arrayElementType, atts);
            T[] TArray = array;
            int n = array.length;
            int n2 = 0;
            while (n2 < n) {
                T item = TArray[n2];
                this.encode(item);
                ++n2;
            }
            this.getContentHandler().endElement(SerializationHelper.nsURI, arrayElementType, arrayElementType);
        }

        @Override
        private void encode(String[] array) throws SAXException {
            this.encode(array, SerializationHelper.ELEMENT_ARRAY_STRING_TAGNAME);
        }

        @Override
        private void encode(Map<?, ?>[] array) throws SAXException {
            this.encode(array, SerializationHelper.ELEMENT_ARRAY_MAP_TAGNAME);
        }

        @Override
        private void encode(int[] array) throws SAXException {
            AttributesImpl atts = new AttributesImpl();
            atts.addAttribute(SerializationHelper.nsURI, SerializationHelper.ELEMENT_COLLECTION_ATTR_LENGTH, SerializationHelper.ELEMENT_COLLECTION_ATTR_LENGTH, SerializationHelper.ATTRIBUTE_TYPE, Integer.toString(array.length));
            this.getContentHandler().startElement(SerializationHelper.nsURI, SerializationHelper.ELEMENT_ARRAY_INT_TAGNAME, SerializationHelper.ELEMENT_ARRAY_INT_TAGNAME, atts);
            int[] nArray = array;
            int n = array.length;
            int n2 = 0;
            while (n2 < n) {
                int item = nArray[n2];
                this.encode(item);
                ++n2;
            }
            this.getContentHandler().endElement(SerializationHelper.nsURI, SerializationHelper.ELEMENT_ARRAY_INT_TAGNAME, SerializationHelper.ELEMENT_ARRAY_INT_TAGNAME);
        }

        @Override
        private void encode(long[] array) throws SAXException {
            AttributesImpl atts = new AttributesImpl();
            atts.addAttribute(SerializationHelper.nsURI, SerializationHelper.ELEMENT_COLLECTION_ATTR_LENGTH, SerializationHelper.ELEMENT_COLLECTION_ATTR_LENGTH, SerializationHelper.ATTRIBUTE_TYPE, Integer.toString(array.length));
            this.getContentHandler().startElement(SerializationHelper.nsURI, SerializationHelper.ELEMENT_ARRAY_LONG_TAGNAME, SerializationHelper.ELEMENT_ARRAY_LONG_TAGNAME, atts);
            long[] lArray = array;
            int n = array.length;
            int n2 = 0;
            while (n2 < n) {
                long item = lArray[n2];
                this.encode(item);
                ++n2;
            }
            this.getContentHandler().endElement(SerializationHelper.nsURI, SerializationHelper.ELEMENT_ARRAY_LONG_TAGNAME, SerializationHelper.ELEMENT_ARRAY_LONG_TAGNAME);
        }

        @Override
        private void encode(double[] array) throws SAXException {
            AttributesImpl atts = new AttributesImpl();
            atts.addAttribute(SerializationHelper.nsURI, SerializationHelper.ELEMENT_COLLECTION_ATTR_LENGTH, SerializationHelper.ELEMENT_COLLECTION_ATTR_LENGTH, SerializationHelper.ATTRIBUTE_TYPE, Integer.toString(array.length));
            this.getContentHandler().startElement(SerializationHelper.nsURI, SerializationHelper.ELEMENT_ARRAY_DOUBLE_TAGNAME, SerializationHelper.ELEMENT_ARRAY_DOUBLE_TAGNAME, atts);
            double[] dArray = array;
            int n = array.length;
            int n2 = 0;
            while (n2 < n) {
                double item = dArray[n2];
                this.encode(item);
                ++n2;
            }
            this.getContentHandler().endElement(SerializationHelper.nsURI, SerializationHelper.ELEMENT_ARRAY_DOUBLE_TAGNAME, SerializationHelper.ELEMENT_ARRAY_DOUBLE_TAGNAME);
        }

        @Override
        private void encode(boolean[] array) throws SAXException {
            AttributesImpl atts = new AttributesImpl();
            atts.addAttribute(SerializationHelper.nsURI, SerializationHelper.ELEMENT_COLLECTION_ATTR_LENGTH, SerializationHelper.ELEMENT_COLLECTION_ATTR_LENGTH, SerializationHelper.ATTRIBUTE_TYPE, Integer.toString(array.length));
            this.getContentHandler().startElement(SerializationHelper.nsURI, SerializationHelper.ELEMENT_ARRAY_BOOLEAN_TAGNAME, SerializationHelper.ELEMENT_ARRAY_BOOLEAN_TAGNAME, atts);
            boolean[] blArray = array;
            int n = array.length;
            int n2 = 0;
            while (n2 < n) {
                boolean item = blArray[n2];
                this.encode(item);
                ++n2;
            }
            this.getContentHandler().endElement(SerializationHelper.nsURI, SerializationHelper.ELEMENT_ARRAY_BOOLEAN_TAGNAME, SerializationHelper.ELEMENT_ARRAY_BOOLEAN_TAGNAME);
        }

        private void encodeArray(Object array) throws SAXException {
            AttributesImpl atts = new AttributesImpl();
            Class<?> co = array.getClass().getComponentType();
            Class<?> finalco = array.getClass().getComponentType();
            int dims = 1;
            while (finalco.isArray()) {
                ++dims;
                finalco = finalco.getComponentType();
            }
            if (co == Integer.TYPE) {
                this.encode((int[])array);
            } else if (co == Long.TYPE) {
                this.encode((long[])array);
            } else if (co == Boolean.TYPE) {
                this.encode((boolean[])array);
            } else if (co == String.class) {
                this.encode((String[])array);
            } else if (co == Double.TYPE) {
                this.encode((double[])array);
            } else if (Map.class.isAssignableFrom(co)) {
                this.encode((Map[])array);
            } else {
                String elementType;
                if (dims > 1) {
                    atts.addAttribute(SerializationHelper.nsURI, SerializationHelper.ELEMENT_ARRAY_ATTR_DIMENSIONS, SerializationHelper.ELEMENT_ARRAY_ATTR_DIMENSIONS, SerializationHelper.ATTRIBUTE_TYPE, Integer.toString(dims));
                }
                atts.addAttribute(SerializationHelper.nsURI, SerializationHelper.ELEMENT_COLLECTION_ATTR_LENGTH, SerializationHelper.ELEMENT_COLLECTION_ATTR_LENGTH, SerializationHelper.ATTRIBUTE_TYPE, Integer.toString(Array.getLength(array)));
                if (finalco == Integer.TYPE) {
                    elementType = SerializationHelper.ELEMENT_ARRAY_INT_TAGNAME;
                } else if (finalco == Long.TYPE) {
                    elementType = SerializationHelper.ELEMENT_ARRAY_LONG_TAGNAME;
                } else if (finalco == Boolean.TYPE) {
                    elementType = SerializationHelper.ELEMENT_ARRAY_BOOLEAN_TAGNAME;
                } else if (finalco == String.class) {
                    elementType = SerializationHelper.ELEMENT_ARRAY_STRING_TAGNAME;
                } else if (finalco == Double.TYPE) {
                    elementType = SerializationHelper.ELEMENT_ARRAY_DOUBLE_TAGNAME;
                } else if (Map.class.isAssignableFrom(finalco)) {
                    elementType = SerializationHelper.ELEMENT_ARRAY_MAP_TAGNAME;
                } else {
                    elementType = SerializationHelper.ELEMENT_ARRAY_OBJECT_TAGNAME;
                    if (finalco == Integer.class) {
                        atts.addAttribute(SerializationHelper.nsURI, SerializationHelper.ELEMENT_ARRAY_ATTR_TYPE, SerializationHelper.ELEMENT_ARRAY_ATTR_TYPE, SerializationHelper.ATTRIBUTE_TYPE, SerializationHelper.ELEMENT_INTEGER_TAGNAME);
                    } else if (finalco == Long.class) {
                        atts.addAttribute(SerializationHelper.nsURI, SerializationHelper.ELEMENT_ARRAY_ATTR_TYPE, SerializationHelper.ELEMENT_ARRAY_ATTR_TYPE, SerializationHelper.ATTRIBUTE_TYPE, SerializationHelper.ELEMENT_LONG_TAGNAME);
                    } else if (finalco == Boolean.class) {
                        atts.addAttribute(SerializationHelper.nsURI, SerializationHelper.ELEMENT_ARRAY_ATTR_TYPE, SerializationHelper.ELEMENT_ARRAY_ATTR_TYPE, SerializationHelper.ATTRIBUTE_TYPE, SerializationHelper.ELEMENT_BOOLEAN_TAGNAME);
                    } else if (finalco == Double.class) {
                        atts.addAttribute(SerializationHelper.nsURI, SerializationHelper.ELEMENT_ARRAY_ATTR_TYPE, SerializationHelper.ELEMENT_ARRAY_ATTR_TYPE, SerializationHelper.ATTRIBUTE_TYPE, SerializationHelper.ELEMENT_DOUBLE_TAGNAME);
                    } else if (Set.class.isAssignableFrom(finalco)) {
                        atts.addAttribute(SerializationHelper.nsURI, SerializationHelper.ELEMENT_ARRAY_ATTR_TYPE, SerializationHelper.ELEMENT_ARRAY_ATTR_TYPE, SerializationHelper.ATTRIBUTE_TYPE, SerializationHelper.ELEMENT_SET_TAGNAME);
                    } else if (StoredMessage.class.isAssignableFrom(finalco)) {
                        atts.addAttribute(SerializationHelper.nsURI, SerializationHelper.ELEMENT_ARRAY_ATTR_TYPE, SerializationHelper.ELEMENT_ARRAY_ATTR_TYPE, SerializationHelper.ATTRIBUTE_TYPE, "messages");
                    } else if (List.class.isAssignableFrom(finalco)) {
                        atts.addAttribute(SerializationHelper.nsURI, SerializationHelper.ELEMENT_ARRAY_ATTR_TYPE, SerializationHelper.ELEMENT_ARRAY_ATTR_TYPE, SerializationHelper.ATTRIBUTE_TYPE, SerializationHelper.ELEMENT_LIST_TAGNAME);
                    }
                }
                this.getContentHandler().startElement(SerializationHelper.nsURI, elementType, elementType, atts);
                Object[] objectArray = (Object[])array;
                int n = objectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Object item = objectArray[n2];
                    this.encode(item);
                    ++n2;
                }
                this.getContentHandler().endElement(SerializationHelper.nsURI, elementType, elementType);
            }
        }
    }

    public static abstract class SerializeSource<V>
    extends InputSource {
        public abstract V getSource();
    }

    public static abstract class SerializeXMLEncoder<V> {
        private XMLReader xmlReader;
        private char[] charBuffer;

        public final void setXMLReader(XMLReader xmlReader) {
            this.xmlReader = xmlReader;
        }

        public final XMLReader getXMLReader() {
            return this.xmlReader;
        }

        protected final ContentHandler getContentHandler() {
            return this.xmlReader.getContentHandler();
        }

        protected final boolean isLexicalHandler() {
            return this.getContentHandler() instanceof LexicalHandler;
        }

        protected final LexicalHandler getLexicalHandler() {
            return (LexicalHandler)((Object)this.getContentHandler());
        }

        public abstract void encode(V var1) throws SAXException, IOException;

        protected void characters(String string) throws SAXException {
            this.characters(string, 0, string.length());
        }

        protected void characters(String string, int start, int length) throws SAXException {
            int endOffset = start + length;
            if (length > 1000) {
                char[] buf = new char[length];
                string.getChars(start, endOffset, buf, 0);
                this.getContentHandler().characters(buf, 0, buf.length);
            } else {
                if (this.charBuffer == null) {
                    this.charBuffer = new char[1000];
                }
                string.getChars(start, endOffset, this.charBuffer, 0);
                this.getContentHandler().characters(this.charBuffer, 0, length);
            }
        }
    }

    public static class SerializeXMLReader<V>
    implements XMLReader {
        private ContentHandler contentHandler;
        private final SerializeXMLEncoder<V> encoder;

        public SerializeXMLReader(SerializeXMLEncoder<V> encoder) {
            this.encoder = encoder;
            encoder.setXMLReader(this);
        }

        @Override
        public ContentHandler getContentHandler() {
            return this.contentHandler;
        }

        @Override
        public DTDHandler getDTDHandler() {
            return null;
        }

        @Override
        public EntityResolver getEntityResolver() {
            return null;
        }

        @Override
        public ErrorHandler getErrorHandler() {
            return null;
        }

        @Override
        public boolean getFeature(String name) throws SAXNotRecognizedException, SAXNotSupportedException {
            return false;
        }

        @Override
        public Object getProperty(String name) throws SAXNotRecognizedException, SAXNotSupportedException {
            return null;
        }

        @Override
        public void parse(InputSource input) throws SAXException, IOException {
            if (!(input instanceof SerializeSource)) {
                throw new SAXException("Source not appropriate. Must be a SerializeSource");
            }
            this.parse((SerializeSource)input);
        }

        public void parse(SerializeSource<V> input) throws SAXException, IOException {
            if (this.getContentHandler() == null) {
                throw new SAXException("No content handler");
            }
            V root = input.getSource();
            this.getContentHandler().startDocument();
            this.encoder.encode(root);
            this.getContentHandler().endDocument();
        }

        @Override
        public void parse(String systemId) throws IOException, SAXException {
        }

        @Override
        public void setContentHandler(ContentHandler handler) {
            this.contentHandler = handler;
        }

        @Override
        public void setDTDHandler(DTDHandler handler) {
        }

        @Override
        public void setEntityResolver(EntityResolver resolver) {
        }

        @Override
        public void setErrorHandler(ErrorHandler handler) {
        }

        @Override
        public void setFeature(String name, boolean value) throws SAXNotRecognizedException, SAXNotSupportedException {
        }

        @Override
        public void setProperty(String name, Object value) throws SAXNotRecognizedException, SAXNotSupportedException {
        }
    }
}

