/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ram.internal.common.util;

import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import java.util.regex.Pattern;

public class Tag {
    private String label;
    private String tag;
    private static final Pattern SPACE_REPLACE = Pattern.compile("[\\s\u3000]+");

    public Tag(String label) {
        this(label, Tag.createTagFromLabel(label));
    }

    Tag(String label, String tag) {
        this.label = label;
        this.tag = tag;
    }

    public static String createTagFromLabel(String label) {
        String tag = label.toLowerCase();
        return SPACE_REPLACE.matcher(tag).replaceAll("");
    }

    public String getLabel() {
        return this.label;
    }

    public String getTag() {
        return this.tag;
    }

    private static boolean exist(String tag, List tags) {
        int i = 0;
        while (i < tags.size()) {
            if (((Tag)tags.get(i)).getTag().equalsIgnoreCase(tag)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static Tag[] createTagsFromLabel(String label) {
        if (label == null) {
            return new Tag[0];
        }
        ArrayList<Tag> tags = new ArrayList<Tag>(1);
        StringTokenizer quoteTokens = new StringTokenizer(label, "\"", true);
        boolean inQuotes = false;
        while (quoteTokens.hasMoreElements()) {
            String token = (String)quoteTokens.nextElement();
            if (token.equals("\"")) {
                inQuotes = !inQuotes;
                continue;
            }
            if (inQuotes) {
                String tagString;
                if (token.length() <= 0 || Tag.exist(tagString = Tag.createTagFromLabel(token), tags)) continue;
                tags.add(new Tag(token, tagString));
                continue;
            }
            StringTokenizer spaceTokens = new StringTokenizer(token, " ,\t\n\r\f\u3000");
            while (spaceTokens.hasMoreTokens()) {
                String tagLabel = spaceTokens.nextToken();
                String tagString = Tag.createTagFromLabel(tagLabel);
                if (Tag.exist(tagString, tags)) continue;
                tags.add(new Tag(tagLabel, tagString));
            }
        }
        return tags.toArray(new Tag[tags.size()]);
    }
}

