/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ram.internal.common.util;

import com.ibm.ram.common.util.RAMURLDecoder;
import com.ibm.ram.common.util.UtilitiesCommon;
import com.ibm.ram.internal.common.bundles.CommonMessages;
import com.ibm.ram.internal.common.util.ParallelWriterReader;
import com.ibm.ram.internal.common.util.SerializationHelper;
import com.ibm.ram.internal.common.util.SessionHandler;
import java.beans.XMLDecoder;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.URL;
import java.text.Collator;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.text.html.HTML;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import org.apache.log4j.Logger;
import org.xml.sax.SAXException;

public class Utilities {
    private static final Logger logger = Logger.getLogger(Utilities.class);
    public static final String USER_MANAGEMENT_LOGGER_PACKAGE = "com.ibm.ram.userMgmt";
    public static final Pattern HTML_PATTERN = Pattern.compile("\\S*://.\\S*");
    public static final Pattern ESCAPE_REGEX_CHARS_PATTERN = Pattern.compile("(\\.|\\*|\\$|\\-|\\&\\&|\\|\\||\\!|\\(|\\)|\\{|\\}|\\[|\\]|\\^|\\\"|\\~|\\?|\\:|\\\\)");
    public static final String ESCAPE_REGEX_CHARS_REPLACE = "\\\\$1";
    private static final Integer ZERO = 0;
    public static final Pattern GET_VERSION_ARRAY_SPLIT_PATTERN = Pattern.compile("\\.");
    private static final boolean WINDOWS;
    private static final Pattern unicodeConversion;

    static {
        String osName = System.getProperty("os.name");
        WINDOWS = osName.startsWith("Windows");
        unicodeConversion = Pattern.compile("(^(\\d{1,5});)|(&#(\\d{1,5});)");
    }

    public static String stripHTML(String htmlContent) {
        return Utilities.stripML(htmlContent, false);
    }

    public static String stripXML(String xmlContent) {
        return Utilities.stripML(xmlContent, true);
    }

    public static String createHTMLLinks(String text) {
        if (text != null && text.length() > 0) {
            Matcher m = HTML_PATTERN.matcher(text);
            while (m.find()) {
                String link = m.group();
                StringBuilder htmlLink = new StringBuilder();
                htmlLink.append("<a href=\"");
                htmlLink.append(link);
                htmlLink.append("\">");
                htmlLink.append(link);
                htmlLink.append("</a>");
                text = text.replaceAll(Utilities.escapeRegexChars(link), htmlLink.toString());
            }
        }
        return text;
    }

    private static int processLinkTag(String content, int idx, StringBuffer result, boolean includeName) {
        if (content.length() > idx + 1 && content.charAt(idx + 1) == 'a') {
            int endIdx = content.indexOf(">", idx);
            int hrefIdx = content.indexOf("href", idx);
            if (endIdx >= 0 && hrefIdx >= 0 && hrefIdx < endIdx) {
                idx = hrefIdx + 5;
                while (idx < content.length() && content.charAt(idx) != '\"') {
                    ++idx;
                }
                if (idx < content.length()) {
                    result.append(" ");
                    ++idx;
                    while (idx < content.length() && content.charAt(idx) != '\"') {
                        result.append(content.charAt(idx));
                        ++idx;
                    }
                    result.append(" ");
                    ++idx;
                }
            }
        } else if (includeName) {
            int endIdx = content.indexOf(">", idx);
            int nameIdx = content.indexOf("name", idx);
            if (endIdx >= 0 && nameIdx >= 0 && nameIdx < endIdx) {
                idx = nameIdx + 5;
                while (idx < content.length() && content.charAt(idx) != '\"') {
                    ++idx;
                }
                if (idx < content.length()) {
                    result.append(" ");
                    ++idx;
                    while (idx < content.length() && content.charAt(idx) != '\"') {
                        result.append(content.charAt(idx));
                        ++idx;
                    }
                    result.append(" ");
                    ++idx;
                }
            }
        }
        return idx;
    }

    private static String stripML(String content, boolean includeName) {
        if (content == null) {
            return null;
        }
        StringBuffer s = new StringBuffer();
        boolean ignore = false;
        boolean quote = false;
        int i = 0;
        while (i < content.length()) {
            char c = content.charAt(i);
            switch (c) {
                case '<': {
                    if (!quote) {
                        ignore = true;
                        i = Utilities.processLinkTag(content, i, s, includeName);
                        break;
                    }
                    s.append(c);
                    break;
                }
                case '>': {
                    if (!quote) {
                        ignore = false;
                        break;
                    }
                    s.append(c);
                    break;
                }
                case '\"': {
                    if (i == 0 || content.charAt(i - 1) != '\\') {
                        quote = !quote;
                        break;
                    }
                    s.append(c);
                    break;
                }
                default: {
                    if (ignore) break;
                    s.append(c);
                }
            }
            ++i;
        }
        return s.toString();
    }

    public static String getSnip(String[] terms, String text, String startTermTag, String endTermTag, int maxWordsPrecedingFirstTerm, int maxWordsAfterFirstSearchTerm, boolean stripHTML, int maxCJKChars) {
        int j;
        String retVal = "";
        StringBuffer snipBuff = new StringBuffer();
        if (stripHTML) {
            text = Utilities.stripHTML(text);
        }
        int i = 0;
        while (i < terms.length) {
            terms[i] = terms[i].replaceAll("\\*", "\\\\w*").toLowerCase();
            terms[i] = terms[i].replaceAll("\\?", "\\\\w?").toLowerCase();
            ++i;
        }
        String[] words = text.split("\\s|\u3000");
        boolean foundMatch = false;
        int wordCount = 0;
        block5: while (wordCount < words.length) {
            j = 0;
            while (j < terms.length) {
                try {
                    if (!terms[j].equals("\\w*") && !terms[j].equals("\\w?") && words[wordCount].toLowerCase().matches(terms[j])) {
                        foundMatch = true;
                        break block5;
                    }
                }
                catch (Exception exception) {
                    logger.info((Object)("Invalid search string: " + terms[j]));
                }
                ++j;
            }
            ++wordCount;
        }
        if (foundMatch) {
            int upperBound;
            int lowerBound = wordCount - maxWordsPrecedingFirstTerm;
            if (lowerBound < 0) {
                lowerBound = 0;
            }
            if ((upperBound = wordCount + maxWordsAfterFirstSearchTerm) > words.length) {
                upperBound = words.length;
            }
            if (lowerBound != 0) {
                snipBuff.append("... ");
            }
            endTermTag = endTermTag.concat(" ");
            int i2 = lowerBound;
            while (i2 < upperBound) {
                if (i2 == wordCount) {
                    snipBuff.append(startTermTag);
                    snipBuff.append(words[i2]);
                    snipBuff.append(endTermTag);
                } else if (i2 > wordCount) {
                    boolean match = false;
                    int j2 = 0;
                    while (j2 < terms.length) {
                        try {
                            if (!terms[j2].equals("\\w*") && !terms[j2].equals("\\w?") && words[i2].toLowerCase().matches(terms[j2])) {
                                match = true;
                                break;
                            }
                        }
                        catch (Exception exception) {
                            logger.info((Object)("Invalid search string: " + terms[j2]));
                        }
                        ++j2;
                    }
                    if (match) {
                        snipBuff.append(startTermTag);
                        snipBuff.append(words[i2]);
                        snipBuff.append(endTermTag);
                    } else {
                        snipBuff.append(words[i2]);
                        snipBuff.append(" ");
                    }
                } else {
                    snipBuff.append(words[i2]);
                    snipBuff.append(" ");
                }
                ++i2;
            }
            if (upperBound != words.length) {
                snipBuff.append("...");
            }
            retVal = snipBuff.toString();
        } else {
            j = 0;
            while (j < terms.length) {
                int indexOf;
                if (!terms[j].equals("\\w*") && !terms[j].equals("\\w?") && (indexOf = text.indexOf(terms[j])) > -1) {
                    int lowbound = indexOf - maxCJKChars / 2;
                    int highbound = indexOf + maxCJKChars / 2;
                    if (lowbound < 0) {
                        snipBuff.append("...");
                        lowbound = 0;
                    }
                    if (highbound > text.length()) {
                        snipBuff.append(text.substring(lowbound));
                    } else {
                        snipBuff.append(text.substring(lowbound, highbound));
                        snipBuff.append("...");
                    }
                    retVal = snipBuff.toString().replaceAll(terms[j], String.valueOf(startTermTag) + terms[j] + endTermTag);
                    break;
                }
                ++j;
            }
            if (retVal.length() == 0) {
                if (text.length() > maxCJKChars) {
                    retVal = text.substring(0, maxCJKChars);
                    retVal = retVal.concat("...");
                } else {
                    retVal = text;
                }
            }
        }
        return retVal;
    }

    public static boolean matchesHTML(Matcher m, String findInText) {
        HTML.Tag[] tags = HTML.getAllTags();
        int startingIdx = m.start();
        int endingIdx = m.end();
        if (startingIdx < 0) {
            return false;
        }
        if (endingIdx >= findInText.length() && findInText.charAt(endingIdx - 1) != '>') {
            return false;
        }
        int inspectingIdx = startingIdx;
        int foundStartTagIdx = -1;
        int foundEndTagIdx = -1;
        boolean foundSlash = false;
        while (inspectingIdx >= 0) {
            if (findInText.charAt(inspectingIdx) == '<') {
                if (inspectingIdx + 1 < findInText.length() && findInText.charAt(inspectingIdx + 1) == '/') {
                    foundStartTagIdx = inspectingIdx + 1;
                    foundSlash = true;
                }
                if (foundSlash) break;
                foundStartTagIdx = inspectingIdx;
                break;
            }
            if (findInText.charAt(inspectingIdx) == '>') {
                foundEndTagIdx = inspectingIdx;
                if (inspectingIdx != startingIdx) break;
            }
            --inspectingIdx;
        }
        if (foundStartTagIdx == -1 || foundEndTagIdx != -1 && foundEndTagIdx < foundStartTagIdx) {
            return false;
        }
        int tagNameIdx = -1;
        boolean foundClosing = false;
        int i = foundStartTagIdx + 1;
        while (i < findInText.length()) {
            if (findInText.charAt(i) == ' ' && tagNameIdx == -1) {
                tagNameIdx = i;
            } else if (findInText.charAt(i) == '>') {
                if (findInText.charAt(i - 1) == '/') {
                    foundSlash = true;
                    if (tagNameIdx == -1) {
                        tagNameIdx = i - 1;
                    }
                }
                if (tagNameIdx == -1) {
                    tagNameIdx = i;
                }
                foundClosing = true;
                break;
            }
            ++i;
        }
        if (tagNameIdx == -1 || !foundClosing) {
            return false;
        }
        String possibleTag = findInText.substring(foundStartTagIdx + 1, tagNameIdx);
        if (possibleTag.equalsIgnoreCase("tbody")) {
            return true;
        }
        int i2 = 0;
        while (i2 < tags.length) {
            if (tags[i2].toString().equalsIgnoreCase(possibleTag)) {
                return true;
            }
            ++i2;
        }
        return false;
    }

    public static String encodeToString(Object obj) {
        try {
            return new SerializationHelper(obj).serialize();
        }
        catch (TransformerConfigurationException e) {
            logger.warn((Object)"Unable to encode to XML", (Throwable)e);
        }
        catch (TransformerException e) {
            logger.warn((Object)"Unable to encode to XML", (Throwable)e);
        }
        catch (ParserConfigurationException e) {
            logger.warn((Object)"Unable to encode to XML", (Throwable)e);
        }
        return null;
    }

    public static boolean encodeToWriter(Object obj, Writer writer) {
        try {
            new SerializationHelper(obj).serialize(writer);
            return true;
        }
        catch (TransformerConfigurationException e) {
            logger.warn((Object)"Unable to encode to XML", (Throwable)e);
        }
        catch (TransformerException e) {
            logger.warn((Object)"Unable to encode to XML", (Throwable)e);
        }
        return false;
    }

    public static boolean encodeToXML(Map<?, ?> map, Writer writer) {
        if (map.isEmpty()) {
            return true;
        }
        return Utilities.encodeToWriter(map, writer);
    }

    public static String encodeToString(Map<?, ?> map) {
        if (map.isEmpty()) {
            return "";
        }
        return Utilities.encodeToString(map);
    }

    public static boolean isValidXMLToDecode(String xml) {
        return SerializationHelper.isValidXMLToDecode(xml);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <T> T decodeFromReader(Reader rdr) {
        if (rdr == null) {
            return null;
        }
        try {
            Object t;
            SerializationHelper sh = null;
            try {
                sh = new SerializationHelper(rdr);
                t = sh.deserialize();
                if (sh != null) return t;
            }
            catch (Throwable throwable) {
                if (sh != null) throw throwable;
                try {
                    rdr.close();
                    throw throwable;
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            try {
                rdr.close();
                return t;
            }
            catch (IOException iOException) {}
            return t;
        }
        catch (ParserConfigurationException e) {
            logger.warn((Object)"Unable to decode XML", (Throwable)e);
            return null;
        }
        catch (SAXException e) {
            logger.warn((Object)"Unable to decode XML", (Throwable)e);
            return null;
        }
        catch (IOException e) {
            logger.warn((Object)"Unable to decode XML", (Throwable)e);
        }
        return null;
    }

    public static <T> T decodeFromString(String xml) {
        if (UtilitiesCommon.isEmptyString(xml)) {
            return null;
        }
        return Utilities.decodeFromReader(new StringReader(xml));
    }

    public static String encodeToXML(Map<?, ?> map) {
        return Utilities.encodeToString(map);
    }

    public static <K, V> Map<K, V> decodeXML(String xml) {
        if (UtilitiesCommon.isEmptyString(xml)) {
            return new HashMap();
        }
        Map obj = Utilities.decodeXML(new StringReader(xml));
        if (obj == null) {
            try {
                ByteArrayInputStream bytearrayOS;
                try {
                    bytearrayOS = new ByteArrayInputStream(xml.getBytes("UTF-8"));
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    bytearrayOS = new ByteArrayInputStream(xml.getBytes());
                }
                XMLDecoder encoder = new XMLDecoder(bytearrayOS);
                obj = (Map)encoder.readObject();
                encoder.close();
            }
            catch (Throwable throwable) {
                obj = new HashMap();
            }
        }
        if (obj != null) {
            return obj;
        }
        return new HashMap();
    }

    public static <K, V> Map<K, V> decodeXML(Reader xml) {
        if (xml == null) {
            return new HashMap();
        }
        return (Map)Utilities.decodeFromReader(xml);
    }

    public static String stripNewLines(String string) {
        if (string == null) {
            return string;
        }
        String returnString = string.replaceAll("\\r", "");
        returnString = returnString.replaceAll("\\n", "");
        return returnString;
    }

    public static String escapeForJavascript(String s) {
        if (s == null) {
            return s;
        }
        StringBuilder buffer = null;
        int i = 0;
        while (i < s.length()) {
            char c = s.charAt(i);
            if (c == '\'' || c == '\"') {
                buffer = Utilities.getSB(buffer, s, i);
                buffer.append('\\').append(c);
            } else if (c == '\r') {
                buffer = Utilities.getSB(buffer, s, i);
            } else if (c == '\n') {
                buffer = Utilities.getSB(buffer, s, i);
                buffer.append(' ');
            } else if (buffer != null) {
                buffer.append(c);
            }
            ++i;
        }
        return buffer == null ? s : buffer.toString();
    }

    private static StringBuilder getSB(StringBuilder sb, String s, int upto) {
        if (sb != null) {
            return sb;
        }
        sb = new StringBuilder(s.length());
        sb.append(s, 0, upto);
        return sb;
    }

    public static String escapeForXML(String s) {
        if (s == null) {
            return s;
        }
        StringBuilder buffer = null;
        int i = 0;
        while (i < s.length()) {
            char c = s.charAt(i);
            switch (c) {
                case '\u0001': 
                case '\u0002': 
                case '\u0003': 
                case '\u0004': 
                case '\u0005': 
                case '\u0006': 
                case '\u0007': 
                case '\b': 
                case '\u000b': 
                case '\f': 
                case '\u000e': 
                case '\u000f': 
                case '\u0010': 
                case '\u0011': 
                case '\u0012': 
                case '\u0013': 
                case '\u0014': 
                case '\u0015': 
                case '\u0016': 
                case '\u0017': 
                case '\u0018': 
                case '\u0019': 
                case '\u001a': 
                case '\u001b': 
                case '\u001c': 
                case '\u001d': 
                case '\u001e': 
                case '\u001f': {
                    buffer = Utilities.getSB(buffer, s, i);
                    break;
                }
                default: {
                    if (buffer == null) break;
                    buffer.append(c);
                }
            }
            ++i;
        }
        return buffer == null ? s : buffer.toString();
    }

    public static String addWordBreakTags(String s) {
        char[] chars = s.toCharArray();
        char[] returnChar = new char[chars.length * 7];
        int i = 0;
        while (i < chars.length) {
            returnChar[i * 7] = chars[i];
            returnChar[i * 7 + 1] = 60;
            returnChar[i * 7 + 2] = 119;
            returnChar[i * 7 + 3] = 98;
            returnChar[i * 7 + 4] = 114;
            returnChar[i * 7 + 5] = 47;
            returnChar[i * 7 + 6] = 62;
            ++i;
        }
        return new String(returnChar);
    }

    public static String escapeRegexChars(String string) {
        return ESCAPE_REGEX_CHARS_PATTERN.matcher(string).replaceAll(ESCAPE_REGEX_CHARS_REPLACE);
    }

    static int lastSegment(String s) {
        int ndx = 0;
        while (ndx < s.length()) {
            if (!Character.isDigit(s.charAt(ndx))) {
                return ndx;
            }
            ++ndx;
        }
        return s.length();
    }

    private static boolean containsLeadingZero(String s) {
        return s.length() > 1 && s.charAt(0) == '0';
    }

    public static boolean isVersionFormat(String version) {
        Object[] vArray = Utilities.getVersionArray(version);
        int upto = vArray.length > 1 ? vArray.length - 1 : vArray.length;
        int i = 0;
        while (i < upto) {
            if (!(vArray[i] instanceof Integer) || (Integer)vArray[i] < 0) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static int compareVersions(String version1, String version2) {
        return Utilities.compareVersions(Utilities.getVersionArray(version1), Utilities.getVersionArray(version2));
    }

    public static int compareVersions(Object[] v1, Object[] v2) {
        block19: {
            int i;
            Collator c;
            int length;
            block18: {
                if (v1 == null) {
                    if (v2 == null) {
                        return 0;
                    }
                    return -1;
                }
                if (v2 == null) {
                    return -1;
                }
                length = Math.min(v1.length, v2.length);
                c = Collator.getInstance(SessionHandler.getSessionHandler().getLocale());
                i = 0;
                while (i < length) {
                    switch (Utilities.compare(v1[i], v2[i], c)) {
                        case 1: {
                            return 1;
                        }
                        case -1: {
                            return -1;
                        }
                    }
                    ++i;
                }
                if (length >= v1.length) break block18;
                i = length;
                while (i < v1.length) {
                    switch (Utilities.compare(v1[i], ZERO, c)) {
                        case 1: {
                            return 1;
                        }
                        case -1: {
                            return -1;
                        }
                    }
                    ++i;
                }
                break block19;
            }
            if (length >= v2.length) break block19;
            i = length;
            while (i < v2.length) {
                switch (Utilities.compare(ZERO, v2[i], c)) {
                    case 1: {
                        return 1;
                    }
                    case -1: {
                        return -1;
                    }
                }
                ++i;
            }
        }
        return 0;
    }

    private static int compare(Object v1, Object v2, Collator c) {
        if (v1 instanceof Integer) {
            if (v2 instanceof Integer) {
                return ((Integer)v1).compareTo((Integer)v2);
            }
            return 1;
        }
        if (v2 instanceof Integer) {
            return -1;
        }
        return c.compare(v1, v2);
    }

    public static Object[] getVersionArray(String version) {
        String[] sArray = GET_VERSION_ARRAY_SPLIT_PATTERN.split(version);
        ArrayList<Object> array = new ArrayList<Object>(sArray.length);
        StringBuilder lastSegment = null;
        String tail = null;
        int i = 0;
        while (i < sArray.length) {
            block13: {
                String segment = sArray[i];
                if (lastSegment == null) {
                    try {
                        int split = Utilities.lastSegment(segment);
                        if (split == segment.length()) {
                            array.add(Integer.parseInt(segment));
                            break block13;
                        }
                        if (split > 0) {
                            array.add(Integer.parseInt(segment.substring(0, split)));
                        }
                        tail = segment.substring(split);
                        throw new NumberFormatException();
                    }
                    catch (NumberFormatException numberFormatException) {
                        if (i == sArray.length - 1) {
                            if (tail == null) {
                                array.add(segment);
                            } else if ((tail = tail.trim()).length() > 0) {
                                array.add(tail);
                            }
                            break block13;
                        }
                        lastSegment = new StringBuilder();
                        if (tail == null) {
                            lastSegment.append(segment);
                            break block13;
                        }
                        lastSegment.append(tail);
                    }
                } else {
                    lastSegment.append('.').append(segment);
                }
            }
            ++i;
        }
        if (lastSegment != null && (tail = lastSegment.toString().trim()).length() > 0) {
            array.add(tail);
        }
        return array.toArray();
    }

    public static String getVersionString(Object[] version) {
        if (version == null) {
            return "";
        }
        return Utilities.getVersionString(version, null).toString();
    }

    public static StringBuilder getVersionString(Object[] version, StringBuilder vString) {
        if (vString == null) {
            vString = new StringBuilder();
        }
        int i = 0;
        while (i < version.length) {
            Object segment = version[i];
            if (i > 0 && segment instanceof Integer) {
                vString.append('.');
            }
            vString.append(segment);
            ++i;
        }
        return vString;
    }

    public static String incrementVersionLevel(String version, int i) {
        String returnV = version;
        if (Utilities.isVersionFormat(version)) {
            Object[] vArray = Utilities.getVersionArray(version);
            if (i < vArray.length) {
                if (vArray[i] instanceof Integer) {
                    vArray[i] = (Integer)vArray[i] + 1;
                    if (i != 0 || vArray.length > 1) {
                        Object[] newArray = new Object[i == 0 ? 2 : i + 1];
                        System.arraycopy(vArray, 0, newArray, 0, i + 1);
                        if (i == 0) {
                            newArray[1] = 0;
                        }
                        vArray = newArray;
                    }
                } else {
                    Object[] newArray = new Object[i + 1];
                    System.arraycopy(vArray, 0, newArray, 0, i);
                    newArray[i] = 1;
                    newArray[i + 1] = vArray[i];
                    vArray = newArray;
                }
            } else if (vArray[vArray.length - 1] instanceof Integer) {
                Object[] newArray = new Object[vArray.length + 1];
                System.arraycopy(vArray, 0, newArray, 0, vArray.length);
                newArray[newArray.length - 1] = 1;
                vArray = newArray;
            } else {
                Object[] newArray = new Object[vArray.length + 1];
                System.arraycopy(vArray, 0, newArray, 0, vArray.length - 1);
                newArray[vArray.length - 1] = 1;
                newArray[vArray.length] = vArray[vArray.length - 1];
                vArray = newArray;
            }
            returnV = Utilities.getVersionString(vArray);
        }
        return returnV;
    }

    public static String getVersionHelp(boolean isInCreateNewVersionMode, String version) {
        if (isInCreateNewVersionMode) {
            if (Utilities.isVersionFormat(version)) {
                String suggestion1 = Utilities.incrementVersionLevel(version, Integer.MAX_VALUE);
                String suggestion2 = Utilities.incrementVersionLevel(version, 0);
                return MessageFormat.format(CommonMessages.getString("help_version_format_update_suggest"), version, suggestion1, suggestion2);
            }
            return MessageFormat.format(CommonMessages.getString("help_version_format_update"), version);
        }
        return CommonMessages.getString("help_version_format");
    }

    public static String normalizeDirectoryPath(String path) {
        return path != null ? path.replace('\\', '/') : null;
    }

    public static String convertURL(URL url) {
        String filePath = url.getFile();
        if (filePath.charAt(filePath.length() - 1) == '&' && url.getRef() != null) {
            Matcher m = unicodeConversion.matcher(url.getRef());
            StringBuffer b = new StringBuffer(filePath);
            b.setLength(b.length() - 1);
            while (m.find()) {
                String v = m.group();
                v = v.charAt(0) == '&' ? m.group(4) : m.group(2);
                int cn = Integer.parseInt(v);
                if (cn <= 65535) {
                    m.appendReplacement(b, String.valueOf((char)Integer.parseInt(v)));
                    continue;
                }
                m.appendReplacement(b, "");
            }
            m.appendTail(b);
            filePath = b.toString();
        }
        if (WINDOWS && filePath.length() > 1 && filePath.charAt(0) == '/' && filePath.charAt(1) != '/') {
            filePath = filePath.substring(1);
        }
        return Utilities.normalizeDirectoryPath(RAMURLDecoder.decode(filePath));
    }

    public static String stripMsgId(String message) {
        if (message == null || !message.startsWith("CRRAM")) {
            return message;
        }
        String[] splitIt = message.split("-", 2);
        return splitIt.length > 1 ? splitIt[1].substring(1) : message;
    }

    public static class EncodeWriterRunnable
    implements ParallelWriterReader.WriterRunnable {
        private final String threadname;
        private final Object objToEncode;
        private boolean worked;

        public EncodeWriterRunnable(String threadname, Object objToEncode) {
            this.threadname = threadname;
            this.objToEncode = objToEncode;
        }

        @Override
        public String getThreadName() {
            return this.threadname;
        }

        @Override
        public void run(Writer writer) {
            this.worked = false;
            this.worked = Utilities.encodeToWriter(this.objToEncode, writer);
        }

        public boolean isWorked() {
            return this.worked;
        }
    }
}

