/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ram.internal.json;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Map;
import java.util.Set;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;

public class XMLGregorianCalendarDeserializer
implements JsonDeserializer<XMLGregorianCalendar> {
    private static DatatypeFactory DATE_TYPE_FACTORY;

    private static synchronized DatatypeFactory getDateTypeFactory() throws DatatypeConfigurationException {
        if (DATE_TYPE_FACTORY == null) {
            DATE_TYPE_FACTORY = DatatypeFactory.newInstance();
        }
        return DATE_TYPE_FACTORY;
    }

    @Override
    public XMLGregorianCalendar deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        JsonObject jsonObj = (JsonObject)json;
        XMLGregorianCalendar cal = null;
        try {
            cal = XMLGregorianCalendarDeserializer.getDateTypeFactory().newXMLGregorianCalendar();
            Set<Map.Entry<String, JsonElement>> entries = jsonObj.entrySet();
            for (Map.Entry<String, JsonElement> entry : entries) {
                Field field;
                String fieldName = entry.getKey();
                try {
                    field = cal.getClass().getDeclaredField(fieldName);
                }
                catch (SecurityException securityException) {
                    field = null;
                }
                catch (NoSuchFieldException noSuchFieldException) {
                    field = null;
                }
                if (field == null) continue;
                String method = "set" + Character.toUpperCase(fieldName.charAt(0)) + fieldName.substring(1);
                try {
                    Method m = cal.getClass().getMethod(method, field.getType());
                    m.setAccessible(true);
                    if (Integer.TYPE.equals(field.getType())) {
                        int intVal = entry.getValue().getAsInt();
                        m.invoke((Object)cal, intVal);
                        continue;
                    }
                    if (BigInteger.class.equals(field.getType())) {
                        BigInteger bigInt = entry.getValue().getAsBigInteger();
                        m.invoke((Object)cal, bigInt);
                        continue;
                    }
                    if (!BigDecimal.class.equals(field.getType())) continue;
                    BigDecimal bigDecimal = entry.getValue().getAsBigDecimal();
                    m.invoke((Object)cal, bigDecimal);
                }
                catch (SecurityException securityException) {
                }
                catch (NoSuchMethodException noSuchMethodException) {
                }
                catch (IllegalArgumentException illegalArgumentException) {
                }
                catch (IllegalAccessException illegalAccessException) {
                }
                catch (InvocationTargetException invocationTargetException) {}
            }
        }
        catch (DatatypeConfigurationException e) {
            e.printStackTrace();
        }
        return cal;
    }
}

