/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ram.internal.scm.clearcase.commands;

import com.ibm.ram.internal.scm.clearcase.commands.AbstractCleartoolCommand;
import com.ibm.ram.internal.scm.clearcase.commands.OutputCleartoolCommand;
import java.io.File;

public class DiffCommand
extends OutputCleartoolCommand {
    private String selector1;
    private String selector2;
    private File viewFileLocation;

    public DiffCommand(String selector1, String selector2, File viewFileLocation) {
        this.selector1 = selector1;
        this.selector2 = selector2;
        this.viewFileLocation = viewFileLocation;
    }

    @Override
    protected AbstractCleartoolCommand.ICommandOutput parseOutput(String outputStream, String errorStream) {
        boolean identical = false;
        if (outputStream != null && outputStream.length() > 0) {
            String[] lines = outputStream.split("\r\n");
            int i = 0;
            while (i < lines.length) {
                if (lines[i].indexOf("") != -1) {
                    identical = true;
                }
                ++i;
            }
        }
        final boolean fIdentical = identical;
        return new DiffOutput(){

            @Override
            public boolean identical() {
                return fIdentical;
            }
        };
    }

    @Override
    protected String[] getArguments() {
        return new String[]{"diff", this.selector1, this.selector2};
    }

    @Override
    protected File getFolderToRunIn() {
        if (this.viewFileLocation != null && this.viewFileLocation.exists()) {
            return this.viewFileLocation.getParentFile();
        }
        return null;
    }

    public static interface DiffOutput
    extends AbstractCleartoolCommand.ICommandOutput {
        public boolean identical();
    }
}

