/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ram.internal.scm.clearcase.commands;

import com.ibm.ram.internal.scm.clearcase.commands.AbstractCleartoolCommand;
import com.ibm.ram.internal.scm.clearcase.commands.OutputCleartoolCommand;
import java.util.ArrayList;
import java.util.StringTokenizer;

public class FilePathToVersionCommand
extends OutputCleartoolCommand {
    private String[] filePaths = null;

    public FilePathToVersionCommand(String[] filePaths) {
        this.filePaths = filePaths;
    }

    @Override
    protected String[] getArguments() {
        String[] args = new String[3 + this.filePaths.length];
        args[0] = "describe";
        args[1] = "-fmt";
        args[2] = "%Vn\r\n";
        int fc = 0;
        while (fc < this.filePaths.length) {
            args[3 + fc] = this.filePaths[fc];
            ++fc;
        }
        return args;
    }

    @Override
    protected AbstractCleartoolCommand.ICommandOutput parseOutput(final String output, String error) {
        return new FilePathToVersionOutput(){

            @Override
            public String[] getVersion() {
                StringTokenizer lineTokenizer = new StringTokenizer(output, "\r\n", false);
                ArrayList<String> lines = new ArrayList<String>();
                while (lineTokenizer.hasMoreTokens()) {
                    lines.add(lineTokenizer.nextToken());
                }
                return lines.toArray(new String[lines.size()]);
            }
        };
    }

    public static interface FilePathToVersionOutput
    extends AbstractCleartoolCommand.ICommandOutput {
        public String[] getVersion();
    }
}

