/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ram.internal.scm.clearcase.commands;

import com.ibm.ram.internal.scm.clearcase.ClearcaseManager;
import com.ibm.ram.internal.scm.clearcase.commands.AbstractCleartoolCommand;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import org.apache.log4j.Logger;

public abstract class OutputCleartoolCommand
extends AbstractCleartoolCommand {
    private static Logger logger = Logger.getLogger(OutputCleartoolCommand.class);
    private String outputStreamContent = null;
    private String errorStreamContent = null;

    protected abstract AbstractCleartoolCommand.ICommandOutput parseOutput(String var1, String var2);

    @Override
    protected AbstractCleartoolCommand.ICommandOutput handleProcess(Process cleartoolProcess) throws IOException, InterruptedException {
        InputStreamReader outStreamReader = new InputStreamReader(cleartoolProcess.getInputStream());
        InputStreamReader errStreamReader = new InputStreamReader(cleartoolProcess.getErrorStream());
        outStreamReader.start();
        errStreamReader.start();
        ProcessRunnerThread processThread = new ProcessRunnerThread(cleartoolProcess);
        processThread.start();
        long commandTimeout = ClearcaseManager.getCommandTimeout();
        processThread.join(commandTimeout);
        outStreamReader.join(commandTimeout);
        errStreamReader.join(commandTimeout);
        if (!processThread.isProperFinish()) {
            if (processThread.getInterruptedException() != null) {
                throw processThread.getInterruptedException();
            }
            cleartoolProcess.destroy();
            throw new InterruptedException("Interrupted for exceeding timeout limit of " + commandTimeout + " milliseconds");
        }
        this.setOutputStreamContent(outStreamReader.getContent());
        this.setErrorStreamContent(errStreamReader.getContent());
        if (this.getErrorStreamContent() != null && this.getErrorStreamContent().length() > 0) {
            StringBuffer cmd = new StringBuffer();
            cmd.append(String.valueOf(this.getClass().getName()) + ": ");
            String[] command = this.getArguments();
            if (command != null) {
                int ac = 0;
                while (ac < command.length) {
                    cmd.append(String.valueOf(command[ac]) + ", ");
                    ++ac;
                }
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)(cmd + "\r\n" + this.getErrorStreamContent()));
            }
        }
        return this.parseOutput(this.getOutputStreamContent(), this.getErrorStreamContent());
    }

    public String getErrorStreamContent() {
        return this.errorStreamContent;
    }

    public void setErrorStreamContent(String errorStreamContent) {
        this.errorStreamContent = errorStreamContent;
    }

    public String getOutputStreamContent() {
        return this.outputStreamContent;
    }

    public void setOutputStreamContent(String outputStreamContent) {
        this.outputStreamContent = outputStreamContent;
    }

    public static final class InputStreamReader
    extends Thread {
        private InputStream is = null;
        private StringWriter content = null;

        public InputStreamReader(InputStream is) {
            this.is = is;
            this.content = new StringWriter();
        }

        @Override
        public void run() {
            try {
                byte[] bytes = new byte[8192];
                int read = this.is.read(bytes);
                while (read > -1) {
                    this.content.write(new String(bytes, 0, read));
                    read = this.is.read(bytes);
                }
            }
            catch (IOException e) {
                e.printStackTrace(new PrintWriter(this.content));
            }
        }

        public String getContent() {
            return this.content.getBuffer().toString();
        }
    }

    public static final class ProcessRunnerThread
    extends Thread {
        Process process = null;
        private InterruptedException interrupted = null;
        private boolean properFinish = false;

        public ProcessRunnerThread(Process process) {
            this.process = process;
        }

        @Override
        public void run() {
            try {
                this.process.waitFor();
                this.properFinish = true;
            }
            catch (InterruptedException e) {
                this.interrupted = e;
            }
        }

        public InterruptedException getInterruptedException() {
            return this.interrupted;
        }

        public boolean isProperFinish() {
            return this.properFinish;
        }
    }
}

