/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ram.internal.scm.clearcase.commands.ucm;

import com.ibm.ram.internal.scm.clearcase.commands.AbstractCleartoolCommand;
import com.ibm.ram.internal.scm.clearcase.commands.OutputCleartoolCommand;

public class MakeBaseLineCommand
extends OutputCleartoolCommand {
    private String integrationViewTag;
    private String baselineName;
    private boolean identical;

    public MakeBaseLineCommand(String integrationViewTag, String baselineName, boolean identical) {
        this.integrationViewTag = integrationViewTag;
        this.baselineName = baselineName;
        this.identical = identical;
    }

    @Override
    protected AbstractCleartoolCommand.ICommandOutput parseOutput(String outputStream, String errorStream) {
        boolean isCreated = false;
        if (outputStream != null && outputStream.length() > 0) {
            String[] lines = outputStream.split("\r\n");
            boolean createFound = false;
            boolean doneFound = false;
            int i = 0;
            while (i < lines.length) {
                String line = lines[i];
                if (line.startsWith("Created")) {
                    createFound = true;
                } else if (line.startsWith("Done")) {
                    doneFound = true;
                }
                ++i;
            }
            isCreated = createFound && doneFound;
        }
        final boolean finalCreated = isCreated;
        return new MakeBaseLineCommandOuptut(){

            @Override
            public boolean isBaselineCreated() {
                return finalCreated;
            }
        };
    }

    @Override
    protected String[] getArguments() {
        if (this.identical) {
            return new String[]{"mkbl", "-identical", "-view", this.integrationViewTag, this.baselineName};
        }
        return new String[]{"mkbl", "-view", this.integrationViewTag, this.baselineName};
    }

    public static interface MakeBaseLineCommandOuptut
    extends AbstractCleartoolCommand.ICommandOutput {
        public boolean isBaselineCreated();
    }
}

