/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ram.io.zip;

import com.ibm.ram.io.zip.ExtraField;
import com.ibm.ram.io.zip.LittleEndian;
import com.ibm.ram.io.zip.UShort;
import com.ibm.ram.io.zip.ZIP;
import java.util.Map;
import java.util.TreeMap;

final class ExtraFields
implements Cloneable {
    private Map extra = new TreeMap();

    ExtraFields() {
    }

    public Object clone() {
        try {
            ExtraFields clone = (ExtraFields)super.clone();
            clone.extra = new TreeMap(this.extra);
            return clone;
        }
        catch (CloneNotSupportedException cannotHappen) {
            throw new AssertionError((Object)cannotHappen);
        }
    }

    public int size() {
        return this.extra.size();
    }

    public ExtraField get(int headerID) {
        UShort.check(headerID);
        ExtraField ef = (ExtraField)this.extra.get(new Integer(headerID));
        return ef;
    }

    public ExtraField put(ExtraField ef) {
        if (ef == null) {
            throw new NullPointerException("ef");
        }
        int headerID = ef.getHeaderID();
        UShort.check(headerID);
        return this.extra.put(new Integer(headerID), ef);
    }

    public ExtraField remove(int headerID) {
        UShort.check(headerID);
        ExtraField ef = (ExtraField)this.extra.remove(new Integer(headerID));
        return ef;
    }

    int getExtraLength() {
        if (this.extra.isEmpty()) {
            return 0;
        }
        int l = 0;
        for (ExtraField ef : this.extra.values()) {
            l += 4 + ef.getDataSize();
        }
        return l;
    }

    byte[] getExtra() {
        int size = this.getExtraLength();
        UShort.check(size);
        if (size == 0) {
            return ZIP.EMPTY;
        }
        byte[] data = new byte[size];
        this.writeTo(data, 0);
        return data;
    }

    void readFrom(byte[] data, int off, int size) {
        UShort.check(size, "Extra Field out of range", null);
        TreeMap<Integer, ExtraField> map = new TreeMap<Integer, ExtraField>();
        if (data != null && size > 0) {
            int end = off + size;
            while (off < end) {
                int headerID = LittleEndian.readUShort(data, off);
                int dataSize = LittleEndian.readUShort(data, off += 2);
                ExtraField ef = ExtraField.create(headerID);
                ef.readFrom(data, off += 2, dataSize);
                off += dataSize;
                map.put(new Integer(headerID), ef);
            }
        }
        this.extra = map;
    }

    void writeTo(byte[] data, int off) {
        for (ExtraField ef : this.extra.values()) {
            LittleEndian.writeShort(ef.getHeaderID(), data, off);
            LittleEndian.writeShort(ef.getDataSize(), data, off += 2);
            ef.writeTo(data, off += 2);
            off += ef.getDataSize();
        }
    }
}

