/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ram.policy;

import java.util.Calendar;
import java.util.StringTokenizer;

public class PendingPolicyExecutionInterval {
    private String pendingExecutionInterval;

    public PendingPolicyExecutionInterval(String pendingExecutionInterval) {
        this.pendingExecutionInterval = pendingExecutionInterval;
    }

    public String getInterval() {
        return this.pendingExecutionInterval;
    }

    public String toString() {
        if (this.pendingExecutionInterval != null && this.pendingExecutionInterval.length() > 0) {
            return this.getInterval();
        }
        return "";
    }

    public static PendingPolicyExecutionInterval createDayOfWeekExecutionInterval(int dayOfWeek, int hourOfDay, int minutes) {
        StringBuilder builder = new StringBuilder();
        builder.append('w');
        switch (dayOfWeek) {
            case 1: {
                builder.append("sun");
                break;
            }
            case 2: {
                builder.append("mon");
                break;
            }
            case 3: {
                builder.append("tue");
                break;
            }
            case 4: {
                builder.append("wed");
                break;
            }
            case 5: {
                builder.append("thu");
                break;
            }
            case 6: {
                builder.append("fri");
                break;
            }
            case 7: {
                builder.append("sat");
            }
        }
        builder.append(':');
        builder.append(hourOfDay);
        builder.append(':');
        builder.append(minutes);
        return new PendingPolicyExecutionInterval(builder.toString());
    }

    public static PendingPolicyExecutionInterval createDailyExecutionInterval(int hourOfDay, int minutes) {
        return new PendingPolicyExecutionInterval("d:" + hourOfDay + ':' + minutes);
    }

    public static PendingPolicyExecutionInterval createHourlyExecutionInterval(int hours) {
        return new PendingPolicyExecutionInterval("h:" + hours);
    }

    public static PendingPolicyExecutionInterval createMinutelyExecutionInterval(int minutes) {
        return new PendingPolicyExecutionInterval("m:" + minutes);
    }

    public static PendingPolicyExecutionInterval createSecondlyExecutionInterval(int seconds) {
        return new PendingPolicyExecutionInterval("s:" + seconds);
    }

    public boolean canRun(long currentTime, long lastRun) {
        if (this.pendingExecutionInterval == null || this.pendingExecutionInterval.length() == 0) {
            return true;
        }
        char type = this.pendingExecutionInterval.charAt(0);
        StringTokenizer tokens = new StringTokenizer(this.pendingExecutionInterval.substring(1), ":");
        switch (type) {
            case 'i': {
                return true;
            }
            case 's': {
                int secondlyInterval = Integer.parseInt(tokens.nextToken());
                Calendar cal = Calendar.getInstance();
                cal.setTimeInMillis(lastRun);
                cal.add(13, secondlyInterval);
                return currentTime >= cal.getTimeInMillis();
            }
            case 'm': {
                int minutelyInterval = Integer.parseInt(tokens.nextToken());
                Calendar cal = Calendar.getInstance();
                cal.setTimeInMillis(lastRun);
                cal.add(12, minutelyInterval);
                return currentTime >= cal.getTimeInMillis();
            }
            case 'h': {
                int hourlyInterval = Integer.parseInt(tokens.nextToken());
                Calendar cal = Calendar.getInstance();
                cal.setTimeInMillis(lastRun);
                cal.add(11, hourlyInterval);
                return currentTime >= cal.getTimeInMillis();
            }
            case 'd': {
                int hourOfDay = Integer.parseInt(tokens.nextToken());
                int minuteOfDay = 0;
                if (tokens.hasMoreElements()) {
                    minuteOfDay = Integer.parseInt(tokens.nextToken());
                }
                Calendar cal = Calendar.getInstance();
                cal.setTimeInMillis(currentTime);
                cal.set(11, hourOfDay);
                cal.set(12, minuteOfDay);
                cal.set(13, 0);
                cal.set(14, 0);
                if (currentTime >= cal.getTimeInMillis() && lastRun < cal.getTimeInMillis()) {
                    return true;
                }
                cal.add(6, -1);
                return lastRun < cal.getTimeInMillis();
            }
            case 'w': {
                int dayOfWeek = this.getDayOfWeek(tokens.nextToken());
                int minuteOfDay = 0;
                int hourOfDay = 0;
                if (tokens.hasMoreElements()) {
                    hourOfDay = Integer.parseInt(tokens.nextToken());
                }
                if (tokens.hasMoreElements()) {
                    minuteOfDay = Integer.parseInt(tokens.nextToken());
                }
                Calendar cal = Calendar.getInstance();
                cal.setTimeInMillis(currentTime);
                cal.set(7, dayOfWeek);
                cal.set(11, hourOfDay);
                cal.set(12, minuteOfDay);
                cal.set(13, 0);
                cal.set(14, 0);
                return currentTime >= cal.getTimeInMillis() && lastRun < cal.getTimeInMillis();
            }
        }
        return true;
    }

    public long getNextRunAfter(long runAfter) {
        if (this.pendingExecutionInterval == null || this.pendingExecutionInterval.length() == 0) {
            return runAfter;
        }
        char type = this.pendingExecutionInterval.charAt(0);
        StringTokenizer tokens = new StringTokenizer(this.pendingExecutionInterval.substring(1), ":");
        switch (type) {
            default: {
                return runAfter;
            }
            case 's': {
                int secondlyInterval = Integer.parseInt(tokens.nextToken());
                Calendar cal = Calendar.getInstance();
                cal.setTimeInMillis(runAfter);
                cal.add(13, secondlyInterval);
                return cal.getTimeInMillis();
            }
            case 'm': {
                int minutelyInterval = Integer.parseInt(tokens.nextToken());
                Calendar cal = Calendar.getInstance();
                cal.setTimeInMillis(runAfter);
                cal.add(12, minutelyInterval);
                return cal.getTimeInMillis();
            }
            case 'h': {
                int hourlyInterval = Integer.parseInt(tokens.nextToken());
                Calendar cal = Calendar.getInstance();
                cal.setTimeInMillis(runAfter);
                cal.add(10, hourlyInterval);
                return cal.getTimeInMillis();
            }
            case 'd': {
                int hourOfDay = Integer.parseInt(tokens.nextToken());
                int minuteOfDay = 0;
                if (tokens.hasMoreElements()) {
                    minuteOfDay = Integer.parseInt(tokens.nextToken());
                }
                Calendar cal = Calendar.getInstance();
                cal.setTimeInMillis(runAfter);
                cal.set(11, hourOfDay);
                cal.set(12, minuteOfDay);
                cal.set(13, 0);
                cal.set(14, 0);
                if (runAfter <= cal.getTimeInMillis()) {
                    return cal.getTimeInMillis();
                }
                cal.add(6, 1);
                return cal.getTimeInMillis();
            }
            case 'w': 
        }
        int dayOfWeek = this.getDayOfWeek(tokens.nextToken());
        int minuteOfDay = 0;
        int hourOfDay = 0;
        if (tokens.hasMoreElements()) {
            hourOfDay = Integer.parseInt(tokens.nextToken());
        }
        if (tokens.hasMoreElements()) {
            minuteOfDay = Integer.parseInt(tokens.nextToken());
        }
        Calendar cal = Calendar.getInstance();
        cal.setTimeInMillis(runAfter);
        cal.set(7, dayOfWeek);
        cal.set(11, hourOfDay);
        cal.set(12, minuteOfDay);
        cal.set(13, 0);
        cal.set(14, 0);
        if (runAfter <= cal.getTimeInMillis()) {
            return cal.getTimeInMillis();
        }
        cal.add(6, 7);
        return cal.getTimeInMillis();
    }

    private int getDayOfWeek(String dow) {
        if ("sat".equalsIgnoreCase(dow)) {
            return 7;
        }
        if ("sun".equalsIgnoreCase(dow)) {
            return 1;
        }
        if ("mon".equalsIgnoreCase(dow)) {
            return 2;
        }
        if ("tue".equalsIgnoreCase(dow)) {
            return 3;
        }
        if ("wed".equalsIgnoreCase(dow)) {
            return 4;
        }
        if ("thu".equalsIgnoreCase(dow)) {
            return 5;
        }
        return 6;
    }
}

