/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ram.internal.client;

import com.ibm.ram.internal.client.AbstractRAMClient;
import com.ibm.ram.internal.client.AbstractRESTClient;
import com.ibm.ram.internal.client.IRESTCacheManager;
import com.ibm.ram.internal.client.RAMServiceException;
import com.ibm.ram.internal.client.RESTCacheManager;
import com.ibm.ram.internal.client.RestClientService;
import com.ibm.ram.internal.jaxb.Link;
import com.ibm.ram.internal.jaxb.util.JAXBLinksUtil;
import com.ibm.ram.internal.rest.AbstractRestService;
import com.ibm.ram.internal.rest.Request;
import com.ibm.ram.internal.rest.RestContext;
import com.ibm.ram.internal.rest.RestService;
import java.net.URI;
import java.net.URISyntaxException;

public class RESTClient
extends AbstractRESTClient {
    private IRESTCacheManager cacheManager;

    protected RESTClient(AbstractRAMClient client) throws RAMServiceException {
        super(client);
        try {
            this.getContext().setBaseURI(new URI(this.getServerPath()));
        }
        catch (URISyntaxException e) {
            throw new RAMServiceException(10005, this.getServerPath(), (Throwable)e);
        }
        this.getContext().setSerializationFormat(RestContext.SerializationFormat.XML);
    }

    protected IRESTCacheManager getRestCacheManager() {
        if (this.cacheManager == null) {
            this.cacheManager = RESTCacheManager.getInstance();
        }
        return this.cacheManager;
    }

    public RestService getRestService(String href, Class respondingClass) {
        return new RestClientService(this, this.getContext(), JAXBLinksUtil.getLink((String)href), respondingClass);
    }

    public RestService getRestService(Link link, Class respondingClass) {
        return new RestClientService(this, this.getContext(), link, respondingClass);
    }

    public AbstractRestService getRestService(Request request) {
        return new RestClientService(this, this.getContext(), request);
    }
}

