/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ram.repository.web.ws.core;

import com.ibm.ram.internal.client.RAMClientUtilities;
import java.io.IOException;
import java.net.Socket;
import java.util.Hashtable;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLHandshakeException;
import org.apache.axis.components.net.BooleanHolder;
import org.apache.axis.components.net.JSSESocketFactory;

public class AcceptAllSSLCertsSocketFactory
extends JSSESocketFactory {
    private static String className = AcceptAllSSLCertsSocketFactory.class.getName();
    private static final Logger logger = Logger.getLogger(className);
    private List contextOrder = null;
    private SSLContext currentContext = null;

    public AcceptAllSSLCertsSocketFactory(Hashtable attributes) {
        super(attributes);
    }

    @Override
    protected void initFactory() throws IOException {
        if (this.contextOrder == null) {
            this.contextOrder = RAMClientUtilities.getSSLContexts();
        }
        this.currentContext = RAMClientUtilities.getNextAvailableContext(this.currentContext, null, this.contextOrder);
        this.sslFactory = this.currentContext.getSocketFactory();
    }

    @Override
    public Socket create(String host, int port, StringBuffer otherHeaders, BooleanHolder useFullURL) throws Exception {
        Socket s = null;
        SSLContext firstContext = this.currentContext;
        while (true) {
            try {
                s = super.create(host, port, otherHeaders, useFullURL);
            }
            catch (SSLHandshakeException e) {
                logger.log(Level.FINEST, "Creating socket failed with SSL protocol: " + (this.currentContext == null ? "?" : this.currentContext.getProtocol()));
                logger.log(Level.FINEST, "Creating socket failed. Trying next SSL protocol", e);
                this.currentContext = RAMClientUtilities.getNextAvailableContext(this.currentContext, firstContext, this.contextOrder);
                this.sslFactory = this.currentContext.getSocketFactory();
                if (this.currentContext != null) continue;
            }
            break;
        }
        return s;
    }
}

