/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ram.client;

import com.ibm.ram.client.LoadEclipseClass;
import com.ibm.ram.internal.common.CommonPlugin;
import org.eclipse.core.runtime.Platform;
import org.osgi.framework.Bundle;
import org.osgi.service.packageadmin.PackageAdmin;

class LoadEclipseClassImpl
implements LoadEclipseClass {
    static LoadEclipseClass INSTANCE = LoadEclipseClassHolder._instance;

    private LoadEclipseClassImpl() {
    }

    @Override
    public <V> Class<V> loadClass(String classname, String bundleName, String bundleVersionRange) throws ClassNotFoundException {
        if (!this.isEclipseRunning()) {
            throw new ClassNotFoundException("Eclipse not running. Can't find " + classname);
        }
        PackageAdmin packageAdmin = (PackageAdmin)CommonPlugin.plugin.bundleTracker.getService();
        if (packageAdmin == null) {
            throw new ClassNotFoundException("Eclipse not configured correctly. Can't find " + classname);
        }
        Bundle[] bundles = packageAdmin.getBundles(bundleName, bundleVersionRange);
        if (bundles == null) {
            throw new ClassNotFoundException("Bundle can't be found. Can't find " + classname);
        }
        int i = 0;
        while (i < bundles.length) {
            if ((bundles[i].getState() & 3) == 0) {
                return bundles[i].loadClass(classname);
            }
            ++i;
        }
        throw new ClassNotFoundException(classname);
    }

    @Override
    public boolean isEclipseRunning() {
        return Platform.isRunning();
    }

    /* synthetic */ LoadEclipseClassImpl(LoadEclipseClassImpl loadEclipseClassImpl) {
        this();
    }

    private static class LoadEclipseClassHolder {
        static LoadEclipseClassImpl _instance = new LoadEclipseClassImpl(null);

        private LoadEclipseClassHolder() {
        }
    }
}

