/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ram.client;

import com.ibm.ram.client.RAMArtifact;
import com.ibm.ram.client.RAMFolderArtifact;
import com.ibm.ram.client.RAMURLArtifact;
import com.ibm.ram.common.data.ArtifactReference;
import com.ibm.ram.defaultprofile.DefaultprofileFactory;
import com.ibm.ram.defaultprofile.Description;
import com.ibm.ram.defaultprofile.Reference;
import com.ibm.ram.defaultprofile.ReferenceKind;

public class RAMArtifactReference
extends ArtifactReference {
    private RAMArtifact fArtifact;
    private RAMFolderArtifact fFolderArtifact;
    private RAMURLArtifact fURLArtifact;
    private boolean fDirty = false;

    RAMArtifactReference(RAMArtifact artifact) {
        this.fArtifact = artifact;
    }

    RAMArtifactReference(RAMFolderArtifact artifact) {
        this.fFolderArtifact = artifact;
    }

    RAMArtifactReference(RAMURLArtifact artifact) {
        this.fURLArtifact = artifact;
    }

    Reference getInternalReference(boolean createIt) {
        Reference ret = null;
        if (this.fArtifact != null) {
            ret = this.fArtifact.getInternalArtifact().getReference();
        } else if (this.fFolderArtifact != null) {
            ret = this.fFolderArtifact.getInternalArtifact().getReference();
        } else if (this.fURLArtifact != null) {
            ret = this.fURLArtifact.getInternalArtifact().getReference();
        }
        if (createIt && ret == null) {
            ret = DefaultprofileFactory.eINSTANCE.createReference();
            if (this.fArtifact != null) {
                this.fArtifact.getInternalArtifact().setReference(ret);
            } else if (this.fFolderArtifact != null) {
                this.fFolderArtifact.getInternalArtifact().setReference(ret);
            } else {
                this.fURLArtifact.getInternalArtifact().setReference(ret);
            }
        }
        return ret;
    }

    @Override
    public String getDescription() {
        Reference ref = this.getInternalReference(false);
        if (ref == null) {
            return null;
        }
        Description description = ref.getDescription();
        if (description == null) {
            description = DefaultprofileFactory.eINSTANCE.createDescription();
            ref.setDescription(description);
        }
        return description.getValue();
    }

    @Override
    public String getKind() {
        Reference ref = this.getInternalReference(false);
        if (ref == null) {
            return null;
        }
        ReferenceKind kind = ref.getReferenceKind();
        if (kind == null) {
            kind = DefaultprofileFactory.eINSTANCE.createReferenceKind();
            ref.setReferenceKind(kind);
        }
        return kind.getName();
    }

    @Override
    public String getValue() {
        Reference ref = this.getInternalReference(false);
        if (ref == null) {
            return null;
        }
        return ref.getValue();
    }

    @Override
    public void setDescription(String descriptionValue) {
        Reference ref = this.getInternalReference(false);
        if (ref == null && descriptionValue == null) {
            return;
        }
        ref = this.getInternalReference(true);
        Description description = ref.getDescription();
        if (description == null) {
            description = DefaultprofileFactory.eINSTANCE.createDescription();
            ref.setDescription(description);
        }
        if (descriptionValue == null && description.getValue() != null || descriptionValue != null && !descriptionValue.equals(description.getValue())) {
            description.setValue(descriptionValue);
            this.fDirty = true;
        }
    }

    @Override
    public void setKind(String kindName) {
        Reference ref = this.getInternalReference(false);
        if (ref == null && kindName == null) {
            return;
        }
        ref = this.getInternalReference(true);
        ReferenceKind kind = ref.getReferenceKind();
        if (kind == null) {
            kind = DefaultprofileFactory.eINSTANCE.createReferenceKind();
            ref.setReferenceKind(kind);
        }
        if (kindName == null && kind.getName() != null || kindName != null && !kindName.equals(kind.getName())) {
            kind.setName(kindName);
            this.fDirty = true;
        }
    }

    @Override
    public void setValue(String value) {
        Reference ref = this.getInternalReference(false);
        if (ref == null && value == null) {
            return;
        }
        ref = this.getInternalReference(true);
        if (value == null && ref.getValue() != null || value != null && !value.equals(ref.getValue())) {
            ref.setValue(value);
            this.fDirty = true;
        }
    }

    boolean isDirty() {
        return this.fDirty;
    }
}

