/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ram.client;

import com.ibm.ram.client.RAMAsset;
import com.ibm.ram.client.RAMUser;
import com.ibm.ram.common.data.AssetInformation;
import com.ibm.ram.common.data.AssetTag;
import com.ibm.ram.common.data.UserInformation;
import com.ibm.ram.common.data.exception.RAMRuntimeException;
import com.ibm.ram.internal.client.bundles.ClientMessages;

public class RAMAssetTag
extends AssetTag {
    private RAMAsset fAsset;
    private AssetTag fAssetTag;
    private boolean fDirty;

    RAMAssetTag(RAMAsset asset, AssetTag tag) throws RAMRuntimeException {
        this.fAsset = asset;
        this.fAssetTag = tag;
    }

    RAMAssetTag(RAMAsset asset, String tag) throws RAMRuntimeException {
        this.fAsset = asset;
        this.fDirty = true;
        this.fAssetTag = new AssetTag();
        this.fAssetTag.setAsset(asset.getInternalAssetInformation());
        this.fAssetTag.setLabel(tag);
        this.fAssetTag.setTag(tag);
        this.fAssetTag.setOwner(asset.getSession().getUser().getInternalUser());
        this.setOwner(asset.getSession().getUser());
        this.fAssetTag.setCanDelete(true);
    }

    @Override
    public AssetInformation getAsset() {
        return this.fAsset;
    }

    @Override
    public int getId() {
        return this.fAssetTag.getId();
    }

    @Override
    public UserInformation getOwner() {
        return this.fAssetTag.getOwner();
    }

    @Override
    public String getTag() {
        return this.fAssetTag.getTag();
    }

    @Override
    public boolean isCanDelete() {
        return this.fAssetTag.isCanDelete();
    }

    boolean isDirty() {
        return this.fDirty;
    }

    @Override
    public String getLabel() {
        return this.fAssetTag.getLabel();
    }

    @Override
    public void setAsset(AssetInformation asset) {
        this.fAssetTag.setAsset(asset);
    }

    @Override
    public void setCanDelete(boolean canDelete) {
        throw new RAMRuntimeException(ClientMessages.getString("RAMAssetTag.CAN_DELETE_CANNOT_BE_SET"), true);
    }

    @Override
    public void setId(int id) {
        throw new RAMRuntimeException(ClientMessages.getString("RAMAssetTag.DB_ID_CANNOT_BE_SET"), true);
    }

    @Override
    public void setLabel(String label) {
        throw new RAMRuntimeException(ClientMessages.getString("RAMAssetTag.METHOD_NOT_IMPLEMENTED"), true);
    }

    @Override
    public void setOwner(UserInformation owner) {
        if (!(owner == null || owner instanceof RAMUser && ((RAMUser)owner).getSession() == ((RAMAsset)this.getAsset()).getSession())) {
            owner = ((RAMAsset)this.getAsset()).getSession().getUser(owner.getUid());
        }
        this.fAssetTag.setOwner(owner);
    }

    @Override
    public void setTag(String tag) {
        this.fAssetTag.setTag(tag);
    }

    public String toString() {
        return this.getLabel() != null ? this.getLabel() : (this.getTag() != null ? this.getTag() : super.toString());
    }
}

