/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ram.client;

import com.ibm.ram.client.IRAMSessionObject;
import com.ibm.ram.client.RAMAction;
import com.ibm.ram.client.RAMAsset;
import com.ibm.ram.client.RAMCategory;
import com.ibm.ram.client.RAMCommunity;
import com.ibm.ram.client.RAMSession;
import com.ibm.ram.client.RAMSubCategory;
import com.ibm.ram.common.data.Category;
import com.ibm.ram.common.data.CategorySchema;
import com.ibm.ram.common.data.CommonConstants;
import com.ibm.ram.common.data.CommunityInformation;
import com.ibm.ram.common.data.SubCategory;
import com.ibm.ram.common.data.exception.RAMRuntimeException;
import com.ibm.ram.common.util.ManifestAccessor;
import com.ibm.ram.defaultprofile.ClassificationSchema;
import com.ibm.ram.defaultprofile.DefaultprofileFactory;
import com.ibm.ram.defaultprofile.Description;
import com.ibm.ram.defaultprofile.Descriptor;
import com.ibm.ram.internal.client.bundles.ClientMessages;
import com.ibm.ram.internal.common.data.CategorySchemaSO;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;

public class RAMCategorySchema
extends CategorySchema
implements IRAMSessionObject {
    private static String CATEGORY_SCHEMA_HASH_KEY = "CATEGORY_SCHEMA:";
    private ManifestAccessor.ClassificationInfo fClassificationInfo;
    private ClassificationSchema fClassificationSchema;
    private CategorySchemaSO fCategorySchemaSO;
    private volatile RAMCategory[] fCategories;
    private Map fCategoriesByName;
    private Map fSubCategoriesById;
    private RAMAsset fAsset;
    private RAMSession fSession;
    private boolean fReadOnly = false;
    private RAMAction fAction;
    private boolean fDirty = false;
    private static final Logger logger = Logger.getLogger((String)RAMCategorySchema.class.getName());
    private static String SUB_CAT_BY_ID_MUTEX = "SUB_CAT_BY_ID";

    RAMCategorySchema(RAMSession session, ClassificationSchema internalClassificationSchema) {
        this.fSession = session;
        this.fClassificationSchema = internalClassificationSchema;
        this.fAction = RAMAction.UPDATE;
    }

    RAMCategorySchema(RAMAsset asset, ManifestAccessor.ClassificationInfo internalClassificationInfo) {
        this(asset, internalClassificationInfo, false);
    }

    RAMCategorySchema(RAMSession session, String name) {
        this.fSession = session;
        this.fClassificationSchema = DefaultprofileFactory.eINSTANCE.createClassificationSchema();
        this.fClassificationSchema.setName(name);
        this.fAction = RAMAction.CREATE;
        this.fDirty = true;
    }

    RAMCategorySchema(RAMAsset asset, ManifestAccessor.ClassificationInfo internalClassificationInfo, boolean setSchema) {
        this.fAsset = asset;
        this.fClassificationInfo = internalClassificationInfo;
        this.fClassificationSchema = internalClassificationInfo.getSchema();
        this.fReadOnly = setSchema;
        this.fAction = RAMAction.UPDATE;
    }

    ManifestAccessor.ClassificationInfo getInternalClassificationInfo() {
        return this.fClassificationInfo;
    }

    ClassificationSchema getInternalClassificationSchema() {
        return this.fClassificationSchema;
    }

    void setInternalClassificationSchema(ClassificationSchema schema) {
        this.fClassificationSchema = schema;
        this.clear();
    }

    RAMSession getSession() {
        return this.fSession;
    }

    RAMAsset getAsset() {
        return this.fAsset;
    }

    @Override
    public Category[] getCategories() {
        if (this.fCategories == null) {
            this.initCategoryCache();
        }
        return this.fCategories;
    }

    void categorySchemaCommited() throws RAMRuntimeException {
        this.fAction = RAMAction.UPDATE;
        this.setDirty(false);
    }

    public void clear() {
        this.fCategories = null;
        this.fSubCategoriesById = null;
        this.fCategoriesByName = null;
        this.fCategorySchemaSO = null;
    }

    @Override
    public Category getCategory(String name) {
        if (this.fCategoriesByName == null) {
            this.initCategoryCache();
        }
        return (RAMCategory)this.fCategoriesByName.get(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RAMSubCategory getSubCategoryById(String id) {
        if (this.fSubCategoriesById == null) {
            String string = SUB_CAT_BY_ID_MUTEX;
            synchronized (string) {
                if (this.fSubCategoriesById == null) {
                    HashMap<String, RAMSubCategory> tmpMap = new HashMap<String, RAMSubCategory>();
                    RAMCategory[] categories = (RAMCategory[])this.getCategories();
                    int i = 0;
                    while (i < categories.length) {
                        RAMSubCategory[] children = (RAMSubCategory[])categories[i].getSubCategories();
                        this.initSubCategoryByIdMap(children, tmpMap);
                        ++i;
                    }
                    this.fSubCategoriesById = tmpMap;
                }
            }
        }
        return (RAMSubCategory)this.fSubCategoriesById.get(id);
    }

    private void initSubCategoryByIdMap(RAMSubCategory[] subCategories, HashMap<String, RAMSubCategory> tmpMap) {
        if (subCategories != null) {
            int i = 0;
            while (i < subCategories.length) {
                tmpMap.put(subCategories[i].getId(), subCategories[i]);
                RAMSubCategory[] children = (RAMSubCategory[])subCategories[i].getSubCategories();
                this.initSubCategoryByIdMap(children, tmpMap);
                ++i;
            }
        }
    }

    void addCategory(RAMCategory catgeory) {
        RAMCategory[] curCats = (RAMCategory[])this.getCategories();
        RAMCategory[] newCats = new RAMCategory[curCats.length + 1];
        System.arraycopy(curCats, 0, newCats, 0, curCats.length);
        newCats[curCats.length] = catgeory;
        this.fCategoriesByName.put(catgeory.getName(), catgeory);
        this.fCategories = newCats;
    }

    void removeCategory(RAMCategory catgeory) {
        if (this.fCategoriesByName == null) {
            this.initCategoryCache();
        }
        if (this.fCategoriesByName.containsKey(catgeory.getName())) {
            RAMCategory[] curCats = (RAMCategory[])this.getCategories();
            RAMCategory[] newCats = new RAMCategory[curCats.length - 1];
            boolean found = false;
            int i = 0;
            while (i < curCats.length) {
                if (!found && catgeory.getName().equals(curCats[i].getName())) {
                    found = true;
                } else if (!found && !catgeory.getName().equals(curCats[i].getName()) && i < newCats.length) {
                    newCats[i] = curCats[i];
                } else if (i < newCats.length) {
                    newCats[i] = curCats[i - 1];
                }
                ++i;
            }
            if (!found) {
                throw new RAMRuntimeException("Sub Category " + catgeory.getName() + " was never found to delete");
            }
            this.fCategoriesByName.remove(catgeory.getName());
            if (this.fClassificationSchema != null && catgeory.getInternalNodeDescriptor() != null) {
                this.fClassificationSchema.getDescriptor().remove((Object)catgeory.getInternalNodeDescriptor());
            }
            this.fCategories = newCats;
            this.setDirty(true);
        }
    }

    private void initCategoryCache() throws RAMRuntimeException {
        this.fCategoriesByName = new HashMap();
        if (this.fReadOnly) {
            this.fCategories = new RAMCategory[0];
        } else {
            EList internalDescriptors = this.getInternalClassificationSchema().getDescriptor();
            if (internalDescriptors != null) {
                this.fCategories = new RAMCategory[internalDescriptors.size()];
                int i = 0;
                while (i < internalDescriptors.size()) {
                    this.fCategories[i] = new RAMCategory(this, (Descriptor)internalDescriptors.get(i), this.fReadOnly);
                    this.fCategoriesByName.put(this.fCategories[i].getName(), this.fCategories[i]);
                    ++i;
                }
            } else {
                this.fCategories = new RAMCategory[0];
            }
        }
    }

    @Override
    public String getName() {
        return this.fClassificationSchema.getName();
    }

    @Override
    public void setName(String name) {
        this.fClassificationSchema.setName(name);
        this.setDirty(true);
    }

    public String getDescription() {
        Description description = this.fClassificationSchema.getDescription();
        if (description == null) {
            description = DefaultprofileFactory.eINSTANCE.createDescription();
            this.fClassificationSchema.setDescription(description);
        }
        return description.getValue();
    }

    public void setDescription(String desciption) {
        String curDescription = this.getDescription();
        if (desciption == null && curDescription != null) {
            this.fClassificationSchema.setDescription(null);
            this.setDirty(true);
        } else if (desciption != null && !desciption.equals(curDescription)) {
            Description description = this.fClassificationSchema.getDescription();
            if (description == null) {
                description = DefaultprofileFactory.eINSTANCE.createDescription();
                this.fClassificationSchema.setDescription(description);
            }
            description.setValue(desciption);
            this.setDirty(true);
        }
    }

    @Override
    public String getURI() {
        if (super.getURI() == null && this.fClassificationSchema != null && this.fClassificationSchema.eResource() != null && this.fClassificationSchema.eResource().getURI() != null) {
            super.setURI(this.fClassificationSchema.eResource().getURI().toString());
        }
        return super.getURI();
    }

    @Override
    public void setURI(String uri) {
        throw new RAMRuntimeException(ClientMessages.getString("RAMCategorySchema.CANNOT_SET_URI"), true);
    }

    void setDirty(boolean dirtyFlag) {
        this.fDirty = dirtyFlag;
        if (dirtyFlag) {
            this.getSession().cache(this);
            if (this.fSubCategoriesById != null) {
                this.fSubCategoriesById = null;
            }
        } else {
            this.getSession().uncache(this);
        }
    }

    @Override
    public boolean isDirty() {
        return this.fDirty;
    }

    String getConfiguration() {
        String ret = null;
        if (this.fClassificationSchema != null) {
            Resource res = this.getResource();
            try {
                ByteArrayOutputStream bos = new ByteArrayOutputStream(1000);
                res.save((OutputStream)bos, Collections.EMPTY_MAP);
                ret = bos.toString("UTF-8");
            }
            catch (IOException e) {
                throw new RAMRuntimeException(ClientMessages.getString("RAMCategorySchema.1"), e);
            }
        }
        return ret;
    }

    Resource getResource() {
        ClassificationSchema cs = this.fClassificationSchema;
        Resource ret = null;
        if (cs != null && cs.eResource() != null) {
            ret = cs.eResource();
        } else if (cs != null) {
            ResourceSet rset = this.getSession().getResourceSet();
            ret = rset.createResource(URI.createURI((String)"ram:/serialize.xmi"));
            ret.getContents().add((Object)cs);
        }
        return ret;
    }

    void setConfiguration(String config) {
        try {
            ResourceSet rset = this.getSession().getResourceSet();
            Resource resource = rset.createResource(URI.createURI((String)"ram:/deserialize.xmi"));
            resource.load((InputStream)new ByteArrayInputStream(config.getBytes("UTF-8")), Collections.EMPTY_MAP);
        }
        catch (UnsupportedEncodingException e) {
            throw new RAMRuntimeException(ClientMessages.getString("RAMCategorySchema.3"), e);
        }
        catch (IOException e) {
            throw new RAMRuntimeException(ClientMessages.getString("RAMCategorySchema.4"), e);
        }
    }

    String getSessionKey() {
        String ret = this.getURI() != null ? String.valueOf(CATEGORY_SCHEMA_HASH_KEY) + this.getURI() : String.valueOf(CATEGORY_SCHEMA_HASH_KEY) + this.getName();
        return ret;
    }

    public String toString() {
        if (this.getURI() != null) {
            return String.valueOf(this.getName()) + "[" + this.getURI() + "]";
        }
        return this.getName();
    }

    @Override
    public void setCategories(Category[] categories) {
        throw new RAMRuntimeException(ClientMessages.getString("RAMCategorySchema.7"), true);
    }

    public boolean deleteCategory(String categoryName) {
        RAMCategory ret;
        if (this.fReadOnly) {
            throw new RAMRuntimeException(ClientMessages.getString("RAMCategorySchema.9"), true);
        }
        if (this.fCategoriesByName == null) {
            this.initCategoryCache();
        }
        if ((ret = (RAMCategory)this.fCategoriesByName.remove(categoryName)) != null) {
            ret.setSubCategories(new SubCategory[0]);
            RAMCategory[] catgeories = this.fCategoriesByName.values().toArray(new RAMCategory[this.fCategoriesByName.size()]);
            this.fCategories = catgeories;
            this.getSession().cache(this);
            this.setDirty(true);
            this.fClassificationSchema.getDescriptor().remove((Object)ret.getInternalDescriptor());
            return Boolean.TRUE;
        }
        logger.info((Object)("Cateroty:" + categoryName + " does not exist."));
        return Boolean.FALSE;
    }

    public RAMCategory createCategory(String name) {
        if (this.fReadOnly) {
            throw new RAMRuntimeException(ClientMessages.getString("RAMCategorySchema.8"), true);
        }
        if (this.fCategoriesByName == null) {
            this.initCategoryCache();
        }
        RAMCategory ret = new RAMCategory(this, name);
        this.fCategoriesByName.put(name, ret);
        RAMCategory[] catgeories = this.fCategoriesByName.values().toArray(new RAMCategory[this.fCategoriesByName.size()]);
        this.fCategories = catgeories;
        this.getSession().cache(this);
        this.setDirty(true);
        return ret;
    }

    @Override
    public RAMAction getAction() {
        return this.fAction;
    }

    public void setAction(RAMAction action) {
        if (action != RAMAction.CREATE && action != RAMAction.UPDATE && action != RAMAction.DELETE) {
            String message = MessageFormat.format(ClientMessages.getString("ACTION_NOT_ACCEPTABLE"), action.getName(), this.getClass().getName());
            throw new RAMRuntimeException(message, true);
        }
        this.fAction = action;
        if (action == RAMAction.DELETE) {
            this.setDirty(true);
        }
    }

    public boolean isRestricted() {
        return new CommonConstants().getSHARING_TYPE_RESTRICTED() == this.getCategorySchemaSO().getSharingType();
    }

    public void setRestricted(boolean restricted) {
        if (restricted && this.getCategorySchemaSO().getSharingType() == new CommonConstants().getSHARING_TYPE_GLOBAL()) {
            try {
                CommunityInformation[] adminCommunities = this.getSession().getRAMClient().getRAM1Webservice().getAdminGroups();
                int[] communityIds = new int[adminCommunities.length];
                int i = 0;
                while (i < adminCommunities.length) {
                    communityIds[i] = adminCommunities[i].getId();
                    ++i;
                }
                this.getCategorySchemaSO().setCommunityIDs(communityIds);
            }
            catch (Exception e) {
                logger.warn((Object)"Failed to load communities user administrates", (Throwable)e);
                this.getCategorySchemaSO().setCommunityIDs(new int[0]);
            }
        }
        int type = restricted ? new CommonConstants().getSHARING_TYPE_RESTRICTED() : new CommonConstants().getSHARING_TYPE_GLOBAL();
        this.getCategorySchemaSO().setSharingType(type);
        this.setDirty(true);
    }

    public RAMCommunity[] getRestrictedCommunities() throws RAMRuntimeException {
        RAMCommunity[] ret = null;
        try {
            if (!this.isRestricted()) {
                return this.getSession().getAllCommunities();
            }
            CategorySchemaSO schemaSO = this.getCategorySchemaSO();
            ArrayList<RAMCommunity> communities = new ArrayList<RAMCommunity>();
            int i = 0;
            while (i < schemaSO.getCommunityIDs().length) {
                RAMCommunity com = this.getSession().getCommunity(schemaSO.getCommunityIDs()[i]);
                if (com == null) {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("Failed to find community for id " + schemaSO.getCommunityIDs()[i]));
                    }
                } else {
                    communities.add(com);
                }
                ++i;
            }
            ret = communities.toArray(new RAMCommunity[communities.size()]);
            return ret;
        }
        catch (RAMRuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RAMRuntimeException(e.getLocalizedMessage(), e);
        }
    }

    public void setRestrictedCommunities(CommunityInformation[] communities) {
        if (communities == null || communities.length == 0) {
            this.setRestricted(false);
            this.getCategorySchemaSO().setCommunityIDs(new int[0]);
        } else {
            int[] ids = new int[communities.length];
            int i = 0;
            while (i < communities.length) {
                if (communities[i] == null) {
                    throw new RAMRuntimeException("Invlaid input communities[" + i + "] was null");
                }
                ids[i] = communities[i].getId();
                ++i;
            }
            this.getCategorySchemaSO().setSharingType(new CommonConstants().getSHARING_TYPE_RESTRICTED());
            this.getCategorySchemaSO().setCommunityIDs(ids);
        }
        this.setDirty(true);
    }

    private CategorySchemaSO getCategorySchemaSO() {
        if (this.fCategorySchemaSO == null) {
            CategorySchemaSO[] so = null;
            if (this.getAction() != RAMAction.CREATE) {
                try {
                    so = this.getSession().getRAMClient().getRAM1Webservice().getCategorySchemas(new String[]{this.getURI()}, true);
                }
                catch (Exception e) {
                    logger.warn((Object)("Category Schema was not found on server " + this.getURI()), (Throwable)e);
                }
            }
            this.fCategorySchemaSO = so == null || so.length < 1 ? new CategorySchemaSO() : so[0];
        }
        return this.fCategorySchemaSO;
    }
}

