/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ram.client;

import com.ibm.ram.client.RAMAsset;
import com.ibm.ram.client.RAMRelationshipType;
import com.ibm.ram.common.data.Asset;
import com.ibm.ram.common.data.AssetIdentification;
import com.ibm.ram.common.data.Relationship;
import com.ibm.ram.common.data.RelationshipRange;
import com.ibm.ram.common.data.RelationshipType;
import com.ibm.ram.common.data.exception.RAMRuntimeException;
import com.ibm.ram.defaultprofile.RelatedAsset;
import com.ibm.ram.internal.client.bundles.ClientMessages;
import com.ibm.ram.internal.common.util.RelationshipRangeUtility;

public class RAMRelationship
extends Relationship {
    private RAMAsset fParentAsset;
    private RAMAsset fChildAsset;
    private RelatedAsset fRelatedAsset;
    private volatile RAMRelationshipType fRelationshipType;
    private boolean rangeOnly;

    RAMRelationship(RAMAsset parentAsset, RAMAsset childAsset, RelatedAsset relatedAsset) throws RAMRuntimeException {
        this.fParentAsset = parentAsset;
        this.fChildAsset = childAsset;
        this.fRelatedAsset = relatedAsset;
        this.rangeOnly = this.fChildAsset == null && RelationshipRangeUtility.isRangeRelationship(relatedAsset) && RelationshipRangeUtility.getRange(relatedAsset).getRangeInfo().toString().equals(relatedAsset.getAssetVersion());
    }

    @Override
    public Asset getParentAsset() {
        return this.fParentAsset;
    }

    public Asset getChildAsset() throws RAMRuntimeException {
        if (this.fChildAsset == null && !this.rangeOnly) {
            AssetIdentification id = new AssetIdentification(this.fRelatedAsset.getAssetId(), this.fRelatedAsset.getAssetVersion());
            this.fChildAsset = ((RAMAsset)this.getParentAsset()).getSession().getAsset(id);
        }
        return this.fChildAsset;
    }

    public RelationshipType getRelationshipType() throws RAMRuntimeException {
        if (this.fRelationshipType == null) {
            this.fRelationshipType = ((RAMAsset)this.getParentAsset()).getSession().getRelationshipType(this.fRelatedAsset.getRelationshipType());
        }
        return this.fRelationshipType;
    }

    public void setRelationshipType(RelationshipType type) {
        this.fRelationshipType = (RAMRelationshipType)type;
    }

    @Override
    public String getChildAssetGUID() {
        String ret = null;
        ret = this.fChildAsset != null ? this.fChildAsset.getIdentification().getGUID() : this.fRelatedAsset.getAssetId();
        return ret;
    }

    @Override
    public String getChildAssetVersion() {
        String ret = null;
        ret = this.fChildAsset != null ? this.fChildAsset.getIdentification().getVersion() : this.fRelatedAsset.getAssetVersion();
        return ret;
    }

    RelatedAsset getInternalRelatedAsset() {
        return this.fRelatedAsset;
    }

    @Override
    public String toString() {
        if (this.fRelatedAsset == null || this.fParentAsset == null) {
            return super.toString();
        }
        String parent = this.fParentAsset.toString();
        String child = null;
        String relName = null;
        child = this.fChildAsset != null ? this.fChildAsset.toString() : String.valueOf(this.fRelatedAsset.getAssetId()) + "[" + this.fRelatedAsset.getAssetVersion() + "]";
        relName = this.fRelationshipType != null ? this.fRelationshipType.toString() : this.fRelatedAsset.getName();
        return String.valueOf(relName) + ":(" + parent + ")->(" + child + ")";
    }

    @Override
    public String getRelationshipTypeName() {
        String name = this.fRelationshipType != null ? this.fRelationshipType.getName() : this.fRelatedAsset.getRelationshipType();
        return name;
    }

    @Override
    public void setChildAssetGUID(String childAssetGUID) {
        throw new RAMRuntimeException(ClientMessages.getString("RAMAsset.NOT_IMPLEMENTED"), true);
    }

    @Override
    public void setChildAssetVersion(String childAssetVersion) {
        throw new RAMRuntimeException(ClientMessages.getString("RAMAsset.NOT_IMPLEMENTED"), true);
    }

    @Override
    public void setParentAsset(Asset parentAsset) {
        throw new RAMRuntimeException(ClientMessages.getString("RAMAsset.NOT_IMPLEMENTED"), true);
    }

    @Override
    public void setRelationshipTypeName(String relationshipTypeName) {
        throw new RAMRuntimeException(ClientMessages.getString("RAMAsset.NOT_IMPLEMENTED"), true);
    }

    public RelationshipRange getRelationshipRange() {
        return this.fRelatedAsset != null ? RelationshipRangeUtility.getRange(this.fRelatedAsset) : null;
    }

    void removeRange() {
        if (this.fRelatedAsset != null) {
            this.fRelatedAsset.setDescription(null);
        }
    }
}

