/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ram.common.util;

import com.ibm.ram.common.util.ClosableIterator;
import com.ibm.ram.common.util.EmptyIterator;
import java.util.Iterator;
import java.util.NoSuchElementException;

public abstract class ClosableLinkedIterator<E>
implements ClosableIterator<E> {
    private Iterator<E> currentItr = EmptyIterator.emptyIterator();

    @Override
    public void close() {
        try {
            if (this.currentItr instanceof ClosableIterator) {
                ((ClosableIterator)this.currentItr).close();
            }
        }
        finally {
            this.closing();
        }
    }

    protected abstract void closing();

    protected abstract Iterator<E> getNextItr();

    private Iterator<E> nextItr() {
        if (this.currentItr instanceof ClosableIterator) {
            ((ClosableIterator)this.currentItr).close();
        }
        this.currentItr = this.getNextItr();
        return this.currentItr;
    }

    @Override
    public boolean hasNext() {
        while (this.currentItr != null) {
            if (this.currentItr.hasNext()) {
                return true;
            }
            this.nextItr();
        }
        return false;
    }

    @Override
    public E next() {
        if (this.currentItr != null && this.hasNext()) {
            return this.currentItr.next();
        }
        throw new NoSuchElementException();
    }

    @Override
    public void remove() {
        if (this.currentItr == null) {
            throw new IllegalStateException();
        }
        this.currentItr.remove();
    }

    @Override
    public Iterator<E> iterator() {
        return this;
    }
}

