/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ram.common.util;

import com.ibm.ram.common.util.ClosableIterator;
import java.util.Iterator;

public class ClosableMultipleIterator<E>
implements ClosableIterator<E> {
    private final Iterator<E> itr1;
    private final Iterator<E> itr2;
    private boolean closedItr1;
    private boolean closedItr2;

    public ClosableMultipleIterator(Iterator<E> itr1, Iterator<E> itr2) {
        this.itr1 = itr1;
        this.itr2 = itr2;
    }

    @Override
    public Iterator<E> iterator() {
        return this;
    }

    @Override
    public void close() {
        try {
            this.close1();
        }
        finally {
            this.close2();
        }
    }

    private void close1() {
        if (!this.closedItr1 && this.itr1 instanceof ClosableIterator) {
            this.closedItr1 = true;
            ((ClosableIterator)this.itr1).close();
        }
    }

    private void close2() {
        if (!this.closedItr2 && this.itr2 instanceof ClosableIterator) {
            this.closedItr2 = true;
            ((ClosableIterator)this.itr2).close();
        }
    }

    @Override
    public boolean hasNext() {
        if (!this.closedItr1) {
            if (this.itr1.hasNext()) {
                return true;
            }
            this.close1();
        }
        if (!this.closedItr2) {
            if (this.itr2.hasNext()) {
                return true;
            }
            this.close2();
        }
        return false;
    }

    @Override
    public E next() {
        return !this.closedItr1 ? this.itr1.next() : this.itr2.next();
    }

    @Override
    public void remove() {
        if (!this.closedItr1) {
            this.itr1.remove();
        } else {
            this.itr2.remove();
        }
    }
}

