/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ram.common.util;

import com.ibm.ram.common.util.EventList;
import com.ibm.ram.internal.jaxb.PolicyResult;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class FixedSizeSortedPolicyResultEventList
extends EventList<PolicyResult> {
    private final int CAPACITY = 100;

    public FixedSizeSortedPolicyResultEventList() {
    }

    public FixedSizeSortedPolicyResultEventList(List<PolicyResult> list) {
        super(list);
        this.shrinkList();
    }

    @Override
    public boolean add(PolicyResult o) {
        boolean retVal = this.returnIt(this.list.add(o));
        this.shrinkList();
        return retVal;
    }

    @Override
    public void add(int index, PolicyResult element) {
        this.list.add(index, element);
        this.shrinkList();
        this.applyChanged(true);
    }

    @Override
    public boolean addAll(Collection<? extends PolicyResult> c) {
        boolean retVal = this.returnIt(this.list.addAll(c));
        this.shrinkList();
        return retVal;
    }

    @Override
    public boolean addAll(int index, Collection<? extends PolicyResult> c) {
        boolean retVal = this.returnIt(this.list.addAll(index, c));
        this.shrinkList();
        return retVal;
    }

    private void shrinkList() {
        if (this.list.size() > 100) {
            HashMap<String, Integer> policyResultsMap = new HashMap<String, Integer>();
            for (PolicyResult policyResult : this.list) {
                Integer count = (Integer)policyResultsMap.get(policyResult.getPolicyConfiguration().getIdentifier());
                if (count == null) {
                    count = 0;
                }
                count = count + 1;
                policyResultsMap.put(policyResult.getPolicyConfiguration().getIdentifier(), count);
            }
            PolicyResultCountComparator policyResultCountComparator = new PolicyResultCountComparator(policyResultsMap);
            while (this.list.size() > 100) {
                Collections.sort(this.list, policyResultCountComparator);
                PolicyResult removedPolicyResult = (PolicyResult)this.list.remove(this.list.size() - 1);
                int count = (Integer)policyResultsMap.get(removedPolicyResult.getPolicyConfiguration().getIdentifier());
                policyResultsMap.put(removedPolicyResult.getPolicyConfiguration().getIdentifier(), --count);
            }
            Collections.sort(this.list, new Comparator<PolicyResult>(){

                @Override
                public int compare(PolicyResult o1, PolicyResult o2) {
                    return o1.getRunDate().compare(o2.getRunDate());
                }
            });
        }
    }

    public static class PolicyResultCountComparator
    implements Comparator<PolicyResult> {
        private Map<String, Integer> policyResultCountMap;

        public PolicyResultCountComparator(Map<String, Integer> policyResultCountMap) {
            this.policyResultCountMap = policyResultCountMap;
        }

        @Override
        public int compare(PolicyResult p1, PolicyResult p2) {
            String p2Identifier;
            String p1Identifier = p1.getPolicyConfiguration().getIdentifier();
            int retVal = !p1Identifier.equals(p2Identifier = p2.getPolicyConfiguration().getIdentifier()) ? this.policyResultCountMap.get(p1Identifier) - this.policyResultCountMap.get(p2Identifier) : p2.getRunDate().compare(p1.getRunDate());
            return retVal;
        }
    }
}

