/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ram.common.util;

import com.ibm.ram.internal.rest.RequestStatus;
import com.ibm.ram.internal.rest.Response;
import com.ibm.ram.internal.rest.RestContext;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Timestamp;

public class InputStreamInformation {
    private InputStream is;
    private final long size;
    public static final long UNKNOWN_SIZE = -1L;
    private final boolean exactSize;
    private String filename;
    private String filenameBase;
    private String filenameExtension;
    private long lastmodified = -1L;
    private String etag;
    private String filePath;
    private String contentType;

    public static InputStreamInformation create(File file) throws FileNotFoundException {
        return InputStreamInformation.create(file, InputStreamInformation.etag(file));
    }

    private static InputStreamInformation create(File file, String etag) throws FileNotFoundException {
        return new InputStreamInformation(new FileInputStream(file), file.length(), true, file.getName(), file.lastModified(), etag, null, file.getAbsolutePath());
    }

    private static String etag(File file) {
        return InputStreamInformation.eTag(file, file);
    }

    public static String eTag(File timestampFile, File nameFile) {
        return String.valueOf(timestampFile.lastModified() * 31L + (long)nameFile.getAbsolutePath().hashCode());
    }

    public static InputStreamInformation createInfoOnly(File file) {
        return InputStreamInformation.createInfoOnly(file, InputStreamInformation.etag(file));
    }

    private static InputStreamInformation createInfoOnly(File file, String etag) {
        return new InputStreamInformation(null, file.length(), true, file.getName(), file.lastModified(), etag);
    }

    public static InputStreamInformation create(File file, Response<InputStreamInformation> response, RequestStatus rq) throws FileNotFoundException {
        InputStreamInformation isi = InputStreamInformation.create(file, rq);
        response.setLastModified(isi.getLastmodified());
        response.setEtag(isi.getEtag());
        response.setSerializationFormat(RestContext.SerializationFormat.InputStreamInformation);
        response.setValue(isi);
        return isi;
    }

    public static InputStreamInformation create(File file, RequestStatus rq) throws FileNotFoundException {
        if (!file.exists()) {
            throw new FileNotFoundException(file.getName());
        }
        String etag = String.valueOf(file.lastModified() * 31L + (long)file.getAbsolutePath().hashCode());
        if (rq.shouldReturnContent(new Timestamp(file.lastModified()), etag) && !rq.isInfoOnly()) {
            return InputStreamInformation.create(file, etag);
        }
        return InputStreamInformation.createInfoOnly(file, etag);
    }

    public InputStreamInformation(InputStream is, long size, boolean exactSize) {
        this(is, size, exactSize, null, -1L, null);
    }

    public InputStreamInformation(InputStream is, long size, boolean exactSize, String filename, long lastmodifed, String etag) {
        this(is, size, exactSize, filename, lastmodifed, etag, null);
    }

    public InputStreamInformation(InputStream is, long size, boolean exactSize, String filename, long lastmodifed, String etag, String contentType) {
        this.is = is;
        this.size = size;
        this.exactSize = size != -1L && exactSize;
        this.setFilename(filename);
        this.lastmodified = lastmodifed;
        this.etag = etag;
        this.contentType = contentType;
    }

    protected InputStreamInformation(InputStream is, long size, boolean exactSize, String filename, long lastmodifed, String etag, String contentType, String filePath) {
        this(is, size, exactSize, filename, lastmodifed, etag, contentType);
        this.setFilePath(filePath);
    }

    public InputStreamInformation(InputStream is) {
        this(is, -1L, false);
    }

    public InputStream getIs() {
        return this.is;
    }

    public boolean isKnownSize() {
        return this.getSize() != -1L;
    }

    public long getSize() {
        return this.size;
    }

    public boolean isExactSize() {
        return this.exactSize;
    }

    public String getFilename() {
        return this.filename;
    }

    public void setFilename(String filename) {
        if (filename != null) {
            int extndx = filename.lastIndexOf(46);
            this.filename = filename;
            if (extndx >= 0) {
                this.filenameBase = filename.substring(0, extndx);
                this.filenameExtension = filename.substring(extndx + 1);
            } else {
                this.filenameBase = filename;
                this.filenameExtension = "";
            }
        } else {
            this.filenameExtension = "";
            this.filenameBase = "";
            this.filename = "";
        }
    }

    public long getLastmodified() {
        return this.lastmodified;
    }

    public void setLastmodifed(long lastmodified) {
        this.lastmodified = lastmodified;
    }

    public String getEtag() {
        return this.etag;
    }

    public void setEtag(String etag) {
        this.etag = etag;
    }

    public String getFilePath() {
        return this.filePath;
    }

    public void setFilePath(String filePath) {
        this.filePath = filePath;
    }

    public String getContentType() {
        return this.contentType;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public void closeIs() {
        if (this.is != null) {
            try {
                this.is.close();
                this.is = null;
            }
            catch (IOException iOException) {}
        }
    }

    public String getFilenameBase() {
        return this.filenameBase;
    }

    public void setFilenameBase(String filenameBase) {
        this.filenameBase = filenameBase;
        this.filename = this.filenameExtension.length() > 0 ? String.valueOf(this.filenameBase) + '.' + this.filenameExtension : this.filenameBase;
    }

    public String getFilenameExtension() {
        return this.filenameExtension;
    }

    public void setFilenameExtension(String filenameExtension) {
        this.filenameExtension = filenameExtension;
        this.filename = filenameExtension.length() > 0 ? String.valueOf(this.filenameBase) + '.' + filenameExtension : this.filenameBase;
    }
}

