/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ram.internal.client.util;

import com.ibm.ram.client.RAMAsset;
import com.ibm.ram.client.RAMAssetAttribute;
import com.ibm.ram.client.RAMAssetQueryBuilder;
import com.ibm.ram.client.RAMAssetTag;
import com.ibm.ram.client.RAMAssetType;
import com.ibm.ram.client.RAMCategory;
import com.ibm.ram.client.RAMCategorySchema;
import com.ibm.ram.client.RAMCommunity;
import com.ibm.ram.client.RAMForum;
import com.ibm.ram.client.RAMPost;
import com.ibm.ram.client.RAMRelationship;
import com.ibm.ram.client.RAMRelationshipType;
import com.ibm.ram.client.RAMSession;
import com.ibm.ram.client.RAMTopic;
import com.ibm.ram.client.RAMUser;
import com.ibm.ram.client.copy.CopyOption;
import com.ibm.ram.client.status.RAMStatusMonitor;
import com.ibm.ram.common.data.Asset;
import com.ibm.ram.common.data.AssetAttribute;
import com.ibm.ram.common.data.AssetFeedback;
import com.ibm.ram.common.data.AssetSearchResult;
import com.ibm.ram.common.data.AssetTag;
import com.ibm.ram.common.data.Category;
import com.ibm.ram.common.data.CategorySchema;
import com.ibm.ram.common.data.Forum;
import com.ibm.ram.common.data.Post;
import com.ibm.ram.common.data.Relationship;
import com.ibm.ram.common.data.SearchQuery;
import com.ibm.ram.common.data.SearchResult;
import com.ibm.ram.common.data.SubCategory;
import com.ibm.ram.common.data.Topic;
import com.ibm.ram.common.data.UserInformation;
import com.ibm.ram.common.data.exception.RAMRuntimeException;
import com.ibm.ram.internal.client.RAMMappings;
import com.ibm.ram.internal.client.bundles.ClientMessages;
import com.ibm.ram.internal.client.util.AssetConstants;
import com.ibm.ram.internal.common.util.SearchUtil;
import com.ibm.ram.internal.common.util.Utilities;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.IProgressMonitor;

public class AssetUtil
implements AssetConstants {
    private static final Logger logger = Logger.getLogger((String)AssetUtil.class.getName());

    public static <T> List<T> createList(T[] array) {
        if (array == null) {
            return new ArrayList();
        }
        ArrayList<T> ret = new ArrayList<T>(array.length);
        int i = 0;
        while (i < array.length) {
            ret.add(array[i]);
            ++i;
        }
        return ret;
    }

    public static SubCategory fetchSubCategory(RAMSession session, String fullPath) {
        if (fullPath == null || fullPath.indexOf("/") == -1) {
            return null;
        }
        String schemaName = fullPath.substring(0, fullPath.indexOf("/"));
        if (fullPath.indexOf("/", schemaName.length() + 1) == -1) {
            return null;
        }
        String categoryName = fullPath.substring(schemaName.length() + 1, fullPath.indexOf("/", schemaName.length() + 1));
        if (fullPath.length() < schemaName.length() + categoryName.length() + 2) {
            return null;
        }
        String rest = fullPath.substring(schemaName.length() + categoryName.length() + 2);
        RAMCategorySchema schema = session.getCategorySchema(schemaName);
        if (schema == null) {
            return null;
        }
        RAMCategory category = (RAMCategory)schema.getCategory(categoryName);
        if (category == null) {
            return null;
        }
        return category.getSubCategory(rest);
    }

    public static RAMAsset portAssetInfo(RAMSession targetSession, Asset sourceAsset, RAMMappings mappings, boolean logErrors, IProgressMonitor monitor) throws RAMRuntimeException {
        RAMAsset targetAsset = null;
        monitor.beginTask("Port Asset", 200);
        if (!monitor.isCanceled()) {
            try {
                String GUID = sourceAsset.getIdentification().getGUID();
                String version = sourceAsset.getIdentification().getVersion();
                String sourceKey = RAMMappings.createSessionKey(GUID, version);
                String targetKey = (String)mappings.getAssetMappings().get(sourceKey);
                if (targetKey != null) {
                    String[] targetGUIDVersion = RAMMappings.getGUIDAndVersionFromSessionKey(targetKey);
                    GUID = targetGUIDVersion[0];
                    version = targetGUIDVersion[1];
                }
                RAMStatusMonitor monitor2 = new RAMStatusMonitor(monitor, 100);
                targetAsset = targetSession.createAsset(sourceAsset, GUID, version, monitor2);
            }
            catch (RAMRuntimeException rAMRuntimeException) {
                if (targetAsset == null) {
                    targetAsset = targetSession.createAsset(sourceAsset.getIdentification().getGUID(), sourceAsset.getIdentification().getVersion());
                }
                targetAsset.setName(sourceAsset.getName());
            }
        }
        RAMStatusMonitor monitor2 = new RAMStatusMonitor(monitor, 100);
        AssetUtil.portAssetInfo(targetAsset, sourceAsset, mappings, true, true, true, logErrors, (IProgressMonitor)monitor2);
        return targetAsset;
    }

    public static void portAssetInfo(RAMAsset targetAsset, Asset sourceAsset, RAMMappings mappings, boolean portForums, boolean portTags, boolean portFeedback, boolean logErrors, CopyOption co, IProgressMonitor monitor) throws RAMRuntimeException {
        String message = MessageFormat.format(ClientMessages.getString("AssetUtil.PORT_ASSET_INFO"), sourceAsset.getName());
        monitor.beginTask(message, 100);
        RAMSession targetSession = targetAsset.getSession();
        if (!monitor.isCanceled()) {
            AssetTag[] sourceTags;
            Forum[] sourceForums;
            UserInformation[] targetOwners;
            if (monitor.isCanceled()) {
                return;
            }
            monitor.worked(20);
            if (co.isSet(8L)) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Start: copy Community from: " + sourceAsset.toString() + " to " + targetAsset.toString()));
                }
                if (sourceAsset.getCommunityName() != null) {
                    String mappedName;
                    String communityName = sourceAsset.getCommunityName();
                    if (mappings.getCommunityNameMappings().containsKey(communityName) && (mappedName = (String)mappings.getCommunityNameMappings().get(communityName)) != null) {
                        communityName = mappedName;
                    }
                    if (!mappings.isInvalidCommunity(communityName)) {
                        RAMCommunity community = targetSession.getCommunity(communityName);
                        if (community != null) {
                            targetAsset.setCommunityName(communityName);
                        } else {
                            mappings.setCommunityIsInvalid(communityName, true);
                        }
                    }
                    if (!mappings.isInvalidCommunity(communityName)) {
                        targetAsset.setCommunityName(communityName);
                    }
                } else {
                    targetAsset.setCommunityName(null);
                }
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("End: copy Community from: " + sourceAsset.toString() + " to " + targetAsset.toString()));
                }
            }
            if (monitor.isCanceled()) {
                return;
            }
            monitor.worked(10);
            if (co.isSet(16L)) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Start: copy AssetType from: " + sourceAsset.toString() + " to " + targetAsset.toString()));
                }
                if (sourceAsset.getAssetType() != null) {
                    String mappedName;
                    String uri = sourceAsset.getAssetType().getURI();
                    boolean done = false;
                    if (uri != null) {
                        RAMAssetType assetType = targetSession.getAssetTypeByURI(uri);
                        if (assetType != null) {
                            targetAsset.setAssetType(assetType);
                            done = true;
                        } else if (mappings.getAssetTypeNameMappings().containsKey(uri) && (mappedName = (String)mappings.getAssetTypeNameMappings().get(uri)) != null) {
                            targetAsset.setTypeName(mappedName);
                            done = true;
                        }
                    }
                    if (!done) {
                        String assetTypeName = sourceAsset.getAssetType().getName();
                        if (mappings.getAssetTypeNameMappings().containsKey(assetTypeName) && (mappedName = (String)mappings.getAssetTypeNameMappings().get(assetTypeName)) != null) {
                            assetTypeName = mappedName;
                        }
                        if (!mappings.isInvalidAssetType(assetTypeName)) {
                            RAMAssetType type = targetSession.getAssetType(assetTypeName);
                            if (type != null) {
                                targetAsset.setTypeName(assetTypeName);
                            } else {
                                mappings.setAssetTypeIsInvalid(assetTypeName, true);
                                targetAsset.setAssetType(null);
                            }
                        }
                    }
                } else {
                    targetAsset.setAssetType(null);
                }
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("End: copy AssetType from: " + sourceAsset.toString() + " to " + targetAsset.toString()));
                }
            }
            if (monitor.isCanceled()) {
                return;
            }
            monitor.worked(10);
            if (co.isSet(32L)) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Start: copy AssetCategory from: " + sourceAsset.toString() + " to " + targetAsset.toString()));
                }
                AssetUtil.portAssetCategories(sourceAsset, mappings, targetAsset, logErrors);
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("End: copy AssetCategory from: " + sourceAsset.toString() + " to " + targetAsset.toString()));
                }
            }
            if (monitor.isCanceled()) {
                return;
            }
            monitor.worked(15);
            if (co.isSet(64L)) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Start: copy AssetAttribute from: " + sourceAsset.toString() + " to " + targetAsset.toString()));
                }
                AssetUtil.portAssetAttributes(sourceAsset, mappings, targetAsset, logErrors);
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("End: copy AssetAttribute from: " + sourceAsset.toString() + " to " + targetAsset.toString()));
                }
            }
            if (monitor.isCanceled()) {
                return;
            }
            monitor.worked(15);
            UserInformation[] sourceOwners = sourceAsset.getOwners();
            if (sourceOwners != null && co.isSet(128L)) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Start: copy Asset Owners from: " + sourceAsset.toString() + " to " + targetAsset.toString()));
                }
                targetOwners = new RAMUser[sourceOwners.length];
                int i = 0;
                while (i < sourceOwners.length) {
                    try {
                        RAMUser targetUser;
                        String mappedId;
                        String ownerId = sourceOwners[i].getUid();
                        if (mappings.getUserIdMappings().containsKey(ownerId) && (mappedId = (String)mappings.getUserIdMappings().get(ownerId)) != null) {
                            ownerId = mappedId;
                        }
                        if ((targetUser = targetAsset.getSession().getUser(ownerId)) == null) {
                            String message2 = MessageFormat.format(ClientMessages.getString("AssetUtil.USER_NOT_FOUND"), sourceOwners[i]);
                            logger.warn((Object)message2);
                            targetOwners[i] = targetAsset.getSession().getUser();
                        } else {
                            targetOwners[i] = targetUser;
                        }
                    }
                    catch (Exception e) {
                        logger.warn((Object)e.getLocalizedMessage(), (Throwable)e);
                    }
                    ++i;
                }
                targetAsset.setOwners(targetOwners);
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("End: copy Asset Owners from: " + sourceAsset.toString() + " to " + targetAsset.toString()));
                }
            } else {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Owners info in source asset: " + sourceAsset.toString() + " not found. Use RAMSession user instead."));
                }
                targetOwners = new RAMUser[]{targetAsset.getSession().getUser()};
                targetAsset.setOwners(targetOwners);
            }
            if (monitor.isCanceled()) {
                return;
            }
            monitor.worked(10);
            if (portForums && (sourceForums = sourceAsset.getForums()) != null) {
                int i = 0;
                while (i < sourceForums.length) {
                    boolean exists = false;
                    Forum[] targetForums = targetAsset.getForums();
                    int j = 0;
                    while (j < targetForums.length) {
                        if (sourceForums[i].getTitle().equals(targetForums[j].getTitle())) {
                            exists = true;
                            break;
                        }
                        ++j;
                    }
                    if (!exists) {
                        RAMUser targetUser;
                        String mappedId;
                        Forum sourceForum = sourceForums[i];
                        RAMForum newForum = targetAsset.createForum(sourceForum.getTitle(), sourceForum.getDescription());
                        newForum.setSubmissionDate(sourceForum.getSubmissionDate());
                        String submitterid = sourceForum.getSubmitter().getUid();
                        if (mappings.getUserIdMappings().containsKey(submitterid) && (mappedId = (String)mappings.getUserIdMappings().get(submitterid)) != null) {
                            submitterid = mappedId;
                        }
                        if ((targetUser = targetAsset.getSession().getUser(submitterid)) == null) {
                            String message2 = MessageFormat.format(ClientMessages.getString("AssetUtil.USER_NOT_FOUND"), sourceOwners[i]);
                            logger.warn((Object)message2);
                            newForum.setSubmitter(targetAsset.getSession().getUser());
                        } else {
                            newForum.setSubmitter(targetUser);
                        }
                        Topic[] sourceTopics = sourceForum.getTopics();
                        int j2 = 0;
                        while (j2 < sourceTopics.length) {
                            String mappedId2;
                            Topic sourceTopic = sourceTopics[j2];
                            RAMTopic newTopic = newForum.createTopic(sourceTopic.getTitle(), sourceTopic.getDescription());
                            newTopic.setSubmissionDate(sourceTopic.getSubmissionDate());
                            submitterid = sourceTopic.getSubmitter().getUid();
                            if (mappings.getUserIdMappings().containsKey(submitterid) && (mappedId2 = (String)mappings.getUserIdMappings().get(submitterid)) != null) {
                                submitterid = mappedId2;
                            }
                            if ((targetUser = targetAsset.getSession().getUser(submitterid)) == null) {
                                String message2 = MessageFormat.format(ClientMessages.getString("AssetUtil.USER_NOT_FOUND"), sourceOwners[i]);
                                logger.warn((Object)message2);
                                newTopic.setSubmitter(targetAsset.getSession().getUser());
                            } else {
                                newTopic.setSubmitter(targetUser);
                            }
                            Post[] sourcePosts = sourceTopic.getPosts();
                            int k = 0;
                            while (k < sourcePosts.length) {
                                String mappedId3;
                                Post sourcePost = sourcePosts[k];
                                RAMPost newPost = newTopic.createPost(sourcePost.getTitle(), sourcePost.getDescription());
                                newPost.setSubmissionDate(sourcePost.getSubmissionDate());
                                submitterid = sourcePost.getSubmitter().getUid();
                                if (mappings.getUserIdMappings().containsKey(submitterid) && (mappedId3 = (String)mappings.getUserIdMappings().get(submitterid)) != null) {
                                    submitterid = mappedId3;
                                }
                                if ((targetUser = targetAsset.getSession().getUser(submitterid)) == null) {
                                    String message2 = MessageFormat.format(ClientMessages.getString("AssetUtil.USER_NOT_FOUND"), sourceOwners[i]);
                                    logger.warn((Object)message2);
                                    newPost.setSubmitter(targetAsset.getSession().getUser());
                                } else {
                                    newPost.setSubmitter(targetUser);
                                }
                                ++k;
                            }
                            ++j2;
                        }
                    }
                    ++i;
                }
            }
            if (monitor.isCanceled()) {
                return;
            }
            monitor.worked(5);
            if (portFeedback) {
                AssetFeedback[] feedback = sourceAsset.getRatings() != null && sourceAsset.getRatings().getFeedback() != null ? sourceAsset.getRatings().getFeedback() : new AssetFeedback[]{};
                targetAsset.getRatings().setFeedback(feedback);
                if (monitor.isCanceled()) {
                    return;
                }
            }
            monitor.worked(5);
            if (co.isSet(512L)) {
                targetAsset.setDescription(sourceAsset.getDescription());
            }
            if (co.isSet(1024L)) {
                targetAsset.setShortDescription(sourceAsset.getShortDescription());
            }
            if (sourceAsset.getUsageTime() != null) {
                targetAsset.setUsageTime(sourceAsset.getUsageTime());
            }
            if (sourceAsset.getCreationTime() != null) {
                targetAsset.setCreationTime(sourceAsset.getCreationTime());
            }
            if (portTags && (sourceTags = sourceAsset.getTags()) != null && sourceTags.length > 0) {
                String message2 = MessageFormat.format(ClientMessages.getString("AssetUtil.PORT_ASSETS_TAGS"), sourceAsset);
                monitor.subTask(message2);
                int i = 0;
                while (i < sourceTags.length) {
                    RAMAssetTag[] tags = targetAsset.addTags(sourceTags[i].getTag());
                    if (sourceTags[i].getOwner() != null && !targetSession.getUser().getUid().equals(sourceTags[i].getOwner().getUid())) {
                        int j = 0;
                        while (j < tags.length) {
                            tags[j].setOwner(sourceTags[i].getOwner());
                            ++j;
                        }
                    }
                    ++i;
                }
            }
            if (monitor.isCanceled()) {
                return;
            }
            monitor.worked(10);
            monitor.done();
        }
    }

    public static void portAssetInfo(RAMAsset targetAsset, Asset sourceAsset, RAMMappings mappings, boolean portForums, boolean portTags, boolean portFeedback, boolean logErrors, IProgressMonitor monitor) throws RAMRuntimeException {
        String message = MessageFormat.format(ClientMessages.getString("AssetUtil.PORT_ASSET_INFO"), sourceAsset.getName());
        monitor.beginTask(message, 100);
        RAMSession targetSession = targetAsset.getSession();
        if (!monitor.isCanceled()) {
            AssetTag[] sourceTags;
            Forum[] sourceForums;
            UserInformation[] targetOwners;
            if (monitor.isCanceled()) {
                return;
            }
            monitor.worked(20);
            if (sourceAsset.getCommunityName() != null) {
                String mappedName;
                String communityName = sourceAsset.getCommunityName();
                if (mappings.getCommunityNameMappings().containsKey(communityName) && (mappedName = (String)mappings.getCommunityNameMappings().get(communityName)) != null) {
                    communityName = mappedName;
                }
                if (!mappings.isInvalidCommunity(communityName)) {
                    RAMCommunity community = targetSession.getCommunity(communityName);
                    if (community != null) {
                        targetAsset.setCommunityName(communityName);
                    } else {
                        mappings.setCommunityIsInvalid(communityName, true);
                    }
                }
                if (!mappings.isInvalidCommunity(communityName)) {
                    targetAsset.setCommunityName(communityName);
                }
            } else {
                targetAsset.setCommunityName(null);
            }
            if (monitor.isCanceled()) {
                return;
            }
            monitor.worked(10);
            if (sourceAsset.getAssetType() != null) {
                String mappedName;
                String uri = sourceAsset.getAssetType().getURI();
                boolean done = false;
                if (uri != null) {
                    RAMAssetType assetType = targetSession.getAssetTypeByURI(uri);
                    if (assetType != null) {
                        targetAsset.setAssetType(assetType);
                        done = true;
                    } else if (mappings.getAssetTypeNameMappings().containsKey(uri) && (mappedName = (String)mappings.getAssetTypeNameMappings().get(uri)) != null) {
                        targetAsset.setTypeName(mappedName);
                        done = true;
                    }
                }
                if (!done) {
                    String assetTypeName = sourceAsset.getAssetType().getName();
                    if (mappings.getAssetTypeNameMappings().containsKey(assetTypeName) && (mappedName = (String)mappings.getAssetTypeNameMappings().get(assetTypeName)) != null) {
                        assetTypeName = mappedName;
                    }
                    if (!mappings.isInvalidAssetType(assetTypeName)) {
                        RAMAssetType type = targetSession.getAssetType(assetTypeName);
                        if (type != null) {
                            targetAsset.setTypeName(assetTypeName);
                        } else {
                            mappings.setAssetTypeIsInvalid(assetTypeName, true);
                            targetAsset.setAssetType(null);
                        }
                    }
                }
            } else {
                targetAsset.setAssetType(null);
            }
            if (monitor.isCanceled()) {
                return;
            }
            monitor.worked(10);
            AssetUtil.portAssetCategories(sourceAsset, mappings, targetAsset, logErrors);
            if (monitor.isCanceled()) {
                return;
            }
            monitor.worked(15);
            AssetUtil.portAssetAttributes(sourceAsset, mappings, targetAsset, logErrors);
            if (monitor.isCanceled()) {
                return;
            }
            monitor.worked(15);
            UserInformation[] sourceOwners = sourceAsset.getOwners();
            if (sourceOwners != null) {
                targetOwners = new RAMUser[sourceOwners.length];
                int i = 0;
                while (i < sourceOwners.length) {
                    try {
                        RAMUser targetUser;
                        String mappedId;
                        String ownerId = sourceOwners[i].getUid();
                        if (mappings.getUserIdMappings().containsKey(ownerId) && (mappedId = (String)mappings.getUserIdMappings().get(ownerId)) != null) {
                            ownerId = mappedId;
                        }
                        if ((targetUser = targetAsset.getSession().getUser(ownerId)) == null) {
                            String message2 = MessageFormat.format(ClientMessages.getString("AssetUtil.USER_NOT_FOUND"), sourceOwners[i]);
                            logger.warn((Object)message2);
                            targetOwners[i] = targetAsset.getSession().getUser();
                        } else {
                            targetOwners[i] = targetUser;
                        }
                    }
                    catch (Exception e) {
                        logger.warn((Object)e.getLocalizedMessage(), (Throwable)e);
                    }
                    ++i;
                }
                targetAsset.setOwners(targetOwners);
            } else {
                targetOwners = new RAMUser[]{targetAsset.getSession().getUser()};
                targetAsset.setOwners(targetOwners);
            }
            if (monitor.isCanceled()) {
                return;
            }
            monitor.worked(10);
            if (portForums && (sourceForums = sourceAsset.getForums()) != null) {
                int i = 0;
                while (i < sourceForums.length) {
                    boolean exists = false;
                    Forum[] targetForums = targetAsset.getForums();
                    int j = 0;
                    while (j < targetForums.length) {
                        if (sourceForums[i].getTitle().equals(targetForums[j].getTitle())) {
                            exists = true;
                            break;
                        }
                        ++j;
                    }
                    if (!exists) {
                        RAMUser targetUser;
                        String mappedId;
                        Forum sourceForum = sourceForums[i];
                        RAMForum newForum = targetAsset.createForum(sourceForum.getTitle(), sourceForum.getDescription());
                        newForum.setSubmissionDate(sourceForum.getSubmissionDate());
                        String submitterid = sourceForum.getSubmitter().getUid();
                        if (mappings.getUserIdMappings().containsKey(submitterid) && (mappedId = (String)mappings.getUserIdMappings().get(submitterid)) != null) {
                            submitterid = mappedId;
                        }
                        if ((targetUser = targetAsset.getSession().getUser(submitterid)) == null) {
                            String message2 = MessageFormat.format(ClientMessages.getString("AssetUtil.USER_NOT_FOUND"), sourceOwners[i]);
                            logger.warn((Object)message2);
                            newForum.setSubmitter(targetAsset.getSession().getUser());
                        } else {
                            newForum.setSubmitter(targetUser);
                        }
                        Topic[] sourceTopics = sourceForum.getTopics();
                        int j2 = 0;
                        while (j2 < sourceTopics.length) {
                            String mappedId2;
                            Topic sourceTopic = sourceTopics[j2];
                            RAMTopic newTopic = newForum.createTopic(sourceTopic.getTitle(), sourceTopic.getDescription());
                            newTopic.setSubmissionDate(sourceTopic.getSubmissionDate());
                            submitterid = sourceTopic.getSubmitter().getUid();
                            if (mappings.getUserIdMappings().containsKey(submitterid) && (mappedId2 = (String)mappings.getUserIdMappings().get(submitterid)) != null) {
                                submitterid = mappedId2;
                            }
                            if ((targetUser = targetAsset.getSession().getUser(submitterid)) == null) {
                                String message2 = MessageFormat.format(ClientMessages.getString("AssetUtil.USER_NOT_FOUND"), sourceOwners[i]);
                                logger.warn((Object)message2);
                                newTopic.setSubmitter(targetAsset.getSession().getUser());
                            } else {
                                newTopic.setSubmitter(targetUser);
                            }
                            Post[] sourcePosts = sourceTopic.getPosts();
                            int k = 0;
                            while (k < sourcePosts.length) {
                                String mappedId3;
                                Post sourcePost = sourcePosts[k];
                                RAMPost newPost = newTopic.createPost(sourcePost.getTitle(), sourcePost.getDescription());
                                newPost.setSubmissionDate(sourcePost.getSubmissionDate());
                                submitterid = sourcePost.getSubmitter().getUid();
                                if (mappings.getUserIdMappings().containsKey(submitterid) && (mappedId3 = (String)mappings.getUserIdMappings().get(submitterid)) != null) {
                                    submitterid = mappedId3;
                                }
                                if ((targetUser = targetAsset.getSession().getUser(submitterid)) == null) {
                                    String message2 = MessageFormat.format(ClientMessages.getString("AssetUtil.USER_NOT_FOUND"), sourceOwners[i]);
                                    logger.warn((Object)message2);
                                    newPost.setSubmitter(targetAsset.getSession().getUser());
                                } else {
                                    newPost.setSubmitter(targetUser);
                                }
                                ++k;
                            }
                            ++j2;
                        }
                    }
                    ++i;
                }
            }
            if (monitor.isCanceled()) {
                return;
            }
            monitor.worked(5);
            if (portFeedback) {
                AssetFeedback[] feedback = sourceAsset.getRatings() != null && sourceAsset.getRatings().getFeedback() != null ? sourceAsset.getRatings().getFeedback() : new AssetFeedback[]{};
                targetAsset.getRatings().setFeedback(feedback);
                if (monitor.isCanceled()) {
                    return;
                }
            }
            monitor.worked(5);
            targetAsset.setDescription(sourceAsset.getDescription());
            targetAsset.setShortDescription(sourceAsset.getShortDescription());
            if (sourceAsset.getUsageTime() != null) {
                targetAsset.setUsageTime(sourceAsset.getUsageTime());
            }
            if (sourceAsset.getCreationTime() != null) {
                targetAsset.setCreationTime(sourceAsset.getCreationTime());
            }
            if (portTags && (sourceTags = sourceAsset.getTags()) != null && sourceTags.length > 0) {
                String message2 = MessageFormat.format(ClientMessages.getString("AssetUtil.PORT_ASSETS_TAGS"), sourceAsset);
                monitor.subTask(message2);
                int i = 0;
                while (i < sourceTags.length) {
                    RAMAssetTag[] tags = targetAsset.addTags(sourceTags[i].getTag());
                    if (sourceTags[i].getOwner() != null && !targetSession.getUser().getUid().equals(sourceTags[i].getOwner().getUid())) {
                        int j = 0;
                        while (j < tags.length) {
                            tags[j].setOwner(sourceTags[i].getOwner());
                            ++j;
                        }
                    }
                    ++i;
                }
            }
            if (monitor.isCanceled()) {
                return;
            }
            monitor.worked(10);
            monitor.done();
        }
    }

    private static void findSetSubCategories(SubCategory[] children, List setList) {
        int i = 0;
        while (i < children.length) {
            SubCategory[] grandChildren;
            if (children[i].isSet()) {
                setList.add(children[i]);
            }
            if ((grandChildren = children[i].getSubCategories()) != null && grandChildren.length > 0) {
                AssetUtil.findSetSubCategories(grandChildren, setList);
            }
            ++i;
        }
    }

    private static String[] fetchVersions(RAMAsset asset, String versionPattern) throws RAMRuntimeException {
        RAMAssetQueryBuilder queryBuilder = new RAMAssetQueryBuilder(asset.getSession());
        queryBuilder.addQueryField(queryBuilder.QUERY_FIELD_GUID, SearchUtil.escapeDoubleQuto(SearchQuery.escapeLuceneCharacters(asset.getIdentification().getGUID())));
        String versionField = queryBuilder.createQueryFieldText(queryBuilder.QUERY_FIELD_VERSION, versionPattern);
        queryBuilder.addQueryTextField(versionField);
        queryBuilder.setSortByField(queryBuilder.SORT_BY_FIELD_VERSION);
        queryBuilder.setSortAscending(false);
        SearchResult result = asset.getSession().getAssets(queryBuilder);
        AssetSearchResult[] assets = result.getAssetSearchResults();
        String[] ret = new String[assets.length];
        int i = 0;
        while (i < assets.length) {
            ret[i] = ((RAMAsset)assets[i].getAsset()).getIdentification().getVersion();
            ++i;
        }
        if (assets != null && assets.length > 0) {
            Arrays.sort(ret, new Comparator(){

                public int compare(Object o1, Object o2) {
                    String v1 = (String)o1;
                    String v2 = (String)o2;
                    return Utilities.compareVersions(v2, v1);
                }
            });
        }
        return ret;
    }

    public static String createVersionSuggestion(RAMAsset asset, String versionPattern) {
        String GUID = asset.getIdentification().getGUID();
        if (versionPattern == null) {
            versionPattern = "*";
        }
        String version = null;
        if (GUID == null) {
            version = "1.0";
        } else {
            String[] versions = AssetUtil.fetchVersions(asset, versionPattern);
            if (versions.length == 0 || versions[0] == null || versions[0].length() == 0) {
                version = versionPattern.equals("*") ? "1.0" : versionPattern.replaceAll("\\*", "0");
            } else {
                version = versions[0];
                int length = version.length();
                int lastDotIndex = version.lastIndexOf(".");
                char curChar = version.charAt(length - 1);
                if (!Character.isDigit(curChar)) {
                    version = String.valueOf(version) + "1";
                } else if (lastDotIndex == -1) {
                    version = String.valueOf(version) + ".1";
                } else {
                    int pointer = length - 1;
                    int index = length - 1;
                    while (pointer > lastDotIndex) {
                        if (!Character.isDigit(curChar = version.charAt(--pointer))) break;
                        index = pointer;
                    }
                    String lastNumber = version.substring(index);
                    long number = Long.parseLong(lastNumber);
                    version = index == 0 ? Long.toString(number) : String.valueOf(version.substring(0, index)) + Long.toString(++number);
                }
            }
        }
        if (version != null) {
            version = version.trim();
        }
        return version;
    }

    public static void portAssetCategories(Asset sourceAsset, RAMMappings mappings, RAMAsset targetAsset, boolean logErrors) {
        RAMSession targetSession = targetAsset.getSession();
        CategorySchema[] schemas = sourceAsset.getCategorySchemas();
        if (schemas != null) {
            int i = 0;
            while (i < schemas.length) {
                Category[] categories = schemas[i].getCategories();
                int j = 0;
                while (j < categories.length) {
                    ArrayList categorizationsList = new ArrayList();
                    SubCategory[] children = categories[j].getSubCategories();
                    AssetUtil.findSetSubCategories(children, categorizationsList);
                    SubCategory[] categorizations = categorizationsList.toArray(new SubCategory[categorizationsList.size()]);
                    int k = 0;
                    while (k < categorizations.length) {
                        block11: {
                            try {
                                String mappedName;
                                SubCategory subCategory = categorizations[k];
                                String fullPath = subCategory.getFullPath();
                                if (mappings.getCategorizationMappings().containsKey(fullPath) && (mappedName = (String)mappings.getCategorizationMappings().get(fullPath)) != null) {
                                    fullPath = mappedName;
                                }
                                if (!mappings.isInvalidCategorization(fullPath)) {
                                    SubCategory targetSubCategory = AssetUtil.fetchSubCategory(targetSession, fullPath);
                                    if (targetSubCategory == null) {
                                        String message = MessageFormat.format(ClientMessages.getString("AssetUtil.CATEGORY_NOT_FOUND"), categorizations[k]);
                                        if (logErrors) {
                                            logger.error((Object)message);
                                        }
                                        mappings.setCategorizationIsInvalid(fullPath, true);
                                    } else {
                                        targetAsset.categorize(targetSubCategory);
                                    }
                                }
                            }
                            catch (Exception e) {
                                if (!logErrors) break block11;
                                logger.error((Object)e.getLocalizedMessage(), (Throwable)e);
                            }
                        }
                        ++k;
                    }
                    ++j;
                }
                ++i;
            }
        }
    }

    public static void portAssetAttributes(Asset sourceAsset, RAMMappings mappings, RAMAsset targetAsset, boolean logError) {
        AssetAttribute[] attributes = sourceAsset.getAssetAttributes();
        if (attributes != null) {
            int i = 0;
            while (i < attributes.length) {
                block12: {
                    try {
                        String mappedName;
                        AssetAttribute attribute = attributes[i];
                        String attributeName = attribute.getName();
                        if (mappings.getAssetAttributeNameMappings().containsKey(attributeName) && (mappedName = (String)mappings.getAssetAttributeNameMappings().get(attributeName)) != null) {
                            attributeName = mappedName;
                        }
                        if (!mappings.isInvalidAssetAttribute(attributeName)) {
                            AssetAttribute targetAttribute = targetAsset.getAssetAttribute(attributeName);
                            if (targetAttribute == null) {
                                String message = MessageFormat.format(ClientMessages.getString("AssetUtil.ATTRIBUTE_NOT_FOUND"), attributeName);
                                if (logError) {
                                    logger.error((Object)message);
                                }
                                mappings.setAssetAttributeIsInvalid(attributeName, true);
                            } else {
                                String[] values = attribute.getValues();
                                if (values != null) {
                                    int j = 0;
                                    while (j < values.length) {
                                        String key = AssetUtil.createAssetAttributeValueKey(attribute.getName(), values[j]);
                                        if (mappings.getAssetAttributeValueMappings().containsKey(key)) {
                                            values[j] = (String)mappings.getAssetAttributeValueMappings().get(key);
                                        }
                                        ++j;
                                    }
                                    ((RAMAssetAttribute)targetAttribute).setValues(values);
                                }
                            }
                        }
                    }
                    catch (Exception e) {
                        if (!logError) break block12;
                        logger.error((Object)e.getLocalizedMessage(), (Throwable)e);
                    }
                }
                ++i;
            }
        }
    }

    public static String createAssetAttributeValueKey(String sourceAttributeName, String sourceAttributeValue) {
        return String.valueOf(sourceAttributeName) + "=" + sourceAttributeValue;
    }

    public static void portAssetRelationships(RAMAsset targetAsset, Asset sourceAsset, RAMMappings mappings, IProgressMonitor monitor, boolean logError) throws RAMRuntimeException {
        RAMSession targetSession = targetAsset.getSession();
        if (!monitor.isCanceled()) {
            Relationship[] relationships = sourceAsset.getRelationships();
            if (relationships != null && relationships.length > 0) {
                monitor.beginTask("", relationships.length * 100);
                int i = 0;
                while (!monitor.isCanceled() && i < relationships.length) {
                    block17: {
                        String version;
                        String GUID;
                        if (mappings.isFollowRelatedAssets() && relationships[i] instanceof RAMRelationship) {
                            try {
                                ((RAMRelationship)relationships[i]).getChildAsset();
                            }
                            catch (RAMRuntimeException e) {
                                String message = MessageFormat.format(ClientMessages.getString("AssetUtil.COULD_NOT_FETCH_RELAEDTED_ASSET"), relationships[i].getChildAssetGUID(), relationships[i].getChildAssetVersion(), sourceAsset);
                                logger.warn((Object)message, (Throwable)e);
                            }
                        }
                        if (!mappings.isInvalidAsset(GUID = relationships[i].getChildAssetGUID(), version = relationships[i].getChildAssetVersion())) {
                            String message;
                            String mappedName;
                            String relationTypeName = relationships[i].getRelationshipTypeName();
                            if (mappings.getRelationshipTypeNameMappings().containsKey(relationTypeName) && (mappedName = (String)mappings.getRelationshipTypeNameMappings().get(relationTypeName)) != null) {
                                relationTypeName = mappedName;
                            }
                            try {
                                String message2;
                                RAMRelationshipType type = targetSession.getRelationshipType(relationTypeName);
                                if (logError && type == null) {
                                    message = MessageFormat.format(ClientMessages.getString("AssetUtil.FIND_RELATIONSHIP_TYPE"), relationTypeName);
                                    logger.warn((Object)message);
                                    break block17;
                                }
                                try {
                                    RAMAsset relatedAsset = targetSession.getAsset(GUID, version);
                                    if (relatedAsset != null) {
                                        targetAsset.addRelatedAsset(relatedAsset, type);
                                        break block17;
                                    }
                                    if (logError && relationships[i] != null) {
                                        message2 = MessageFormat.format(ClientMessages.getString("AssetUtil.COULD_NOT_FETCH_RELAEDTED_ASSET"), GUID, version, sourceAsset);
                                        logger.warn((Object)message2);
                                    }
                                    mappings.setAssetIsInvalid(GUID, version, true);
                                }
                                catch (Exception e) {
                                    if (logError && relationships[i] != null) {
                                        message2 = MessageFormat.format(ClientMessages.getString("AssetUtil.COULD_NOT_FETCH_RELAEDTED_ASSET"), GUID, version, sourceAsset);
                                        logger.warn((Object)message2, (Throwable)e);
                                    }
                                    mappings.setAssetIsInvalid(GUID, version, true);
                                }
                            }
                            catch (Exception e) {
                                if (!logError || relationships[i] == null) break block17;
                                message = MessageFormat.format(ClientMessages.getString("AssetUtil.COULD_NOT_FETCH_RELATIONSHIP_TYPE"), relationTypeName);
                                logger.warn((Object)message, (Throwable)e);
                            }
                        }
                    }
                    monitor.worked(100);
                    ++i;
                }
            } else {
                monitor.beginTask("", 10);
                monitor.worked(10);
            }
        }
        monitor.done();
    }

    public static void removeIth(Object[] source, Object[] target, int i) {
        if (i > 0) {
            System.arraycopy(source, 0, target, 0, i);
        }
        if (i < source.length - 1) {
            System.arraycopy(source, i + 1, target, i, source.length - i - 1);
        }
    }
}

