/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ram.internal.client.util;

import com.ibm.ram.client.ArtifactValidationError;
import com.ibm.ram.client.LocalFileArtifact;
import com.ibm.ram.client.LocalFolderArtifact;
import com.ibm.ram.client.RAMArtifact;
import com.ibm.ram.client.RAMAsset;
import com.ibm.ram.client.RAMAssetAttribute;
import com.ibm.ram.client.RAMAssetType;
import com.ibm.ram.client.RAMCategorySchema;
import com.ibm.ram.client.RAMCommunity;
import com.ibm.ram.client.RAMFolderArtifact;
import com.ibm.ram.client.RAMRelationshipType;
import com.ibm.ram.client.RAMSession;
import com.ibm.ram.common.data.Artifact;
import com.ibm.ram.common.data.CommunityAssetType;
import com.ibm.ram.common.data.CommunityInformation;
import com.ibm.ram.common.data.FolderArtifact;
import com.ibm.ram.common.data.RelationshipType;
import com.ibm.ram.common.data.exception.RAMRuntimeException;
import com.ibm.ram.common.emf.AssetTypeConfiguration;
import com.ibm.ram.common.emf.Attribute;
import com.ibm.ram.common.emf.EMFFactory;
import com.ibm.ram.common.emf.EMFPackage;
import com.ibm.ram.common.util.ArtifactAccessor;
import com.ibm.ram.common.util.AttributeConstants;
import com.ibm.ram.common.util.FieldValidationError;
import com.ibm.ram.common.util.UtilitiesCommon;
import com.ibm.ram.common.util.ValidationManager;
import com.ibm.ram.defaultprofile.DefaultprofilePackage;
import com.ibm.ram.internal.client.AbstractRAMClient;
import com.ibm.ram.internal.client.bundles.ClientMessages;
import com.ibm.ram.internal.client.util.ClientArtifactAccessor;
import com.ibm.ram.internal.client.util.SessionManager;
import com.ibm.ram.internal.common.data.GroupPermissionSO;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;

public class ClientValidationManager
extends ValidationManager {
    private static final Logger logger = Logger.getLogger((String)ClientValidationManager.class.getName());
    public static String ARTIFACT_ERRORS = "artifact_errors";
    private RAMSession fSession;
    private AbstractRAMClient fClient;
    private RAMAssetType fAssetType;
    private List fAssetTypeGroupings;
    private ResourceSet fResourceSet;
    protected List<URI> allCategoryURIs;
    private Map<Integer, GroupPermissionSO> communityPermissionsMap = new HashMap<Integer, GroupPermissionSO>();
    private final RAMAsset ramAsset;
    private List<RAMCommunity> validSubmitCommunities;
    private boolean validSubmitCommunitiesSet;

    static {
        DefaultprofilePackage.eINSTANCE.getActivity();
        EMFPackage.eINSTANCE.getArtifactConstraint();
    }

    public ClientValidationManager(RAMAsset ramAsset, RAMSession session, AbstractRAMClient client, ResourceSet rSet) {
        this.ramAsset = ramAsset;
        this.fClient = client;
        this.fSession = session;
        this.fResourceSet = rSet;
    }

    protected Collection getAllCategoryURIs() {
        if (this.allCategoryURIs == null) {
            if (this.getCommunity() != null) {
                RAMCategorySchema[] schemas = this.fSession.getAllCategorySchemas();
                this.allCategoryURIs = new ArrayList<URI>();
                int i = 0;
                while (i < schemas.length) {
                    boolean add;
                    boolean bl = add = !schemas[i].isRestricted();
                    if (schemas[i].isRestricted()) {
                        RAMCommunity[] restrictedComs = schemas[i].getRestrictedCommunities();
                        int j = 0;
                        while (j < restrictedComs.length) {
                            if (restrictedComs[j].getId() == this.getCommunity().getId()) {
                                add = true;
                            }
                            ++j;
                        }
                    }
                    if (add) {
                        String classificationSchemaURI = schemas[i].getURI().concat("#/");
                        this.allCategoryURIs.add(URI.createURI((String)classificationSchemaURI));
                    }
                    ++i;
                }
            } else {
                this.allCategoryURIs = Collections.emptyList();
            }
        }
        return this.allCategoryURIs;
    }

    public void refreshAssetType() {
        this.unsetAssetType();
    }

    @Override
    protected String getAssetTypeName(String assetTypeURI) {
        RAMAssetType assetType = this.fSession.getAssetTypeByURI(assetTypeURI);
        if (assetType == null) {
            return "";
        }
        return assetType.getName() == null ? "" : assetType.getName();
    }

    @Override
    protected String getAssetTypeURIString(String assetId, String assetVersion) {
        try {
            RAMAsset clientAsset = this.fSession.getAsset(assetId, assetVersion);
            return clientAsset.getAssetType().getURI();
        }
        catch (Exception ieee) {
            ieee.printStackTrace();
            return null;
        }
    }

    @Override
    protected String getRelationshipDisplayName(String name) {
        try {
            RAMRelationshipType[] assetRelationshipTypes = this.fSession.getAllRelationshipTypes();
            int i = 0;
            while (i < assetRelationshipTypes.length) {
                RAMRelationshipType assetRelationType = assetRelationshipTypes[i];
                if (((RelationshipType)assetRelationType).getName().equals(name)) {
                    return ((RelationshipType)assetRelationType).getDisplayName();
                }
                ++i;
            }
        }
        catch (Exception ieee) {
            ieee.printStackTrace();
        }
        return null;
    }

    public static boolean isValidAssetName(String name) {
        return name != null && name.length() > 0;
    }

    public static boolean isValidShortDescription(String description) {
        return description != null && description.length() > 0;
    }

    @Override
    protected ArtifactAccessor getArtifactAccessor() {
        return new ClientArtifactAccessor(this.ramAsset);
    }

    protected List getAssetTypeGroupings() {
        if (this.fAssetType == null) {
            return new ArrayList();
        }
        if (this.fAssetTypeGroupings == null) {
            this.fAssetTypeGroupings = this.initAssetTypeGroupings();
        }
        return this.fAssetTypeGroupings;
    }

    private List initAssetTypeGroupings() throws RAMRuntimeException {
        AssetTypeConfiguration atconf;
        EList eList;
        Resource res;
        if (this.fAssetType == null) {
            return Collections.EMPTY_LIST;
        }
        String config = null;
        boolean isLocal = false;
        if (this.getCommunity() != null) {
            int communityId = this.getCommunity().getId();
            CommunityAssetType[] types = this.fAssetType.getCommunityAssetTypes();
            int i = 0;
            while (i < types.length) {
                CommunityAssetType communityAssetType = types[i];
                if (communityAssetType.getCommunity() != null && communityAssetType.getCommunity().getId() == communityId) {
                    config = communityAssetType.getConfiguration();
                    isLocal = communityAssetType.isLocal();
                    break;
                }
                ++i;
            }
        }
        if (!UtilitiesCommon.isEmptyString(config) && (res = this.createResource(URI.createURI((String)("config:/config/" + this.fAssetType.getId() + '/' + this.getCommunity().getId())), config, this.fResourceSet)) != null) {
            try {
                if (res.getContents().isEmpty() || !(res.getContents().get(0) instanceof AssetTypeConfiguration)) {
                    eList = res.getContents();
                    return eList;
                }
                atconf = (AssetTypeConfiguration)res.getContents().get(0);
                if (atconf.isSetConstraints()) {
                    eList = atconf.getConstraints();
                    return eList;
                }
            }
            finally {
                if (res != null && res.getResourceSet() != null) {
                    res.getResourceSet().getResources().remove((Object)res);
                }
                res = null;
            }
        }
        if (isLocal) {
            return Collections.EMPTY_LIST;
        }
        config = this.fAssetType.getConfiguration();
        if (UtilitiesCommon.isEmptyString(config)) {
            return Collections.EMPTY_LIST;
        }
        res = this.createResource(URI.createURI((String)("config:/config/" + this.fAssetType.getId())), config, this.fResourceSet);
        try {
            if (res.getContents().isEmpty() || !(res.getContents().get(0) instanceof AssetTypeConfiguration)) {
                eList = res.getContents();
                return eList;
            }
            atconf = (AssetTypeConfiguration)res.getContents().get(0);
            eList = atconf.getConstraints();
            return eList;
        }
        finally {
            if (res != null && res.getResourceSet() != null) {
                res.getResourceSet().getResources().remove((Object)res);
            }
        }
    }

    private Resource createResource(URI uri, String data, ResourceSet rset) {
        Resource res = rset.getResource(uri, false);
        if (res != null) {
            rset.getResources().remove((Object)res);
            res = null;
        }
        res = rset.createResource(uri);
        try {
            res.load((InputStream)new ByteArrayInputStream(data.getBytes("UTF-8")), null);
        }
        catch (Exception ieee) {
            logger.error((Object)ieee.getLocalizedMessage(), (Throwable)ieee);
            rset.getResources().remove((Object)res);
        }
        return res;
    }

    @Override
    protected FieldValidationError setAssetType(String assetTypeURI) {
        if (assetTypeURI != null) {
            this.fAssetType = this.fSession.getAssetTypeByURI(assetTypeURI);
            this.fAssetTypeGroupings = this.initAssetTypeGroupings();
            if (this.fAssetType != null && this.getCommunity() != null && this.fAssetType.isRestricted() && this.fAssetType.getCommunityAssetType(this.getCommunity()) == null) {
                return new FieldValidationError(1, MessageFormat.format(ClientMessages.getString("manifestvalidationerror.assettype.notvisible"), this.fAssetType.getName()), false);
            }
        }
        return null;
    }

    @Override
    protected FieldValidationError setCommunity(CommunityInformation community) {
        if (this.allCategoryURIs != null) {
            this.allCategoryURIs = null;
        }
        this.unsetAssetType();
        this.fAssetTypeGroupings = null;
        this.validSubmitCommunities = null;
        this.validSubmitCommunitiesSet = false;
        return null;
    }

    protected List getAttributes(String[] uris) {
        ArrayList<Attribute> ret = new ArrayList<Attribute>();
        int i = 0;
        while (i < uris.length) {
            try {
                RAMAssetAttribute attribute = this.fSession.getAssetAttributeByURI(uris[i]);
                if (attribute != null) {
                    Attribute emfAttribute = null;
                    emfAttribute = attribute.isRestrictedSetting() ? EMFFactory.eINSTANCE.createAttributeRestricted() : EMFFactory.eINSTANCE.createAttributeUnrestricted();
                    emfAttribute.setName(attribute.getName());
                    emfAttribute.setDescription(attribute.getDescription());
                    emfAttribute.setUriString(attribute.getURI());
                    emfAttribute.setConfiguration(attribute.getConfiguration());
                    if (attribute.getType() != null) {
                        emfAttribute.setAttributeType(AttributeConstants.Type.valueOf(attribute.getType()));
                    }
                    if (attribute != null) {
                        ret.add(emfAttribute);
                    }
                }
            }
            catch (Exception e) {
                logger.error((Object)e.getLocalizedMessage(), (Throwable)e);
            }
            ++i;
        }
        return ret;
    }

    public List<RAMCommunity> getValidSubmitCommunities() {
        if (!this.validSubmitCommunitiesSet) {
            this.validSubmitCommunities = Arrays.asList(this.fSession.getCommunitiesUserCanSubmitTo());
            this.validSubmitCommunitiesSet = true;
        }
        return this.validSubmitCommunities;
    }

    @Override
    public List<String> getValidAssetTypesForCreate() {
        RAMAssetType[] submitTypesInCommunity;
        CommunityInformation community = this.getCommunity();
        if (community != null && (submitTypesInCommunity = this.getSubmitTypesInCommunity(community)) != null) {
            ArrayList<String> uris = new ArrayList<String>();
            int ac = 0;
            while (ac < submitTypesInCommunity.length) {
                uris.add(submitTypesInCommunity[ac].getURI());
                ++ac;
            }
            return uris;
        }
        return null;
    }

    protected RAMAssetType[] getSubmitTypesInCommunity(CommunityInformation community) {
        if (community != null) {
            GroupPermissionSO communityPermissions = null;
            if (this.communityPermissionsMap.containsKey(community.getId())) {
                communityPermissions = this.communityPermissionsMap.get(community.getId());
            } else {
                try {
                    GroupPermissionSO[] groupPermission = SessionManager.getSessionManager().getCommunityPermissions(this.fClient, new int[]{community.getId()});
                    if (groupPermission != null && groupPermission.length > 0) {
                        communityPermissions = groupPermission[0];
                    }
                    if (communityPermissions != null) {
                        this.communityPermissionsMap.put(community.getId(), communityPermissions);
                    }
                }
                catch (Exception e) {
                    throw new RAMRuntimeException(e.getMessage(), e);
                }
            }
            if (communityPermissions != null) {
                if (!communityPermissions.isCreateAssetAllowed()) {
                    return new RAMAssetType[0];
                }
                String[] typesForCreate = communityPermissions.getTypesForCreate();
                if (typesForCreate != null) {
                    ArrayList<RAMAssetType> cTypes = new ArrayList<RAMAssetType>();
                    String[] stringArray = typesForCreate;
                    int n = typesForCreate.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String string = stringArray[n2];
                        RAMAssetType assetType = this.fSession.getAssetTypeByURI(string);
                        if (assetType != null) {
                            cTypes.add(assetType);
                        }
                        ++n2;
                    }
                    if (cTypes.size() > 0) {
                        return cTypes.toArray(new RAMAssetType[cTypes.size()]);
                    }
                }
            }
        }
        return null;
    }

    @Override
    protected void doValidate(boolean blockerOnly, Map<String, Object> errors, ValidationManager.ValidateErrorFlags errorFlags) {
        if (blockerOnly) {
            return;
        }
        ArtifactValidationError[] validateArtifacts = this.validateArtifactExistence();
        errorFlags.markError(validateArtifacts.length > 0);
        errors.put(ARTIFACT_ERRORS, validateArtifacts);
    }

    protected ArtifactValidationError[] validateArtifactExistence() {
        ArrayList<ArtifactValidationError> artifactExistenceErrors = new ArrayList<ArtifactValidationError>();
        if (this.ramAsset != null) {
            FolderArtifact artifactsRoot = this.ramAsset.getArtifactsRoot();
            Stack<Artifact> artifactsStack = new Stack<Artifact>();
            artifactsStack.addAll(Arrays.asList(artifactsRoot.getChildren()));
            while (!artifactsStack.isEmpty()) {
                File file;
                ArtifactValidationError error;
                Artifact lfa;
                File folder;
                Artifact pop = (Artifact)artifactsStack.pop();
                if (pop instanceof LocalFolderArtifact && ((folder = ((LocalFolderArtifact)(lfa = (LocalFolderArtifact)pop)).getFolder()) == null || !folder.exists())) {
                    error = new ArtifactValidationError(lfa, MessageFormat.format(ClientMessages.getString("RichClientValidationManager_UnableToFindResource"), ((RAMFolderArtifact)lfa).getName()));
                    artifactExistenceErrors.add(error);
                }
                if (pop instanceof LocalFileArtifact && ((file = ((LocalFileArtifact)(lfa = (LocalFileArtifact)pop)).getFile()) == null || !file.exists())) {
                    error = new ArtifactValidationError(lfa, MessageFormat.format(ClientMessages.getString("RichClientValidationManager_UnableToFindResource"), ((RAMArtifact)lfa).getName()));
                    artifactExistenceErrors.add(error);
                }
                if (!(pop instanceof FolderArtifact)) continue;
                FolderArtifact fa = (FolderArtifact)pop;
                artifactsStack.addAll(Arrays.asList(fa.getChildren()));
            }
        }
        return artifactExistenceErrors.toArray(new ArtifactValidationError[artifactExistenceErrors.size()]);
    }
}

