/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ram.internal.jaxb;

import com.ibm.ram.common.data.exception.RAMRuntimeException;
import com.ibm.ram.internal.jaxb.ArtifactReference;
import com.ibm.ram.internal.jaxb.ArtifactType;
import com.ibm.ram.internal.jaxb.util.JAXBLinksUtil;
import com.ibm.ram.internal.jaxb.util.JAXButil;
import java.net.URL;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.CollapsedStringAdapter;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import javax.xml.datatype.XMLGregorianCalendar;
import org.oslc.asset.internal.ResourceRef;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="Artifact", namespace="http://jazz.net/xmlns/ecalm/ram/internal/v7.2")
public class Artifact {
    @XmlElement(required=true)
    protected String name;
    @XmlElement(required=true)
    protected String description;
    @XmlElement(required=true)
    protected String path;
    @XmlElement(required=true)
    protected String label;
    protected String content;
    @XmlElement(required=true)
    protected String mimeType;
    @XmlElement(required=true)
    protected XMLGregorianCalendar lastModified;
    protected ArtifactReference reference;
    @XmlAttribute
    protected Long size;
    @XmlAttribute
    protected Long checksum;
    @XmlAttribute
    protected ArtifactType type;
    @XmlAttribute
    protected String etag;
    @XmlAttribute
    protected String href;
    @XmlAttribute(namespace="http://www.w3.org/XML/1998/namespace")
    protected String base;
    @XmlAttribute(namespace="http://www.w3.org/XML/1998/namespace")
    @XmlJavaTypeAdapter(value=CollapsedStringAdapter.class)
    protected String lang;
    @XmlAttribute(namespace="http://www.w3.org/XML/1998/namespace")
    @XmlJavaTypeAdapter(value=CollapsedStringAdapter.class)
    protected String space;

    public Artifact() {
    }

    public Artifact(org.oslc.asset.internal.Artifact oslcArtifact) {
        this.setBase(oslcArtifact.getBase());
        this.setEtag(oslcArtifact.getEtag());
        this.setMimeType(oslcArtifact.getMimeType());
        this.setLastModified(JAXButil.getXMLCalendar(oslcArtifact.getModified()));
        this.setSize(oslcArtifact.getSize());
        this.setLabel(oslcArtifact.getSubject());
        String href = JAXBLinksUtil.getInternalArtifactURL(oslcArtifact.getAbout());
        this.setHref(href);
        this.setName(JAXBLinksUtil.getArtifactName(href));
        this.setPath(JAXBLinksUtil.getArtifactPath(href));
        if (oslcArtifact.getContent() != null && oslcArtifact.getContent().getResource() != null && this.isRemote(oslcArtifact.getContent().getResource())) {
            this.setType(ArtifactType.URL);
            ArtifactReference ref = new ArtifactReference();
            this.setReference(ref);
            ref.setKind("url");
            ref.setValue(oslcArtifact.getContent().getResource());
        } else if (oslcArtifact.getReference() != null) {
            this.setReference(oslcArtifact.getReference());
        }
    }

    private boolean isRemote(String url) {
        boolean ret = false;
        try {
            URL test = new URL(url);
            ret = test.getHost() != null;
        }
        catch (Exception exception) {}
        return ret;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String value) {
        this.name = value;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String value) {
        this.description = value;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String value) {
        this.path = value;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String value) {
        this.label = value;
    }

    public String getContent() {
        return this.content;
    }

    public void setContent(String value) {
        this.content = value;
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public void setMimeType(String value) {
        this.mimeType = value;
    }

    public XMLGregorianCalendar getLastModified() {
        return this.lastModified;
    }

    public void setLastModified(XMLGregorianCalendar value) {
        this.lastModified = value;
    }

    public ArtifactReference getReference() {
        return this.reference;
    }

    public void setReference(ArtifactReference value) {
        this.reference = value;
    }

    public Long getSize() {
        return this.size;
    }

    public void setSize(Long value) {
        this.size = value;
    }

    public Long getChecksum() {
        return this.checksum;
    }

    public void setChecksum(Long value) {
        this.checksum = value;
    }

    public ArtifactType getType() {
        return this.type;
    }

    public void setType(ArtifactType value) {
        this.type = value;
    }

    public String getEtag() {
        return this.etag;
    }

    public void setEtag(String value) {
        this.etag = value;
    }

    public String getHref() {
        return this.href;
    }

    public void setHref(String value) {
        this.href = value;
    }

    public String getBase() {
        return this.base;
    }

    public void setBase(String value) {
        this.base = value;
    }

    public String getLang() {
        return this.lang;
    }

    public void setLang(String value) {
        this.lang = value;
    }

    public String getSpace() {
        if (this.space == null) {
            return "preserve";
        }
        return this.space;
    }

    public void setSpace(String value) {
        this.space = value;
    }

    public String toString() {
        return this.name == null ? this.href : String.valueOf(this.name) + "[" + this.href + "]";
    }

    public org.oslc.asset.internal.Artifact toOSLCArtifact() {
        if (this.getName() == null) {
            throw new RAMRuntimeException("Could not copy the artifact pojo : name is null");
        }
        org.oslc.asset.internal.Artifact to = new org.oslc.asset.internal.Artifact();
        to.setBase(this.getBase());
        to.setEtag(this.getEtag());
        if (this.getMimeType() != null) {
            to.setMimeType(this.getMimeType());
        }
        if (this.getLastModified() != null) {
            to.setModified(JAXButil.getDate(this.getLastModified()));
        }
        if (this.getSize() != null) {
            to.setSize(this.getSize());
        }
        if (this.getLabel() != null) {
            to.setSubject(this.getLabel());
        }
        to.setTitle(JAXBLinksUtil.getArtifactLinkTitle(this));
        String href = JAXBLinksUtil.getOSLCArtifactURL(this.getHref());
        to.setAbout(href);
        ResourceRef content = new ResourceRef();
        if (ArtifactType.URL == this.type && this.reference != null) {
            String remoteRef = this.reference.getValue();
            content.setResource(remoteRef);
        } else {
            content.setResource(JAXBLinksUtil.getOSLCArtifactContentURL(this.getHref()));
        }
        to.setContent(content);
        if (this.getReference() != null) {
            to.setReference(this.getReference());
        }
        return to;
    }
}

