/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ram.internal.scm.clearcase.commands;

import com.ibm.ram.internal.scm.clearcase.RegistryInformation;
import com.ibm.ram.internal.scm.clearcase.commands.AbstractCleartoolCommand;
import com.ibm.ram.internal.scm.clearcase.commands.CleartoolCommandConstants;
import com.ibm.ram.internal.scm.clearcase.commands.OutputCleartoolCommand;
import java.util.StringTokenizer;

public class GetRegistryInformationCommand
extends OutputCleartoolCommand {
    private static String KEY_REGISTRY_HOST = CleartoolCommandConstants.HOSTINFO_REGISTRY_HOST;
    private static String KEY_REGISTRY_REGION = CleartoolCommandConstants.HOSTINFO_REGISTRY_REGION;
    private String hostName = null;

    public GetRegistryInformationCommand() {
        this.hostName = null;
    }

    public GetRegistryInformationCommand(String hostName) {
        this.hostName = hostName;
    }

    @Override
    public String[] getArguments() {
        if (this.hostName != null) {
            return new String[]{"hostinfo", "-long", this.hostName};
        }
        return new String[]{"hostinfo", "-long"};
    }

    @Override
    protected AbstractCleartoolCommand.ICommandOutput parseOutput(final String output, String error) {
        return new RegistryInformationCommandOutput(){

            @Override
            public RegistryInformation getRegistryInformation() {
                RegistryInformation info = null;
                if (output != null && output.length() > 0) {
                    String registryHost = null;
                    String registryRegion = null;
                    StringTokenizer lines = new StringTokenizer(output, "\r\n");
                    while (lines.hasMoreTokens()) {
                        String line = lines.nextToken();
                        line = line.trim();
                        int hostIndex = line.indexOf(KEY_REGISTRY_HOST);
                        int regionIndex = line.indexOf(KEY_REGISTRY_REGION);
                        if (hostIndex > -1) {
                            registryHost = line.substring(hostIndex + KEY_REGISTRY_HOST.length()).trim();
                        }
                        if (regionIndex <= -1) continue;
                        registryRegion = line.substring(hostIndex + KEY_REGISTRY_REGION.length()).trim();
                    }
                    if (registryHost != null || registryRegion != null) {
                        info = new RegistryInformation();
                        info.setRegistryHost(registryHost);
                        info.setRegistryRegion(registryRegion);
                    }
                }
                return info;
            }
        };
    }

    public static interface RegistryInformationCommandOutput
    extends AbstractCleartoolCommand.ICommandOutput {
        public RegistryInformation getRegistryInformation();
    }
}

