/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ram.internal.scm.clearcase.commands;

import com.ibm.ram.internal.scm.clearcase.commands.AbstractCleartoolCommand;
import com.ibm.ram.internal.scm.clearcase.commands.OutputCleartoolCommand;
import java.io.File;
import java.util.ArrayList;
import java.util.StringTokenizer;

public class ListVersionTreeCommand
extends OutputCleartoolCommand {
    private File viewFile = null;

    public ListVersionTreeCommand(File viewFile) {
        this.viewFile = viewFile;
    }

    @Override
    public String[] getArguments() {
        return new String[]{"lsvtree", "-all", this.viewFile.getAbsolutePath()};
    }

    @Override
    protected AbstractCleartoolCommand.ICommandOutput parseOutput(String output, String error) {
        final ArrayList<String> branchesList = new ArrayList<String>();
        final ArrayList<1> versionsList = new ArrayList<1>();
        if (output != null && output.length() > 0) {
            StringTokenizer lineTokenizer = new StringTokenizer(output, "\r\n", false);
            while (lineTokenizer.hasMoreTokens()) {
                String versionString;
                String replacedVersion;
                int lastSeparator;
                String line = lineTokenizer.nextToken().trim();
                int versionSeparatorIndex = line.lastIndexOf("@@");
                if (versionSeparatorIndex <= -1) continue;
                int versionEnd = line.indexOf(" ", versionSeparatorIndex);
                if (versionEnd < 0) {
                    versionEnd = line.length();
                }
                if (versionEnd <= versionSeparatorIndex || (lastSeparator = (replacedVersion = (versionString = line.substring(versionSeparatorIndex + "@@".length(), versionEnd).trim()).replace('\\', '/')).lastIndexOf(47)) <= -1) continue;
                String lastSegment = replacedVersion.substring(lastSeparator + 1).trim();
                int versionNumber = -1;
                try {
                    versionNumber = Integer.parseInt(lastSegment);
                }
                catch (NumberFormatException numberFormatException) {}
                if (versionNumber < 0) {
                    branchesList.add(replacedVersion);
                    continue;
                }
                final ArrayList<String> labelsList = new ArrayList<String>();
                if (line.length() > versionEnd) {
                    String remainingLine = line.substring(versionEnd).trim();
                    StringTokenizer labelSeparatorTokenizer = new StringTokenizer(remainingLine, "() ,", false);
                    while (labelSeparatorTokenizer.hasMoreTokens()) {
                        String label = labelSeparatorTokenizer.nextToken();
                        labelsList.add(label);
                    }
                }
                ListVersionTreeOutput.Version ver = new ListVersionTreeOutput.Version(){

                    @Override
                    public String getVersion() {
                        return replacedVersion;
                    }

                    @Override
                    public String[] getLabels() {
                        return labelsList.toArray(new String[labelsList.size()]);
                    }
                };
                versionsList.add(ver);
            }
        }
        return new ListVersionTreeOutput(){

            @Override
            public String[] getBranches() {
                return branchesList.toArray(new String[branchesList.size()]);
            }

            @Override
            public ListVersionTreeOutput.Version[] getVersions() {
                return versionsList.toArray(new ListVersionTreeOutput.Version[versionsList.size()]);
            }
        };
    }

    public static interface ListVersionTreeOutput
    extends AbstractCleartoolCommand.ICommandOutput {
        public Version[] getVersions();

        public String[] getBranches();

        public static interface Version {
            public String getVersion();

            public String[] getLabels();
        }
    }
}

