/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ram.internal.scm.clearcase.commands;

import com.ibm.ram.internal.scm.clearcase.AbstractView;
import com.ibm.ram.internal.scm.clearcase.commands.AbstractCleartoolCommand;
import com.ibm.ram.internal.scm.clearcase.commands.CleartoolCommandConstants;
import com.ibm.ram.internal.scm.clearcase.commands.OutputCleartoolCommand;
import java.io.File;

public class SetConfigSpecCommand
extends OutputCleartoolCommand {
    private AbstractView view = null;
    private File configSpecFile = null;
    private File viewLocation = null;

    public SetConfigSpecCommand(AbstractView view, File configSpecFile, File viewLocation) {
        this.configSpecFile = configSpecFile;
        this.view = view;
        this.viewLocation = viewLocation;
    }

    @Override
    protected File getFolderToRunIn() {
        return this.viewLocation;
    }

    @Override
    protected String[] getArguments() {
        return new String[]{"setcs", "-tag", this.view.getTag(), this.configSpecFile.getAbsolutePath()};
    }

    @Override
    protected AbstractCleartoolCommand.ICommandOutput parseOutput(String output, final String error) {
        return new SetConfigSpecCommandOutput(){

            @Override
            public boolean isSet() {
                boolean set = true;
                if (error != null && error.indexOf(CleartoolCommandConstants.ERROR) > -1) {
                    set = false;
                }
                return set;
            }
        };
    }

    public static interface SetConfigSpecCommandOutput
    extends AbstractCleartoolCommand.ICommandOutput {
        public boolean isSet();
    }
}

