/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ram.internal.scm.clearcase.commands.ucm;

import com.ibm.ram.internal.scm.clearcase.commands.AbstractCleartoolCommand;
import com.ibm.ram.internal.scm.clearcase.commands.CleartoolCommandConstants;
import com.ibm.ram.internal.scm.clearcase.commands.OutputCleartoolCommand;
import java.io.File;

public class DeliverCommand
extends OutputCleartoolCommand {
    private String integrationStream;
    private File viewLocation;

    public DeliverCommand(String integrationStream, File viewLocation) {
        this.integrationStream = integrationStream;
        this.viewLocation = viewLocation;
    }

    @Override
    protected AbstractCleartoolCommand.ICommandOutput parseOutput(String outputStream, String errorStream) {
        boolean completeDelivery = false;
        if (outputStream != null && outputStream.length() > 0) {
            String[] lines = outputStream.split("\r\n");
            int i = 0;
            while (i < lines.length) {
                if (lines[i].equals(CleartoolCommandConstants.DELIVER_COMPLETE)) {
                    completeDelivery = true;
                }
                ++i;
            }
        }
        final boolean isComplete = completeDelivery;
        return new DeliverCommandOutput(){

            @Override
            public boolean isComplete() {
                return isComplete;
            }
        };
    }

    @Override
    protected String[] getArguments() {
        if (this.integrationStream != null) {
            return new String[]{"deliver", "-f", "-to", this.integrationStream, "-complete"};
        }
        return new String[]{"deliver", "-f", "-complete"};
    }

    @Override
    protected File getFolderToRunIn() {
        return this.viewLocation;
    }

    public static interface DeliverCommandOutput
    extends AbstractCleartoolCommand.ICommandOutput {
        public boolean isComplete();
    }
}

