/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ram.internal.scm.clearcase.commands.ucm;

import com.ibm.ram.internal.scm.clearcase.commands.AbstractCleartoolCommand;
import com.ibm.ram.internal.scm.clearcase.commands.CleartoolCommandConstants;
import com.ibm.ram.internal.scm.clearcase.commands.OutputCleartoolCommand;
import java.io.File;
import java.util.ArrayList;

public class DiffBaseLineCommand
extends OutputCleartoolCommand {
    private static String KEY_DIFFERENCES = CleartoolCommandConstants.DIFFBL_DIFFERENCES;
    private static String KEY_NONE = CleartoolCommandConstants.DIFFBL_DIFFNONE;
    private static final String ONLYPRESENT_LEFT = "<<";
    private static final String ONLYPRESENT_RIGHT = ">>";
    private static final String PRESENT_NEWER_LEFT = "<-";
    private static final String PRESENT_NEWER_RIGHT = "->";
    private String selector1;
    private String selector2;
    private File viewRoot;
    private boolean showVersion = false;

    public DiffBaseLineCommand(File viewRoot, String selector1, String selector2) {
        this.selector1 = selector1;
        this.selector2 = selector2;
        this.viewRoot = viewRoot;
    }

    public DiffBaseLineCommand(File viewRoot, boolean showVersion, String selector1, String selector2) {
        this.selector1 = selector1;
        this.selector2 = selector2;
        this.viewRoot = viewRoot;
        this.showVersion = showVersion;
    }

    @Override
    protected AbstractCleartoolCommand.ICommandOutput parseOutput(String output, String error) {
        if (output != null && output.length() > 0) {
            String[] diffStrings = output.split("\r\n");
            final ArrayList<String> outputList = new ArrayList<String>();
            final ArrayList<String> leftOutputList = new ArrayList<String>();
            final ArrayList<String> rightOutputList = new ArrayList<String>();
            int pc = 0;
            while (pc < diffStrings.length) {
                String line = diffStrings[pc].trim();
                if (line.startsWith(KEY_DIFFERENCES)) {
                    ++pc;
                    boolean foundNone = false;
                    while (pc < diffStrings.length) {
                        String diffLine = diffStrings[pc];
                        outputList.add(diffLine);
                        if (diffLine.startsWith(KEY_NONE)) {
                            foundNone = true;
                            break;
                        }
                        if (diffLine.startsWith(ONLYPRESENT_LEFT)) {
                            leftOutputList.add(diffLine.substring(ONLYPRESENT_LEFT.length()));
                        } else if (diffLine.startsWith(PRESENT_NEWER_LEFT)) {
                            leftOutputList.add(diffLine.substring(PRESENT_NEWER_LEFT.length()));
                        } else if (diffLine.startsWith(ONLYPRESENT_RIGHT)) {
                            rightOutputList.add(diffLine.substring(ONLYPRESENT_RIGHT.length()));
                        } else if (diffLine.startsWith(PRESENT_NEWER_RIGHT)) {
                            rightOutputList.add(diffLine.substring(PRESENT_NEWER_RIGHT.length()));
                        }
                        ++pc;
                    }
                    final boolean foundNoneFinal = foundNone;
                    return new DiffBaseLineOutput(){

                        @Override
                        public String[] getOutput() {
                            return outputList.toArray(new String[outputList.size()]);
                        }

                        @Override
                        public boolean isIdentical() {
                            return foundNoneFinal;
                        }

                        @Override
                        public String[] getLeftOutput() {
                            return leftOutputList.toArray(new String[leftOutputList.size()]);
                        }

                        @Override
                        public String[] getRightOutput() {
                            return rightOutputList.toArray(new String[rightOutputList.size()]);
                        }
                    };
                }
                ++pc;
            }
        }
        return null;
    }

    @Override
    protected String[] getArguments() {
        if (this.showVersion) {
            return new String[]{"diffbl", "-version", this.selector1, this.selector2};
        }
        return new String[]{"diffbl", this.selector1, this.selector2};
    }

    @Override
    protected File getFolderToRunIn() {
        return this.viewRoot;
    }

    public static interface DiffBaseLineOutput
    extends AbstractCleartoolCommand.ICommandOutput {
        public boolean isIdentical();

        public String[] getLeftOutput();

        public String[] getRightOutput();

        public String[] getOutput();
    }
}

