/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ram.internal.scm.clearcase.commands.ucm;

import com.ibm.ram.internal.scm.clearcase.commands.AbstractCleartoolCommand;
import com.ibm.ram.internal.scm.clearcase.commands.OutputCleartoolCommand;
import java.io.File;
import java.util.ArrayList;

public class GetMergedVersions
extends OutputCleartoolCommand {
    private File viewFile;
    private String fromVersion;

    public GetMergedVersions(File viewFile, String fromVersion) {
        this.viewFile = viewFile;
        this.fromVersion = fromVersion;
    }

    @Override
    protected AbstractCleartoolCommand.ICommandOutput parseOutput(String outputStream, String errorStream) {
        ArrayList<String> mergedList = new ArrayList<String>();
        ArrayList<String> allVersionsList = new ArrayList<String>();
        if (outputStream != null && outputStream.length() > 0) {
            String[] lines = outputStream.split("\r\n");
            int i = 0;
            while (i < lines.length) {
                allVersionsList.add(lines[i]);
                if (lines[i].indexOf("->") != -1 && this.fromVersion != null && i - 1 > 0 && lines[i - 1].indexOf(this.fromVersion) != -1) {
                    mergedList.add(lines[i].substring(lines[i].indexOf("->") + 2).trim());
                }
                ++i;
            }
        }
        final String[] finalMerged = mergedList.toArray(new String[mergedList.size()]);
        final String[] allVersions = allVersionsList.toArray(new String[allVersionsList.size()]);
        return new GetMergedVersionsOutput(){

            @Override
            public String[] getMergedVersions() {
                return finalMerged;
            }

            @Override
            public String[] getAllVersions() {
                return allVersions;
            }
        };
    }

    @Override
    protected String[] getArguments() {
        return new String[]{"lsvtree", "-merge", this.viewFile.getAbsolutePath()};
    }

    public static interface GetMergedVersionsOutput
    extends AbstractCleartoolCommand.ICommandOutput {
        public String[] getMergedVersions();

        public String[] getAllVersions();
    }
}

