/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ram.internal.scm.clearcase.commands.ucm;

import com.ibm.ram.internal.scm.clearcase.commands.AbstractCleartoolCommand;
import com.ibm.ram.internal.scm.clearcase.commands.CleartoolCommandConstants;
import com.ibm.ram.internal.scm.clearcase.commands.OutputCleartoolCommand;
import com.ibm.ram.internal.scm.clearcase.ucm.Activity;
import java.io.File;
import java.util.ArrayList;

public class ListActivityByNameCommand
extends OutputCleartoolCommand {
    private static final String KEY_CHANGE_SET_VERSIONS = CleartoolCommandConstants.LSACTIVITY_CHANGE_SETS;
    private static final String KEY_TITLE = CleartoolCommandConstants.LSACTIVITY_TITLE;
    private static final String KEY_CURRENT_VIEW = CleartoolCommandConstants.LSACTIVITY_CURRENT_VIEW;
    private static final String KEY_STREAM = CleartoolCommandConstants.LSACTIVITY_STREAM;
    private static final String KEY_GROUP = CleartoolCommandConstants.LSACTIVITY_GROUP;
    private static final String KEY_OWNER = CleartoolCommandConstants.LSACTIVITY_OWNER;
    private static final String KEY_ACTIVITY = CleartoolCommandConstants.LSACTIVITY_ACTIVITY;
    private String activityName;
    private File viewLocation;

    public ListActivityByNameCommand(String activityName, File viewLocation) {
        this.activityName = activityName;
        this.viewLocation = viewLocation;
    }

    @Override
    protected AbstractCleartoolCommand.ICommandOutput parseOutput(String output, String error) {
        Activity activity = null;
        if (output != null && output.length() > 0) {
            String[] lines = output.split("\r\n");
            String activityName = null;
            String owner = null;
            String group = null;
            String stream = null;
            String currentView = null;
            String title = null;
            String[] changeSetVersions = null;
            int i = 0;
            while (i < lines.length) {
                String line = lines[i].trim();
                if (line.startsWith(KEY_ACTIVITY)) {
                    activityName = line.substring(KEY_ACTIVITY.length()).trim();
                    activityName = this.stripQuotes(activityName);
                } else if (line.startsWith(KEY_OWNER)) {
                    owner = line.substring(KEY_OWNER.length()).trim();
                } else if (line.startsWith(KEY_GROUP)) {
                    group = line.substring(KEY_GROUP.length()).trim();
                } else if (line.startsWith(KEY_STREAM)) {
                    stream = line.substring(KEY_STREAM.length()).trim();
                } else if (line.startsWith(KEY_CURRENT_VIEW)) {
                    currentView = line.substring(KEY_CURRENT_VIEW.length()).trim();
                } else if (line.startsWith(KEY_TITLE)) {
                    title = line.substring(KEY_TITLE.length()).trim();
                } else if (line.startsWith(KEY_CHANGE_SET_VERSIONS)) {
                    ArrayList<String> changeSetList = new ArrayList<String>();
                    ++i;
                    while (i < lines.length) {
                        changeSetList.add(lines[i].trim());
                        ++i;
                    }
                    changeSetVersions = changeSetList.toArray(new String[changeSetList.size()]);
                }
                ++i;
            }
            activity = new Activity();
            activity.setActivityName(activityName);
            activity.setOwner(owner);
            activity.setGroup(group);
            activity.setStream(stream);
            activity.setCurrentView(currentView);
            activity.setTitle(title);
            activity.setChangeSetVersions(changeSetVersions);
        }
        final Activity finalActivity = activity;
        return new ListActivityByNameCommandOutput(){

            @Override
            public Activity getOutput() {
                return finalActivity;
            }
        };
    }

    @Override
    protected String[] getArguments() {
        return new String[]{"lsactivity", "-long", this.activityName};
    }

    @Override
    protected File getFolderToRunIn() {
        return this.viewLocation;
    }

    private String stripQuotes(String str) {
        String stripped = str.replace('\"', ' ');
        return stripped.trim();
    }

    public static interface ListActivityByNameCommandOutput
    extends AbstractCleartoolCommand.ICommandOutput {
        public Activity getOutput();
    }
}

