/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ram.internal.scm.clearcase.ucm;

import com.ibm.ram.internal.common.bundles.CommonMessages;
import com.ibm.ram.internal.scm.clearcase.AbstractView;
import com.ibm.ram.internal.scm.clearcase.ClearCaseException;
import com.ibm.ram.internal.scm.clearcase.ClearcaseManager;
import com.ibm.ram.internal.scm.clearcase.FileInfo;
import com.ibm.ram.internal.scm.clearcase.RegistryInformation;
import com.ibm.ram.internal.scm.clearcase.VOB;
import com.ibm.ram.internal.scm.clearcase.VersionFileInfo;
import com.ibm.ram.internal.scm.clearcase.ViewPrivateFileInfo;
import com.ibm.ram.internal.scm.clearcase.commands.AbstractCleartoolCommand;
import com.ibm.ram.internal.scm.clearcase.commands.AbstractListElementTypesCommand;
import com.ibm.ram.internal.scm.clearcase.commands.AddLoadRuleToViewCommand;
import com.ibm.ram.internal.scm.clearcase.commands.DiffCommand;
import com.ibm.ram.internal.scm.clearcase.commands.GetAttributesCommand;
import com.ibm.ram.internal.scm.clearcase.commands.GetUniversalSelectorCommand;
import com.ibm.ram.internal.scm.clearcase.commands.ListVOBCommand;
import com.ibm.ram.internal.scm.clearcase.commands.MakeAttributeTypeCommand;
import com.ibm.ram.internal.scm.clearcase.commands.SetAttributeCommand;
import com.ibm.ram.internal.scm.clearcase.commands.ucm.CreateUCMSnapshotViewCommand;
import com.ibm.ram.internal.scm.clearcase.commands.ucm.DeliverCommand;
import com.ibm.ram.internal.scm.clearcase.commands.ucm.DiffBaseLineCommand;
import com.ibm.ram.internal.scm.clearcase.commands.ucm.FindRAMAssetLinkTypeCommand;
import com.ibm.ram.internal.scm.clearcase.commands.ucm.GetLatestBaselineOnStream;
import com.ibm.ram.internal.scm.clearcase.commands.ucm.GetMergedVersions;
import com.ibm.ram.internal.scm.clearcase.commands.ucm.GetStreamCommand;
import com.ibm.ram.internal.scm.clearcase.commands.ucm.ListActivityByNameCommand;
import com.ibm.ram.internal.scm.clearcase.commands.ucm.ListBaseLinesCommand;
import com.ibm.ram.internal.scm.clearcase.commands.ucm.ListComponentsCommand;
import com.ibm.ram.internal.scm.clearcase.commands.ucm.ListCurrentActivityCommand;
import com.ibm.ram.internal.scm.clearcase.commands.ucm.ListProjectCommand;
import com.ibm.ram.internal.scm.clearcase.commands.ucm.MakeActivityCommand;
import com.ibm.ram.internal.scm.clearcase.commands.ucm.MakeBaseLineCommand;
import com.ibm.ram.internal.scm.clearcase.commands.ucm.MakeStreamCommand;
import com.ibm.ram.internal.scm.clearcase.commands.ucm.PrintViewRoot;
import com.ibm.ram.internal.scm.clearcase.commands.ucm.RebaseStreamCommand;
import com.ibm.ram.internal.scm.clearcase.commands.ucm.RemoveStreamCommand;
import com.ibm.ram.internal.scm.clearcase.ucm.Activity;
import com.ibm.ram.internal.scm.clearcase.ucm.BaseLine;
import com.ibm.ram.internal.scm.clearcase.ucm.BaseLineUtilities;
import com.ibm.ram.internal.scm.clearcase.ucm.ClearcaseUCMReference;
import com.ibm.ram.internal.scm.clearcase.ucm.Component;
import com.ibm.ram.internal.scm.clearcase.ucm.JoinProjectInput;
import com.ibm.ram.internal.scm.clearcase.ucm.Project;
import com.ibm.ram.internal.scm.clearcase.ucm.Stream;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;

public class ClearcaseUCMManager {
    private static final String internalLinkSeparator = ":";
    protected static ClearcaseUCMManager ucmManager = null;
    private ClearcaseManager manager = ClearcaseManager.getInstance();
    private String cliPath = ClearcaseManager.getCLIPath();

    public static ClearcaseUCMManager getInstance() {
        if (ucmManager == null && ClearcaseManager.getInstance() != null) {
            ucmManager = new ClearcaseUCMManager();
        }
        return ucmManager;
    }

    private ClearcaseUCMManager() {
    }

    public ClearcaseManager getBaseManager() {
        return this.manager;
    }

    public boolean isSharedWithClearCase(File viewFile) throws ClearCaseException {
        boolean managed = false;
        AbstractView view = this.manager.getViewAtLocation(viewFile);
        if (view != null && !view.isUCM()) {
            return false;
        }
        FileInfo fi = this.manager.getFileInfo(viewFile);
        if (fi != null) {
            if (fi instanceof ViewPrivateFileInfo) {
                managed = false;
            } else if (fi instanceof VersionFileInfo) {
                managed = true;
            }
        }
        return managed;
    }

    public VOB[] getUCMVOBs(String hostName) throws ClearCaseException {
        if (!this.checkParameter(hostName)) {
            throw new ClearCaseException(CommonMessages.getString("ccUCMManager.cannot.list.pvobs.for.empty.host"));
        }
        try {
            ArrayList<VOB> ucmVOBslist = new ArrayList<VOB>();
            ListVOBCommand command = new ListVOBCommand(hostName, true, false);
            ListVOBCommand.ListVOBOutput viewsOutput = (ListVOBCommand.ListVOBOutput)command.run(this.cliPath);
            VOB[] vobs = viewsOutput.getVOBs();
            int i = 0;
            while (i < vobs.length) {
                if (vobs[i].isUCMVOB()) {
                    ucmVOBslist.add(vobs[i]);
                }
                ++i;
            }
            return ucmVOBslist.toArray(new VOB[ucmVOBslist.size()]);
        }
        catch (IOException e) {
            throw new ClearCaseException(MessageFormat.format(CommonMessages.getString("ccUCMManager.unable.to.determine.pvobs.on.host"), hostName), e);
        }
        catch (InterruptedException e) {
            throw new ClearCaseException(MessageFormat.format(CommonMessages.getString("ccUCMManager.unable.to.determine.pvobs.on.host"), hostName), e);
        }
    }

    public boolean joinProject(JoinProjectInput input, File intViewLocation, File devViewLocation) throws ClearCaseException {
        boolean joinSuccess = false;
        if (input.allParametersSet()) {
            AbstractCleartoolCommand.ICommandOutput output;
            String integrationStreamSelector = input.getProject().getIntegrationStream();
            Stream integrationStream = this.getStreamByName(integrationStreamSelector);
            if (integrationStream == null) {
                throw new ClearCaseException(MessageFormat.format(CommonMessages.getString("ccUCMManager.cannot.join.project.nonexistent.integration.stream"), integrationStreamSelector));
            }
            String[] devStreams = integrationStream.getDevelopmentStreams();
            boolean foundDevStream = false;
            int i = 0;
            while (i < devStreams.length) {
                if (devStreams[i].indexOf(input.getDevelopmentStreamSelector()) > -1) {
                    foundDevStream = true;
                    break;
                }
                ++i;
            }
            if (!foundDevStream) {
                try {
                    MakeStreamCommand command = new MakeStreamCommand(input.getProject().getProjectName(), input.getBaselineSelectors(), input.getDevelopmentStreamSelector());
                    output = (MakeStreamCommand.MakeStreamCommandOutput)command.run(this.cliPath);
                    if (!output.createSuccessful()) {
                        throw new Exception();
                    }
                }
                catch (Exception e) {
                    throw new ClearCaseException(CommonMessages.getString("ccUCMManager.cannot.join.project.stream.creation"), e);
                }
            }
            if (intViewLocation == null) {
                try {
                    CreateUCMSnapshotViewCommand command = new CreateUCMSnapshotViewCommand(input.getIntViewTag(), input.getProject().getIntegrationStream(), input.getViewStoragePath(), input.getViewShortcutPath());
                    output = (CreateUCMSnapshotViewCommand.CreateUCMSnapshotViewCommandOutput)command.run(this.cliPath);
                    if (!output.isCreated()) {
                        throw new Exception();
                    }
                }
                catch (Exception exception) {
                    throw new ClearCaseException(MessageFormat.format(CommonMessages.getString("ccUCMManager.cannot.join.project.view.creation.failed"), input.getProject().getIntegrationStream()));
                }
                intViewLocation = new File(String.valueOf(input.getViewShortcutPath()) + File.separator + input.getIntViewTag());
            }
            if (devViewLocation == null) {
                try {
                    CreateUCMSnapshotViewCommand command = new CreateUCMSnapshotViewCommand(input.getDevViewTag(), input.getDevelopmentStreamSelector(), input.getViewStoragePath(), input.getViewShortcutPath());
                    output = (CreateUCMSnapshotViewCommand.CreateUCMSnapshotViewCommandOutput)command.run(this.cliPath);
                    if (!output.isCreated()) {
                        throw new Exception();
                    }
                }
                catch (Exception exception) {
                    throw new ClearCaseException(MessageFormat.format(CommonMessages.getString("ccUCMManager.cannot.join.project.devview.creation.failed"), input.getDevelopmentStreamSelector()));
                }
                devViewLocation = new File(String.valueOf(input.getViewShortcutPath()) + File.separator + input.getDevViewTag());
            }
            if (devViewLocation == null || intViewLocation == null || !devViewLocation.exists() || !intViewLocation.exists()) {
                throw new ClearCaseException(CommonMessages.getString("ccUCMManager.cannot.join.project.nonexistent.view.location"));
            }
            String[] loadRules = input.getLoadRules();
            int i2 = 0;
            while (i2 < loadRules.length) {
                try {
                    AddLoadRuleToViewCommand updateIntViewCommand = new AddLoadRuleToViewCommand(loadRules[i2], intViewLocation);
                    AddLoadRuleToViewCommand.AddLoadRuleToViewCommandOutput updateIntViewOutput = (AddLoadRuleToViewCommand.AddLoadRuleToViewCommandOutput)updateIntViewCommand.run(this.cliPath);
                    if (!updateIntViewOutput.loadSuccessful()) {
                        throw new Exception();
                    }
                }
                catch (Exception exception) {
                    throw new ClearCaseException(MessageFormat.format(CommonMessages.getString("ccUCMManager.failed.updating.integration.view"), input.getIntViewTag(), loadRules[i2]));
                }
                try {
                    AddLoadRuleToViewCommand updateDevViewCommand = new AddLoadRuleToViewCommand(loadRules[i2], devViewLocation);
                    AddLoadRuleToViewCommand.AddLoadRuleToViewCommandOutput updateDevViewOutput = (AddLoadRuleToViewCommand.AddLoadRuleToViewCommandOutput)updateDevViewCommand.run(this.cliPath);
                    if (!updateDevViewOutput.loadSuccessful()) {
                        throw new Exception();
                    }
                }
                catch (Exception exception) {
                    throw new ClearCaseException(MessageFormat.format(CommonMessages.getString("ccUCMManager.failed.updating.development.view"), input.getDevViewTag(), loadRules[i2]));
                }
                ++i2;
            }
            joinSuccess = true;
        }
        return joinSuccess;
    }

    public Stream getStreamForView(String viewTag) throws ClearCaseException {
        return this.getStreamForView(viewTag, true);
    }

    public Stream getStreamForFileInView(File viewFile) throws ClearCaseException {
        try {
            Stream[] streams;
            GetStreamCommand command = new GetStreamCommand(viewFile);
            GetStreamCommand.GetStreamCommandOutput output = (GetStreamCommand.GetStreamCommandOutput)command.run(this.cliPath);
            if (output != null && (streams = output.getStreams()) != null && streams.length > 0) {
                return streams[0];
            }
        }
        catch (Exception e) {
            throw new ClearCaseException(CommonMessages.getString("ccUCMManager.could.not.get.stream.for.view"), e);
        }
        return null;
    }

    public Stream getStreamByName(String streamSelector) throws ClearCaseException {
        return this.getStreamForView(streamSelector, false);
    }

    public Stream[] getStreamsInProject(String projectSelector) throws ClearCaseException {
        if (!this.checkParameter(projectSelector)) {
            throw new ClearCaseException(CommonMessages.getString("ccUCMManager.cannot.find.streams.for.unspecified.project"));
        }
        try {
            GetStreamCommand command = new GetStreamCommand(projectSelector);
            GetStreamCommand.GetStreamCommandOutput output = (GetStreamCommand.GetStreamCommandOutput)command.run(this.cliPath);
            if (output != null) {
                Stream[] streams = output.getStreams();
                return streams;
            }
        }
        catch (Exception exception) {
            throw new ClearCaseException(MessageFormat.format(CommonMessages.getString("ccUCMManager.could.not.find.any.stream.on.project"), projectSelector));
        }
        return null;
    }

    public Stream getStreamForView(String viewTag, boolean isView) throws ClearCaseException {
        if (!this.checkParameter(viewTag)) {
            throw new ClearCaseException(CommonMessages.getString("ccUCMManager.cannot.find.stream.for.unspecified.view"));
        }
        try {
            Stream[] streams;
            GetStreamCommand command = new GetStreamCommand(viewTag, isView);
            GetStreamCommand.GetStreamCommandOutput output = (GetStreamCommand.GetStreamCommandOutput)command.run(this.cliPath);
            if (output != null && (streams = output.getStreams()) != null && streams.length > 0) {
                return streams[0];
            }
        }
        catch (Exception e) {
            throw new ClearCaseException(MessageFormat.format(CommonMessages.getString("ccUCMManager.couldnot.find.stream.for.viewtag"), viewTag), e);
        }
        return null;
    }

    public Project getProject(String projectSelector) throws ClearCaseException {
        Project project = null;
        if (projectSelector != null) {
            try {
                ListProjectCommand command = new ListProjectCommand(projectSelector, 1);
                ListProjectCommand.ListProjectOutput projectsOutput = (ListProjectCommand.ListProjectOutput)command.run(this.cliPath);
                Project[] projects = projectsOutput.getProjects();
                if (projects != null && projects.length > 0) {
                    project = projects[0];
                }
            }
            catch (Exception e) {
                throw new ClearCaseException(MessageFormat.format(CommonMessages.getString("ccUCMManager.unable.to.find.project"), projectSelector), e);
            }
        }
        return project;
    }

    public Project[] listProjects(String viewTag) throws ClearCaseException {
        if (!this.checkParameter(viewTag)) {
            throw new ClearCaseException(CommonMessages.getString("ccUCMManager.cannot.list.projects.invalid.viewtag"));
        }
        try {
            ListProjectCommand command = new ListProjectCommand(viewTag, 0);
            ListProjectCommand.ListProjectOutput projectsOutput = (ListProjectCommand.ListProjectOutput)command.run(this.cliPath);
            return projectsOutput.getProjects();
        }
        catch (Exception e) {
            throw new ClearCaseException(MessageFormat.format(CommonMessages.getString("ccUCMManager.unable.to.determine.projects.in.view"), viewTag), e);
        }
    }

    public String getUUIDForBaseLine(BaseLine bl) throws ClearCaseException {
        if (bl != null) {
            String blName = bl.getBaselineName();
            String componentName = bl.getComponent();
            String pvobName = ClearcaseUCMManager.parsePVOBNameFromSelector(componentName);
            String baselineSelector = "baseline:" + blName + "@" + pvobName;
            try {
                GetUniversalSelectorCommand command = new GetUniversalSelectorCommand(new String[]{baselineSelector});
                GetUniversalSelectorCommand.ReferenceOutput output = (GetUniversalSelectorCommand.ReferenceOutput)command.run(this.cliPath);
                return output.getUniversalSelector()[0];
            }
            catch (Exception e) {
                throw new ClearCaseException(MessageFormat.format(CommonMessages.getString("ccUCMManager.error.getting.uuid.for.baseline"), baselineSelector), e);
            }
        }
        return null;
    }

    public BaseLine[] getBaselines(String[] baselineSelectors) throws ClearCaseException {
        ArrayList<BaseLine> baselineList = new ArrayList<BaseLine>();
        int i = 0;
        while (i < baselineSelectors.length) {
            BaseLine currentBaseline = this.getBaseline(baselineSelectors[i].trim());
            if (currentBaseline != null) {
                baselineList.add(currentBaseline);
            }
            ++i;
        }
        return baselineList.toArray(new BaseLine[baselineList.size()]);
    }

    public BaseLine getBaseline(String baselineSelector) throws ClearCaseException {
        BaseLine baseline = null;
        try {
            ListBaseLinesCommand command = new ListBaseLinesCommand(baselineSelector, 2);
            ListBaseLinesCommand.ListBaseLineOutput output = (ListBaseLinesCommand.ListBaseLineOutput)command.run(this.cliPath);
            BaseLine[] bls = output.getBaseLines();
            if (bls != null && bls.length > 0) {
                baseline = bls[0];
            }
        }
        catch (Exception e) {
            throw new ClearCaseException(MessageFormat.format(CommonMessages.getString("ccUCMManager.could.not.find.baseline"), baselineSelector), e);
        }
        return baseline;
    }

    public BaseLine getBaselineByUUID(String baselineUUID) throws ClearCaseException {
        BaseLine baseline = null;
        try {
            ListBaseLinesCommand command = new ListBaseLinesCommand(baselineUUID, 3);
            ListBaseLinesCommand.ListBaseLineOutput output = (ListBaseLinesCommand.ListBaseLineOutput)command.run(this.cliPath);
            BaseLine[] bls = output.getBaseLines();
            if (bls != null && bls.length > 0) {
                baseline = bls[0];
            }
        }
        catch (Exception e) {
            throw new ClearCaseException(MessageFormat.format(CommonMessages.getString("ccUCMManager.could.not.find.baseline.with.uuid"), baselineUUID), e);
        }
        return baseline;
    }

    public BaseLine getFirstBaselineFromUUIDs(String baselineUUIDs) throws ClearCaseException {
        BaseLine baseline = null;
        if (baselineUUIDs != null && baselineUUIDs.length() > 0) {
            String firstSelector = null;
            if (baselineUUIDs.indexOf(",") != -1) {
                String[] splitSelectors = baselineUUIDs.split(",");
                firstSelector = splitSelectors[0];
            } else {
                firstSelector = baselineUUIDs;
            }
            baseline = this.getBaselineByUUID(firstSelector);
        }
        return baseline;
    }

    public List getComponentsOfAllBaselinesInSelector(String uuidString) throws ClearCaseException {
        ArrayList<String> componentList = new ArrayList<String>();
        if (uuidString != null && uuidString.length() > 0) {
            BaseLine[] baselines = this.getBaselinesFromSelectors(uuidString);
            int i = 0;
            while (i < baselines.length) {
                String currentComponent = baselines[i].getComponent();
                componentList.add(currentComponent);
                ++i;
            }
        }
        return componentList;
    }

    public Component getComponent(String componentSelector) throws ClearCaseException {
        Component component = null;
        try {
            ListComponentsCommand command = new ListComponentsCommand(componentSelector, ListComponentsCommand.MODE_BYSELECTOR);
            ListComponentsCommand.ListComponentsOutput output = (ListComponentsCommand.ListComponentsOutput)command.run(this.cliPath);
            Component[] comps = output.getComponents();
            if (comps != null && comps.length > 0) {
                component = comps[0];
            }
        }
        catch (Exception exception) {
            throw new ClearCaseException("Error retrieving component with selector of " + componentSelector);
        }
        return component;
    }

    public Component[] getComponents(String[] componentSelectors) throws ClearCaseException {
        ArrayList<Component> componentList = new ArrayList<Component>();
        int i = 0;
        while (i < componentSelectors.length) {
            Component currentComponent = this.getComponent(componentSelectors[i].trim());
            if (currentComponent != null) {
                componentList.add(currentComponent);
            }
            ++i;
        }
        return componentList.toArray(new Component[componentList.size()]);
    }

    private BaseLine[] getBaselinesFromSelectors(String uuidString) throws ClearCaseException {
        ArrayList<BaseLine> baselines = new ArrayList<BaseLine>();
        if (uuidString != null && uuidString.length() > 0) {
            String[] baselineUUIDs = uuidString.split(",");
            int i = 0;
            while (i < baselineUUIDs.length) {
                BaseLine currentBL = this.getBaselineByUUID(baselineUUIDs[i]);
                baselines.add(currentBL);
                ++i;
            }
        }
        return baselines.toArray(new BaseLine[baselines.size()]);
    }

    public String convertBaselineUUIDsToSelectors(String uuidString) throws ClearCaseException {
        String convertedSelectors = null;
        if (uuidString != null && uuidString.length() > 0) {
            StringBuffer stringbuf = new StringBuffer();
            BaseLine[] baselines = this.getBaselinesFromSelectors(uuidString);
            int i = 0;
            while (i < baselines.length) {
                BaseLine currentBL = baselines[i];
                String baselineSelector = String.valueOf(currentBL.getBaselineName()) + "@" + ClearcaseUCMManager.parsePVOBNameFromSelector(currentBL.getComponent());
                stringbuf.append(baselineSelector);
                stringbuf.append(",");
                ++i;
            }
            String selectors = stringbuf.toString();
            int lastComma = selectors.lastIndexOf(",");
            if (selectors.length() - 1 == lastComma) {
                selectors = selectors.substring(0, lastComma);
            }
            convertedSelectors = selectors;
        }
        return convertedSelectors;
    }

    public String[] convertBaselineUUIDsToSelectorArray(String uuidString) throws ClearCaseException {
        String selectorString = this.convertBaselineUUIDsToSelectors(uuidString);
        String[] selectorArray = null;
        if (selectorString != null) {
            String[] splitSelectors = selectorString.split(",");
            selectorArray = splitSelectors;
        }
        return selectorArray;
    }

    public BaseLine[] listBaseLinesOnStream(String streamSelector) throws ClearCaseException {
        if (!this.checkParameter(streamSelector)) {
            throw new ClearCaseException(CommonMessages.getString("ccUCMManager.cannot.list.baselines.due.to.invalid.selector"));
        }
        try {
            ListBaseLinesCommand command = new ListBaseLinesCommand(streamSelector, 0);
            ListBaseLinesCommand.ListBaseLineOutput baselinesOutput = (ListBaseLinesCommand.ListBaseLineOutput)command.run(this.cliPath);
            return baselinesOutput.getBaseLines();
        }
        catch (Exception e) {
            throw new ClearCaseException(MessageFormat.format(CommonMessages.getString("ccUCMManager.unable.to.determine.stream.baselines"), streamSelector), e);
        }
    }

    public String findNewestBaseLineOnStream(String streamSelector) throws ClearCaseException {
        return this.findNewestBaseLineOnStreamWithConfigurationCheck(streamSelector, false);
    }

    public String findNewestBaseLineOnStreamWithConfigurationCheck(String streamSelector, boolean performCheck) throws ClearCaseException {
        if (!this.checkParameter(streamSelector)) {
            throw new ClearCaseException(CommonMessages.getString("ccUCMManager.cannot.find.newest.baseline.for.invalid.stream"));
        }
        String newestBaseline = null;
        try {
            GetLatestBaselineOnStream latestCmd = new GetLatestBaselineOnStream(streamSelector);
            GetLatestBaselineOnStream.GetLatestBaselineOutput output = (GetLatestBaselineOnStream.GetLatestBaselineOutput)latestCmd.run(this.cliPath);
            String[] latestBaselineSelectors = output.getLatestBaselines();
            BaseLine[] latestBaselines = this.getBaselines(latestBaselineSelectors);
            BaseLine[] compositeAndIndependantBLs = BaseLineUtilities.getCompositeAndIndependantBaseLines(latestBaselines);
            if (performCheck) {
                Stream stream = ucmManager.getStreamByName(streamSelector);
                String[] foundationBaselines = stream.getFoundationBaselines();
                int cfr_ignored_0 = latestBaselineSelectors.length;
                int cfr_ignored_1 = foundationBaselines.length;
                StringBuffer notFound = new StringBuffer();
                int j = 0;
                while (j < latestBaselineSelectors.length) {
                    String currentSelector = latestBaselineSelectors[j];
                    boolean foundSelector = false;
                    int k = 0;
                    while (k < foundationBaselines.length) {
                        if (currentSelector.indexOf(foundationBaselines[k]) != -1) {
                            foundSelector = true;
                            break;
                        }
                        ++k;
                    }
                    if (!foundSelector) {
                        notFound.append(currentSelector);
                        if (j < latestBaselineSelectors.length - 1) {
                            notFound.append(",");
                        }
                    }
                    ++j;
                }
                String problemBaselines = notFound.toString();
                if (problemBaselines.length() > 0) {
                    if (problemBaselines.charAt(problemBaselines.length() - 1) == ',') {
                        problemBaselines = problemBaselines.substring(0, problemBaselines.length() - 1);
                    }
                    throw new ClearCaseException("The following latest baselines could not be found in the foundation of the stream: " + problemBaselines);
                }
            }
            ArrayList<String> newestBaselineList = new ArrayList<String>();
            int i = 0;
            while (i < compositeAndIndependantBLs.length) {
                newestBaselineList.add(this.getUUIDForBaseLine(compositeAndIndependantBLs[i]));
                ++i;
            }
            String[] newestUUIDS = newestBaselineList.toArray(new String[newestBaselineList.size()]);
            StringBuffer buf = new StringBuffer();
            int i2 = 0;
            while (i2 < newestUUIDS.length) {
                buf.append(newestUUIDS[i2]);
                if (i2 < newestUUIDS.length - 1) {
                    buf.append(",");
                }
                ++i2;
            }
            newestBaseline = buf.toString();
        }
        catch (Exception e) {
            throw new ClearCaseException(MessageFormat.format(CommonMessages.getString("ccUCMManager.could.not.find.latest.baseline.on.stream"), streamSelector), e);
        }
        return newestBaseline;
    }

    public String listCurrentActivity(String viewTag) throws ClearCaseException {
        if (!this.checkParameter(viewTag)) {
            throw new ClearCaseException(CommonMessages.getString("ccUCMManager.cannot.list.current.activity.invalid.viewtag"));
        }
        try {
            ListCurrentActivityCommand command = new ListCurrentActivityCommand(viewTag);
            ListCurrentActivityCommand.ListCurrentActivityOutput output = (ListCurrentActivityCommand.ListCurrentActivityOutput)command.run(this.cliPath);
            String activity = output.getCurrentActivity();
            return activity;
        }
        catch (Exception e) {
            throw new ClearCaseException(MessageFormat.format(CommonMessages.getString("ccUCMManager.unable.list.current.activity.for.view"), viewTag), e);
        }
    }

    public boolean addToSourceControl(String activity, File[] files) throws ClearCaseException {
        if (files.length < 1) {
            throw new ClearCaseException(CommonMessages.getString("ccUCMManager.unable.to.add.nothing.source.control"));
        }
        if (!this.checkParameter(activity)) {
            throw new ClearCaseException(CommonMessages.getString("ccUCMManager.unable.to.add.source.control.invalid.activity"));
        }
        AbstractView view = this.manager.getViewAtLocation(files[0]);
        if (view == null || view.getTag().equals("")) {
            throw new ClearCaseException(CommonMessages.getString("ccUCMManager.unable.to.add.source.control.no.view"));
        }
        String currentActivityName = this.listCurrentActivity(view.getTag());
        if (currentActivityName == null) {
            throw new ClearCaseException(MessageFormat.format(CommonMessages.getString("ccUCMManager.unable.to.add.source.control.no.activity.on.view"), view.getTag()));
        }
        if (!currentActivityName.equals(activity)) {
            throw new ClearCaseException(MessageFormat.format(CommonMessages.getString("ccUCMManager.unable.to.add.source.control.mismatched.activities"), currentActivityName, activity));
        }
        return this.manager.addToSourceControl(files);
    }

    public boolean deliver(String integrationViewTag, File viewLocation) throws ClearCaseException {
        if (viewLocation == null) {
            throw new ClearCaseException(CommonMessages.getString("ccUCMManager.cannot.deliver.null.view"));
        }
        try {
            DeliverCommand command = new DeliverCommand(integrationViewTag, viewLocation);
            DeliverCommand.DeliverCommandOutput output = (DeliverCommand.DeliverCommandOutput)command.run(this.cliPath);
            return output.isComplete();
        }
        catch (Exception e) {
            throw new ClearCaseException(MessageFormat.format(CommonMessages.getString("ccUCMManager.could.not.deliver.to"), integrationViewTag), e);
        }
    }

    public boolean makeActivityAndSetCurrent(String activityName, File rootPath) throws ClearCaseException {
        boolean okToMake = false;
        try {
            if (activityName != null && activityName.length() > 0) {
                ListActivityByNameCommand command = new ListActivityByNameCommand(activityName, rootPath);
                ListActivityByNameCommand.ListActivityByNameCommandOutput output = (ListActivityByNameCommand.ListActivityByNameCommandOutput)command.run(this.cliPath);
                Activity cmdOutput = output.getOutput();
                if (cmdOutput == null) {
                    okToMake = true;
                }
            } else {
                okToMake = true;
            }
            if (okToMake) {
                MakeActivityCommand mkActCmd = new MakeActivityCommand(activityName, rootPath);
                MakeActivityCommand.MakeActivityCommandOutput mkOutput = (MakeActivityCommand.MakeActivityCommandOutput)mkActCmd.run(this.cliPath);
                return mkOutput.isActivityCreated();
            }
            return false;
        }
        catch (IOException iOException) {
            throw new ClearCaseException(MessageFormat.format(CommonMessages.getString("ccUCMManager.could.not.make.activity.in.location"), activityName, rootPath.getAbsolutePath()));
        }
        catch (InterruptedException interruptedException) {
            throw new ClearCaseException(MessageFormat.format(CommonMessages.getString("ccUCMManager.could.not.make.activity.in.location"), activityName, rootPath.getAbsolutePath()));
        }
    }

    public String getViewRoot(File folderInView) throws ClearCaseException {
        if (folderInView == null) {
            throw new ClearCaseException(CommonMessages.getString("ccUCMManager.supplied.folder.must.be.valid"));
        }
        if (!folderInView.isDirectory() && folderInView.exists()) {
            folderInView = folderInView.getParentFile();
        }
        try {
            PrintViewRoot command = new PrintViewRoot(folderInView);
            PrintViewRoot.PrintViewRootOutput output = (PrintViewRoot.PrintViewRootOutput)command.run(this.cliPath);
            return output.getViewRoot();
        }
        catch (Exception e) {
            throw new ClearCaseException(MessageFormat.format(CommonMessages.getString("ccUCMManager.could.not.get.view.root.at"), folderInView.getAbsolutePath()), e);
        }
    }

    public boolean makeBaselineOnView(String baselineName, String viewTag) throws ClearCaseException {
        return this.makeBaselineOnView(baselineName, viewTag, false);
    }

    public boolean makeBaselineOnView(String baselineName, String viewTag, boolean identical) throws ClearCaseException {
        if (!this.checkParameter(baselineName)) {
            throw new ClearCaseException(CommonMessages.getString("ccUCMManager.cannot.create.baseline.with.empty.name"));
        }
        if (!this.checkParameter(viewTag)) {
            throw new ClearCaseException(CommonMessages.getString("ccUCMManager.cannot.create.baseline.with.empty.viewtag"));
        }
        try {
            MakeBaseLineCommand command = new MakeBaseLineCommand(viewTag, baselineName, identical);
            MakeBaseLineCommand.MakeBaseLineCommandOuptut output = (MakeBaseLineCommand.MakeBaseLineCommandOuptut)command.run(this.cliPath);
            return output.isBaselineCreated();
        }
        catch (Exception e) {
            throw new ClearCaseException(MessageFormat.format(CommonMessages.getString("ccUCMManager.could.not.create.baseline.on"), baselineName, viewTag), e);
        }
    }

    public boolean rebaseStream(String developmentViewTag, String developmentStream, String baselineName) throws ClearCaseException {
        if (!this.checkParameter(developmentViewTag)) {
            throw new ClearCaseException("Cannot rebase because of invalid development viewTag");
        }
        if (!this.checkParameter(developmentStream)) {
            throw new ClearCaseException("Cannot rebase because of invalid development stream");
        }
        if (!this.checkParameter(baselineName)) {
            throw new ClearCaseException("Cannot rebase because of invalid baseline");
        }
        try {
            RebaseStreamCommand command = new RebaseStreamCommand(developmentViewTag, developmentStream, baselineName);
            RebaseStreamCommand.RebaseStreamCommandOutput output = (RebaseStreamCommand.RebaseStreamCommandOutput)command.run(this.cliPath);
            boolean rebaseCompleted = output.rebaseComplete();
            return rebaseCompleted;
        }
        catch (Exception e) {
            throw new ClearCaseException("Rebase of " + developmentStream + " stream to baseline " + baselineName + " failed", e);
        }
    }

    private boolean checkParameter(String parameter) {
        return parameter != null && parameter.length() > 0;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean versionsMatchByMerge(File viewFile, String fromVersion, String toVersion) throws ClearCaseException {
        try {
            GetMergedVersions mergedVersionsCommand = new GetMergedVersions(viewFile, fromVersion);
            GetMergedVersions.GetMergedVersionsOutput output = (GetMergedVersions.GetMergedVersionsOutput)mergedVersionsCommand.run(this.cliPath);
            if (output == null) return false;
            String[] mergedVersions = output.getMergedVersions();
            if (mergedVersions == null || mergedVersions.length == 0) {
                String elementName = viewFile.getAbsolutePath().substring(viewFile.getAbsolutePath().lastIndexOf(File.separator) + 1);
                String selector1 = String.valueOf(elementName) + "@@" + fromVersion;
                String selector2 = String.valueOf(elementName) + "@@" + toVersion;
                DiffCommand command = new DiffCommand(selector1, selector2, viewFile);
                DiffCommand.DiffOutput diffOutput = (DiffCommand.DiffOutput)command.run(this.cliPath);
                return diffOutput.identical();
            }
            int i = 0;
            while (true) {
                if (i >= mergedVersions.length) {
                    return false;
                }
                if (mergedVersions[i].equals(toVersion)) {
                    return true;
                }
                ++i;
            }
        }
        catch (Exception e) {
            throw new ClearCaseException(CommonMessages.getString("ccUCMManager.could.not.compare.versions"), e);
        }
    }

    public String[] getVersionTree(File viewFile) throws ClearCaseException {
        if (viewFile != null) {
            try {
                GetMergedVersions mergedVersionsCommand = new GetMergedVersions(viewFile, null);
                GetMergedVersions.GetMergedVersionsOutput output = (GetMergedVersions.GetMergedVersionsOutput)mergedVersionsCommand.run(this.cliPath);
                return output.getAllVersions();
            }
            catch (Exception exception) {
                throw new ClearCaseException(MessageFormat.format(CommonMessages.getString("ccUCMManager.could.not.get.list.of.versions.for"), viewFile.getAbsolutePath()));
            }
        }
        return null;
    }

    public boolean unjoinProject(JoinProjectInput input) throws ClearCaseException {
        File devViewFolder = new File(String.valueOf(input.getViewShortcutPath()) + File.separator + input.getDevViewTag());
        boolean devViewRemoved = this.manager.removeSnapshotView(input.getDevViewTag(), devViewFolder);
        File intViewFolder = new File(String.valueOf(input.getViewShortcutPath()) + File.separator + input.getIntViewTag());
        boolean intViewRemoved = this.manager.removeSnapshotView(input.getIntViewTag(), intViewFolder);
        boolean streamRemoved = ucmManager.removeStream(input.getDevelopmentStreamSelector());
        return devViewRemoved && intViewRemoved && streamRemoved;
    }

    public boolean removeStream(String streamSelector) throws ClearCaseException {
        try {
            RemoveStreamCommand command = new RemoveStreamCommand(streamSelector);
            RemoveStreamCommand.RemoveStreamCommandOuptut output = (RemoveStreamCommand.RemoveStreamCommandOuptut)command.run(this.cliPath);
            return output.streamRemoved();
        }
        catch (Exception e) {
            throw new ClearCaseException(MessageFormat.format(CommonMessages.getString("ccUCMManager.failed.remove.stream"), streamSelector), e);
        }
    }

    public boolean addAssetLinkToBaseline(String assetVersion, String id, String version, Stream stream, BaseLine relevantBL) throws ClearCaseException {
        String pvobSelector = ClearcaseUCMManager.parsePVOBNameFromSelector(stream.getDefaultDeliverStream());
        String strippedId = this.stripGuid(id);
        String linkName = "RAM_" + strippedId + "_" + version;
        if (!this.isRAMAssetLinkDefined(linkName, pvobSelector) && !this.createRAMAssetLink(linkName, pvobSelector)) {
            throw new ClearCaseException(CommonMessages.getString("ccUCMManager.could.not.create.ramassetlink.attr.type"));
        }
        try {
            String pvobName = ClearcaseUCMManager.parsePVOBNameFromSelector(relevantBL.getComponent());
            String baselineSelector = "baseline:" + relevantBL.getBaselineName() + "@" + pvobName;
            String assetLinkName = String.valueOf(linkName) + "@" + pvobName;
            SetAttributeCommand setAttrCommand = new SetAttributeCommand(assetLinkName, assetVersion, baselineSelector);
            SetAttributeCommand.SetAttributeOutput setAttrOutput = (SetAttributeCommand.SetAttributeOutput)setAttrCommand.run(this.cliPath);
            if (!setAttrOutput.isSet()) {
                throw new ClearCaseException(MessageFormat.format(CommonMessages.getString("ccUCMManager.could.not.successfully.set.attr.on.baseline"), baselineSelector));
            }
        }
        catch (Exception e) {
            String mesg = CommonMessages.getString("ccUCMManager.error.adding.asset.link.to.baseline");
            throw new ClearCaseException(mesg, e);
        }
        return true;
    }

    public String stripGuid(String id) {
        String stripped = null;
        if (id.indexOf("{") == 0) {
            stripped = id.substring(1);
        }
        if (stripped != null && stripped.indexOf("}") != -1) {
            stripped = stripped.substring(0, stripped.indexOf("}"));
        }
        return stripped;
    }

    public BaseLine getBaseLineForComponent(Stream stream, String component) throws ClearCaseException {
        String[] baselines = stream.getFoundationBaselines();
        BaseLine relevantBL = null;
        int i = 0;
        while (i < baselines.length) {
            BaseLine currentBL = ucmManager.getBaseline(baselines[i]);
            if (currentBL != null) {
                ArrayList components;
                String currentBLComponent = currentBL.getComponent();
                int componentIndex = currentBLComponent.indexOf(component);
                if (componentIndex != -1) {
                    relevantBL = currentBL;
                    break;
                }
                if (currentBL.isComposite() && (components = BaseLineUtilities.getDependantComponentListFromCompositeBL(currentBL)).contains(component)) {
                    relevantBL = currentBL;
                }
            }
            ++i;
        }
        return relevantBL;
    }

    public String getRAMAssetLinkFromBaseline(BaseLine baseline, String linkToFind) throws ClearCaseException {
        String attributeValue = null;
        if (baseline != null && linkToFind != null) {
            try {
                String pvobName = ClearcaseUCMManager.parsePVOBNameFromSelector(baseline.getComponent());
                String baselineSelector = "baseline:" + baseline.getBaselineName() + "@" + pvobName;
                GetAttributesCommand getAttrs = new GetAttributesCommand(baselineSelector);
                GetAttributesCommand.GetAttributesOutput output = (GetAttributesCommand.GetAttributesOutput)getAttrs.run(this.cliPath);
                Properties props = output.getAttributes();
                attributeValue = (String)props.get(linkToFind);
            }
            catch (Exception e) {
                throw new ClearCaseException(MessageFormat.format(CommonMessages.getString("ccUCMManager.could.not.get.baseline.attrs"), baseline.getBaselineName()), e);
            }
        }
        return attributeValue;
    }

    private boolean createRAMAssetLink(String linkName, String pvobSelector) throws ClearCaseException {
        try {
            MakeAttributeTypeCommand command = new MakeAttributeTypeCommand(linkName, "Creating RAMAssetLink", pvobSelector);
            MakeAttributeTypeCommand.MakeAttributeTypeCommandOutput output = (MakeAttributeTypeCommand.MakeAttributeTypeCommandOutput)command.run(this.cliPath);
            return output.isCreated();
        }
        catch (Exception e) {
            throw new ClearCaseException(MessageFormat.format(CommonMessages.getString("ccUCMManager.could.not.create.attr.type"), linkName), e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isRAMAssetLinkDefined(String linkName, String pvobSelector) throws ClearCaseException {
        try {
            FindRAMAssetLinkTypeCommand command = new FindRAMAssetLinkTypeCommand(linkName, pvobSelector);
            AbstractListElementTypesCommand.ListTypesOutput output = (AbstractListElementTypesCommand.ListTypesOutput)command.run(this.cliPath);
            String[] types = output.getTypes();
            int i = 0;
            while (true) {
                if (i >= types.length) {
                    return false;
                }
                if (types[i].equals(linkName)) {
                    return true;
                }
                ++i;
            }
        }
        catch (Exception e) {
            throw new ClearCaseException(MessageFormat.format(CommonMessages.getString("ccUCMManager.could.not.determine.if.link.defined"), linkName), e);
        }
    }

    public static String parsePVOBNameFromSelector(String genericUCMSelector) {
        String pvob = null;
        if (genericUCMSelector != null) {
            pvob = genericUCMSelector.substring(genericUCMSelector.indexOf(64) + 1);
        }
        return pvob;
    }

    public ClearcaseUCMReference getUCMReference(File viewFile, String pathInContainer) throws ClearCaseException {
        return this.createUCMReferences(new File[]{viewFile}, null, new String[]{pathInContainer})[0];
    }

    public ClearcaseUCMReference[] createUCMReferences(File[] viewFiles, String label, String[] pathInContainers) throws ClearCaseException {
        ClearcaseUCMReference[] references = null;
        if (viewFiles != null && viewFiles.length > 0) {
            List<File> viewFilesList = Arrays.asList(viewFiles);
            references = new ClearcaseUCMReference[viewFiles.length];
            ArrayList<File> inSCMFileList = new ArrayList<File>();
            FileInfo[] viewFileInfos = this.manager.getFileInfos(viewFiles);
            int vfc = 0;
            while (vfc < viewFileInfos.length) {
                if (viewFileInfos[vfc] instanceof VersionFileInfo) {
                    inSCMFileList.add(viewFiles[vfc]);
                }
                ++vfc;
            }
            if (inSCMFileList.size() > 0) {
                String registryHost;
                String[] univSelectorPaths = new String[inSCMFileList.size() * 2];
                String[] filePaths = new String[inSCMFileList.size()];
                String[] branches = new String[inSCMFileList.size()];
                int fc = 0;
                while (fc < inSCMFileList.size()) {
                    File file = (File)inSCMFileList.get(fc);
                    filePaths[fc] = file.getAbsolutePath();
                    String versionFilePath = filePaths[fc];
                    String elementFilePath = String.valueOf(filePaths[fc]) + "@@";
                    univSelectorPaths[2 * fc] = versionFilePath;
                    univSelectorPaths[2 * fc + 1] = elementFilePath;
                    branches[fc] = null;
                    ++fc;
                }
                String[] univSelectors = null;
                try {
                    GetUniversalSelectorCommand guc = new GetUniversalSelectorCommand(univSelectorPaths);
                    GetUniversalSelectorCommand.ReferenceOutput out = (GetUniversalSelectorCommand.ReferenceOutput)guc.run(this.cliPath);
                    univSelectors = out.getUniversalSelector();
                }
                catch (InterruptedException e) {
                    throw new ClearCaseException(CommonMessages.getString("ccUCMManager.unable.to.resolve.uuids.for.files"), e);
                }
                catch (IOException e) {
                    throw new ClearCaseException(CommonMessages.getString("ccUCMManager.unable.to.resolve.uuids.for.files"), e);
                }
                String[] versionPaths = this.manager.resolveFilePathToVersion(filePaths);
                HashMap<String, VOB> uuidToVOBMap = new HashMap<String, VOB>();
                VOB[] vobs = new VOB[inSCMFileList.size()];
                int vc = 0;
                while (vc < vobs.length) {
                    String versionUniversalSelector = univSelectors[2 * vc];
                    String VOBSEP = "@vobuuid:";
                    int vobIndex = versionUniversalSelector.indexOf(VOBSEP);
                    if (vobIndex > -1) {
                        String vobUID = versionUniversalSelector.substring(vobIndex + VOBSEP.length());
                        if (uuidToVOBMap.containsKey(vobUID)) {
                            vobs[vc] = (VOB)uuidToVOBMap.get(vobUID);
                        } else {
                            VOB vob = this.manager.getVOB(vobUID);
                            uuidToVOBMap.put(vobUID, vob);
                            vobs[vc] = vob;
                        }
                    }
                    ++vc;
                }
                RegistryInformation regInfo = this.manager.getRegistryInformation();
                String string = registryHost = regInfo != null ? regInfo.getRegistryHost() : null;
                if (label == null) {
                    label = "";
                }
                int rc = 0;
                while (rc < inSCMFileList.size()) {
                    ArrayList<String> baselineUUIDList = new ArrayList<String>();
                    File file = (File)inSCMFileList.get(rc);
                    int viewFileIndex = viewFilesList.indexOf(file);
                    Stream rootResourceStream = ucmManager.getStreamForFileInView(file);
                    String[] foundationBaselines = rootResourceStream.getFoundationBaselines();
                    int j = 0;
                    while (j < foundationBaselines.length) {
                        BaseLine currentBL = ucmManager.getBaseline(foundationBaselines[j]);
                        if (currentBL != null) {
                            String uuid = ucmManager.getUUIDForBaseLine(currentBL);
                            baselineUUIDList.add(uuid);
                        }
                        ++j;
                    }
                    String baselineUUIDs = this.buildBaselineUUIDString(baselineUUIDList);
                    String versionUniversalSelector = univSelectors[2 * rc];
                    String elementUniversalSelector = univSelectors[2 * rc + 1];
                    String fileLabel = label;
                    String versionPath = versionPaths[rc];
                    VOB vob = vobs[rc];
                    if (versionPath == null) {
                        versionPath = "";
                    }
                    references[viewFileIndex] = new ClearcaseUCMReference(baselineUUIDs, versionUniversalSelector, elementUniversalSelector, fileLabel, versionPath, branches[rc], vob, registryHost, file.isDirectory(), pathInContainers[viewFileIndex]);
                    ++rc;
                }
            }
        }
        return references;
    }

    private String buildBaselineUUIDString(ArrayList baselineUUIDList) {
        StringBuffer buffer = new StringBuffer();
        for (String currentUUID : baselineUUIDList) {
            buffer.append(currentUUID);
            buffer.append(",");
        }
        String uuids = buffer.toString();
        int lastComma = uuids.lastIndexOf(",");
        if (uuids.length() - 1 == lastComma) {
            uuids = uuids.substring(0, lastComma);
        }
        return uuids;
    }

    public String[] getUniversalSelector(String[] filePaths) throws ClearCaseException {
        try {
            GetUniversalSelectorCommand command = new GetUniversalSelectorCommand(filePaths);
            GetUniversalSelectorCommand.ReferenceOutput output = (GetUniversalSelectorCommand.ReferenceOutput)command.run(this.cliPath);
            return output.getUniversalSelector();
        }
        catch (Exception exception) {
            throw new ClearCaseException(CommonMessages.getString("ccUCMManager.could.not.get.uuids.for.supplied.file.paths"));
        }
    }

    public String[] streamContainsChangesFromFoundation(File viewRoot, String streamSelector, String baselineSelector) throws ClearCaseException {
        try {
            DiffBaseLineCommand command = new DiffBaseLineCommand(viewRoot, true, streamSelector, baselineSelector);
            DiffBaseLineCommand.DiffBaseLineOutput output = (DiffBaseLineCommand.DiffBaseLineOutput)command.run(this.cliPath);
            return output.getLeftOutput();
        }
        catch (Exception exception) {
            throw new ClearCaseException(MessageFormat.format(CommonMessages.getString("ccUCMManager.could.not.determine.diff"), streamSelector, baselineSelector));
        }
    }
}

