/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ram.policy;

import com.ibm.ram.client.RAMAsset;
import com.ibm.ram.client.RAMSession;
import com.ibm.ram.common.data.AssetIdentification;
import com.ibm.ram.internal.jaxb.Asset;
import com.ibm.ram.policy.PolicyEvent;
import java.util.ArrayList;
import java.util.List;

public class PolicyContext {
    private Asset asset;
    private List<PolicyEvent> eventList;
    private RAMAsset ramAsset;
    private RAMSession ramSession;
    private boolean submission = false;

    public RAMSession getRAMSession() {
        return this.ramSession;
    }

    public void setRAMSession(RAMSession ramSession) {
        this.ramSession = ramSession;
    }

    public PolicyContext(Asset asset) {
        this.asset = asset;
        this.eventList = new ArrayList<PolicyEvent>();
    }

    public PolicyContext(Asset asset, boolean flag) {
        this(asset);
        this.submission = flag;
    }

    public Asset getAsset() {
        return this.asset;
    }

    public void setAsset(Asset asset) {
        this.asset = asset;
    }

    public List<PolicyEvent> getEventList() {
        return this.eventList;
    }

    public void createAsset(Asset asset) {
        this.getEventList().add(new PolicyEvent(0, asset));
    }

    public void updateAsset(Asset asset) {
        if (asset == null || asset.getId() == null || asset.getId().getGUID() == null || asset.getId().getVersion() == null) {
            return;
        }
        int i = 0;
        while (i < this.getEventList().size()) {
            Asset curAsset = this.getEventList().get(i).getAsset();
            if (curAsset == null || curAsset.getId() == null || asset.getId().getGUID().equals(curAsset.getId().getGUID()) && asset.getId().getVersion().equals(curAsset.getId().getVersion())) {
                this.getEventList().remove(i);
                --i;
            }
            ++i;
        }
        this.getEventList().add(new PolicyEvent(1, asset));
    }

    public RAMAsset getRAMAsset() {
        if (this.ramAsset == null) {
            this.ramAsset = this.getRAMSession().getAsset(new AssetIdentification(this.asset.getId().getGUID(), this.asset.getId().getVersion(), this.submission));
        }
        return this.ramAsset;
    }
}

