/*
 * Decompiled with CFR 0.152.
 */
package org.oslc.asset.internal.query;

import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.oslc.asset.internal.query.InvalidQuerySyntax;
import org.oslc.asset.internal.query.Messages;
import org.oslc.asset.internal.query.ast.Eq;
import org.oslc.asset.internal.query.ast.Eqw;
import org.oslc.asset.internal.query.ast.In;
import org.oslc.asset.internal.query.ast.Node;
import org.oslc.asset.internal.query.ast.OperatorKind;
import org.oslc.asset.internal.query.ast.Optional;
import org.oslc.asset.internal.query.ast.Query;
import org.oslc.asset.internal.query.ast.Term;
import org.oslc.asset.internal.query.ast.Union;

public class SparqlGenerator {
    private static final String XSD_PREFIX = "xsd";
    private static final String XSD_URI = "http://www.w3.org/2001/XMLSchema#";
    private static final String XPATH_FUNCTION_PREFIX = "fn";
    private static final String XPATH_FUNCTION_URI = "http://www.w3.org/2005/xpath-functions#";
    private static final String S_EMPTY = "";
    private static final String S_COLON = ":";
    private static final String F_PREFIX = "PREFIX %s: <%s>\n";
    private static final String F_PATTERNV = "    ?resource :%s ?%s .\n";
    private static final String F_QPATTERNV = "    ?resource %s ?%s .\n";
    private static final String F_PATTERN = "    ?resource :%s %s .\n";
    private static final String F_QPATTERN = "    ?resource %s %s .\n";
    private static final String F_PATTERNF = "%s %s %s";
    private static final String F_PATTERNW = "fn:starts-with( %s , %s )";
    private static final String F_ORDER = "ORDER BY %s\n";
    private static final String F_DORDER = "ORDER BY DESC(%s)\n";
    private static final String F_LIMIT = "LIMIT %d\n";
    private static final String F_OFFSET = "OFFSET %d\n";
    private static byte[] B_SELECT = null;
    private static byte[] B_SPACE = null;
    private static byte[] B_START_WHERE = null;
    private static byte[] B_START_UNION = null;
    private static byte[] B_MID_UNION = null;
    private static byte[] B_END_UNION = null;
    private static byte[] B_END_WHERE = null;
    private static byte[] B_START_FILTER = null;
    private static byte[] B_END_FILTER = null;
    private static byte[] B_START_OPTIONAL = null;
    private static byte[] B_END_OPTIONAL = null;
    private static byte[] B_AND = null;
    private static byte[] B_NEWLN = null;
    private static final String EX_NS_ERROR = Messages.getString("app.query.exceptions.namespace-error");
    private static final String EX_DEFNS_ERROR = Messages.getString("app.query.exceptions.namespace-default-error");
    private static final String EX_PROP_ERROR = Messages.getString("app.query.exceptions.invalid-return-property");

    static {
        try {
            B_SELECT = "SELECT ?resource ".getBytes("UTF-8");
            B_SPACE = " ".getBytes("UTF-8");
            B_START_WHERE = "WHERE {\n".getBytes("UTF-8");
            B_START_UNION = "  {\n".getBytes("UTF-8");
            B_MID_UNION = "  } UNION {\n".getBytes("UTF-8");
            B_END_UNION = "  }\n".getBytes("UTF-8");
            B_END_WHERE = "}\n".getBytes("UTF-8");
            B_START_FILTER = "    FILTER ( ".getBytes("UTF-8");
            B_END_FILTER = " )\n".getBytes("UTF-8");
            B_START_OPTIONAL = "  OPTIONAL {\n".getBytes("UTF-8");
            B_END_OPTIONAL = "  }\n".getBytes("UTF-8");
            B_AND = " && ".getBytes("UTF-8");
            B_NEWLN = "\n".getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {}
    }

    private static void validateNamespaceMappings(Query fromQuery, Map<String, String> namespaces, List<String> returnProps) throws InvalidQuerySyntax {
        HashSet<String> distinctNames = new HashSet<String>();
        List<String> queryProperties = fromQuery.getDistinctPropertyNames();
        distinctNames.addAll(returnProps);
        distinctNames.addAll(queryProperties);
        for (String name : distinctNames) {
            String[] split = name.split(S_COLON);
            if (split.length == 2) {
                if (namespaces.containsKey(split[0])) continue;
                throw new InvalidQuerySyntax(String.format(EX_NS_ERROR, split[0]));
            }
            if (namespaces.containsKey(S_EMPTY)) continue;
            throw new InvalidQuerySyntax(EX_DEFNS_ERROR);
        }
    }

    private static void generateOptional(Optional optional, List<String> returnProps, OutputStream os) throws InvalidQuerySyntax, IOException {
        HashSet<String> namesInScope = new HashSet<String>();
        for (Term term : optional) {
            namesInScope.add(term.getPropertyName());
        }
        ArrayList<String> filters = new ArrayList<String>();
        for (Term term : optional) {
            String[] split;
            String name;
            if (term instanceof Eq) {
                name = term.getPropertyName();
                split = name.split(S_COLON);
                if (split.length == 1) {
                    os.write(String.format(F_PATTERN, term.getPropertyName(), term.getValue()).getBytes("UTF-8"));
                    continue;
                }
                if (split.length != 2) continue;
                os.write(String.format(F_QPATTERN, term.getPropertyName(), term.getValue()).getBytes("UTF-8"));
                continue;
            }
            name = term.getPropertyName();
            if (!returnProps.contains(name)) {
                split = name.split(S_COLON);
                if (split.length == 1) {
                    os.write(String.format(F_PATTERNV, name, split[0]).getBytes("UTF-8"));
                } else if (split.length == 2) {
                    os.write(String.format(F_QPATTERNV, name, split[1]).getBytes("UTF-8"));
                }
            }
            if (term.getOperatorKind() == OperatorKind.Equal) {
                filters.add(String.format(F_PATTERNW, SparqlGenerator.varNameFromPredicate(term.getPropertyName()), term.getValue().replace("*", S_EMPTY)));
                continue;
            }
            if (term.getOperatorKind() == OperatorKind.In) {
                In inClause = (In)term;
                StringBuilder inFilter = new StringBuilder();
                inFilter.append("( ");
                Iterator<String> iterator = inClause.getValues().iterator();
                while (iterator.hasNext()) {
                    String value = iterator.next();
                    if (value.endsWith("*\"")) {
                        filters.add(String.format(F_PATTERNW, SparqlGenerator.varNameFromPredicate(term.getPropertyName()), term.getValue().replace("*", S_EMPTY)));
                    } else {
                        inFilter.append(String.format(F_PATTERNF, SparqlGenerator.varNameFromPredicate(term.getPropertyName()), "=", value));
                    }
                    if (!iterator.hasNext()) continue;
                    inFilter.append(" || ");
                }
                inFilter.append(" )");
                filters.add(inFilter.toString());
                continue;
            }
            filters.add(String.format(F_PATTERNF, SparqlGenerator.varNameFromPredicate(term.getPropertyName()), term.getOperator(), term.getValue()));
        }
        SparqlGenerator.printReturnedProperties(returnProps, namesInScope, os);
        SparqlGenerator.printFilters(filters, os);
    }

    public static void generate(Query fromQuery, Map<String, String> namespaces, List<String> returnProps, OutputStream os) throws InvalidQuerySyntax, IOException {
        fromQuery.optimize();
        SparqlGenerator.validateNamespaceMappings(fromQuery, namespaces, returnProps);
        for (Node node : fromQuery) {
            if (node instanceof Eqw) {
                namespaces.put(XPATH_FUNCTION_PREFIX, XPATH_FUNCTION_URI);
            }
            if (!(node instanceof Term) || ((Term)node).getDatatype() == null) continue;
            namespaces.put(XSD_PREFIX, XSD_URI);
        }
        for (String key : namespaces.keySet()) {
            os.write(String.format(F_PREFIX, key, namespaces.get(key)).getBytes("UTF-8"));
        }
        os.write(B_SELECT);
        for (String predicate : returnProps) {
            os.write(SparqlGenerator.varNameFromPredicate(predicate).getBytes("UTF-8"));
            os.write(B_SPACE);
        }
        os.write(B_NEWLN);
        os.write(B_START_WHERE);
        if (fromQuery.hasUnion()) {
            os.write(B_START_UNION);
        }
        HashSet<String> namesInScope = new HashSet<String>();
        for (Node node : fromQuery) {
            if (!(node instanceof Term)) continue;
            namesInScope.add(((Term)node).getPropertyName());
        }
        HashSet<String> distinctReturnProps = new HashSet<String>();
        distinctReturnProps.addAll(returnProps);
        distinctReturnProps.removeAll(fromQuery.getDistinctPropertyNames());
        namesInScope.addAll(distinctReturnProps);
        boolean havePrintedOptional = false;
        ArrayList<String> filters = new ArrayList<String>();
        for (Node node : fromQuery) {
            String[] split;
            String name;
            Term term;
            if (node instanceof Union) {
                SparqlGenerator.printReturnedProperties(returnProps, namesInScope, os);
                SparqlGenerator.printFilters(filters, os);
                filters.clear();
                os.write(B_MID_UNION);
                continue;
            }
            if (node instanceof Optional) {
                SparqlGenerator.printReturnedProperties(returnProps, namesInScope, os);
                SparqlGenerator.printFilters(filters, os);
                havePrintedOptional = true;
                os.write(B_START_OPTIONAL);
                SparqlGenerator.generateOptional((Optional)node, returnProps, os);
                os.write(B_END_OPTIONAL);
                continue;
            }
            if (node instanceof Eq) {
                term = (Term)node;
                name = term.getPropertyName();
                split = name.split(S_COLON);
                if (split.length == 1) {
                    os.write(String.format(F_PATTERN, term.getPropertyName(), term.getValue()).getBytes("UTF-8"));
                    continue;
                }
                if (split.length != 2) continue;
                os.write(String.format(F_QPATTERN, term.getPropertyName(), term.getValue()).getBytes("UTF-8"));
                continue;
            }
            if (!(node instanceof Term)) continue;
            term = (Term)node;
            name = term.getPropertyName();
            if (!returnProps.contains(name)) {
                split = name.split(S_COLON);
                if (split.length == 1) {
                    os.write(String.format(F_PATTERNV, name, split[0]).getBytes("UTF-8"));
                } else if (split.length == 2) {
                    os.write(String.format(F_QPATTERNV, name, split[1]).getBytes("UTF-8"));
                }
            }
            if (term.getOperatorKind() == OperatorKind.Equal) {
                filters.add(String.format(F_PATTERNW, SparqlGenerator.varNameFromPredicate(term.getPropertyName()), term.getValue().replace("*", S_EMPTY)));
                continue;
            }
            if (term.getOperatorKind() == OperatorKind.In) {
                In inClause = (In)node;
                StringBuilder inFilter = new StringBuilder();
                inFilter.append("( ");
                Iterator<String> iterator = inClause.getValues().iterator();
                while (iterator.hasNext()) {
                    String value = iterator.next();
                    if (value.endsWith("*\"")) {
                        filters.add(String.format(F_PATTERNW, SparqlGenerator.varNameFromPredicate(term.getPropertyName()), term.getValue().replace("*", S_EMPTY)));
                    } else {
                        inFilter.append(String.format(F_PATTERNF, SparqlGenerator.varNameFromPredicate(term.getPropertyName()), "=", value));
                    }
                    if (!iterator.hasNext()) continue;
                    inFilter.append(" || ");
                }
                inFilter.append(" )");
                filters.add(inFilter.toString());
                continue;
            }
            filters.add(String.format(F_PATTERNF, SparqlGenerator.varNameFromPredicate(term.getPropertyName()), term.getOperator(), term.getValue()));
        }
        if (!havePrintedOptional) {
            SparqlGenerator.printReturnedProperties(returnProps, namesInScope, os);
            SparqlGenerator.printFilters(filters, os);
        }
        if (fromQuery.hasUnion()) {
            os.write(B_END_UNION);
        }
        os.write(B_END_WHERE);
        if (fromQuery.getSortProperty() != Query.SORT_ORDER_UNSPECIFIED) {
            if (fromQuery.getSortOrder() == Query.SortOrder.DESC) {
                os.write(String.format(F_DORDER, SparqlGenerator.varNameFromPredicate(fromQuery.getSortProperty())).getBytes("UTF-8"));
            } else {
                os.write(String.format(F_ORDER, SparqlGenerator.varNameFromPredicate(fromQuery.getSortProperty())).getBytes("UTF-8"));
            }
        }
        if (fromQuery.getLimit() != 0) {
            os.write(String.format(F_LIMIT, fromQuery.getLimit()).getBytes("UTF-8"));
        }
        if (fromQuery.getOffset() != 0) {
            os.write(String.format(F_OFFSET, fromQuery.getOffset()).getBytes("UTF-8"));
        }
    }

    private static String varNameFromPredicate(String predicate) throws IllegalArgumentException {
        String[] split = predicate.split(S_COLON);
        if (split.length == 1) {
            return String.format("?%s", SparqlGenerator.escapeVarName(split[0]));
        }
        if (split.length == 2) {
            return String.format("?%s", SparqlGenerator.escapeVarName(split[1]));
        }
        throw new IllegalArgumentException(String.format(EX_PROP_ERROR, predicate));
    }

    private static String escapeVarName(String name) {
        return name.replace("-", S_EMPTY);
    }

    private static void printFilters(List<String> filters, OutputStream os) throws IOException {
        if (filters.size() > 0) {
            os.write(B_START_FILTER);
            int i = 0;
            while (i < filters.size()) {
                os.write(filters.get(i).getBytes("UTF-8"));
                if (i < filters.size() - 1) {
                    os.write(B_AND);
                }
                ++i;
            }
            os.write(B_END_FILTER);
        }
    }

    private static void printReturnedProperties(List<String> returnProps, Set<String> namesInScope, OutputStream os) throws IOException {
        for (String name : returnProps) {
            if (!namesInScope.contains(name)) continue;
            String[] split = name.split(S_COLON);
            if (split.length == 1) {
                os.write(String.format(F_PATTERNV, name, SparqlGenerator.escapeVarName(split[0])).getBytes("UTF-8"));
                continue;
            }
            if (split.length != 2) continue;
            os.write(String.format(F_QPATTERNV, name, SparqlGenerator.escapeVarName(split[1])).getBytes("UTF-8"));
        }
    }
}

