/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ram.internal.common.logging;

import com.ibm.ram.internal.common.logging.CoreLoggingMessages;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.regex.Pattern;
import org.apache.log4j.PatternLayout;
import org.apache.log4j.helpers.LogLog;
import org.apache.log4j.helpers.PatternConverter;
import org.apache.log4j.helpers.PatternParser;
import org.apache.log4j.spi.LoggingEvent;

public class RAMpatternLayout
extends PatternLayout {
    private static final String ROOT_PATH = ".";
    public static String KeySeperator = ",";
    private String msgCodes;
    private ConcurrentMap<String, String[]> codeMap = new ConcurrentHashMap<String, String[]>();
    private static final String KEY_PREFIX = "RAMpatternLayout.";
    private static final Pattern LOGGER_SPLIT = Pattern.compile("/");
    private static final Pattern CODE_SPLIT = Pattern.compile(",");

    protected PatternParser createPatternParser(String pattern) {
        return new RAMpatternParser(pattern);
    }

    public void setMsgCodes(String msgCodes) {
        this.msgCodes = msgCodes;
    }

    public String getMsgCodes() {
        return this.msgCodes;
    }

    public void activateOptions() {
        super.activateOptions();
        this.codeMap.clear();
        if (this.msgCodes != null && this.msgCodes.length() > 0) {
            String[] loggers = LOGGER_SPLIT.split(this.msgCodes);
            int iLoggers = 0;
            while (iLoggers < loggers.length) {
                String loggerIn = loggers[iLoggers];
                int cndx = loggerIn.indexOf(58);
                if (cndx < 0) {
                    LogLog.error((String)"RAMPatternLayout.msgCodes invalid format. Missing logger name.");
                    break;
                }
                String logger = loggerIn.substring(0, cndx).trim().intern();
                if (logger.length() == 0) {
                    LogLog.error((String)"RAMPatternLayout.msgCodes invalid format. Missing logger name.");
                    break;
                }
                String[] codesplit = CODE_SPLIT.split(loggerIn.substring(cndx + 1));
                String[] codes = new String[3];
                int csplitNdx = -1;
                int cdndx = 0;
                while (cdndx < codes.length) {
                    if (++csplitNdx < codesplit.length) {
                        codes[cdndx] = codesplit[csplitNdx].trim();
                        codes[cdndx] = codes[cdndx].length() > 0 ? KEY_PREFIX + codes[cdndx] : null;
                    }
                    ++cdndx;
                }
                this.codeMap.put(logger, codes);
                ++iLoggers;
            }
        }
        if (!this.codeMap.containsKey(ROOT_PATH)) {
            this.codeMap.put(ROOT_PATH, new String[3]);
        }
    }

    public class RAMpatternParser
    extends PatternParser {
        public RAMpatternParser(String pattern) {
            super(pattern);
        }

        protected void finalizeConverter(char c) {
            if (c != 'i') {
                super.finalizeConverter(c);
            } else {
                this.currentLiteral.setLength(0);
                this.addConverter(new PrefixConverter());
            }
        }

        private class PrefixConverter
        extends PatternConverter {
            private PrefixConverter() {
            }

            protected String convert(LoggingEvent event) {
                if (event.getRenderedMessage() != null && event.getRenderedMessage().contains("CRRAM")) {
                    return "";
                }
                String[] keys = this.getCodeKeys(event.getLoggerName());
                String key = null;
                switch (event.getLevel().toInt()) {
                    case 40000: 
                    case 50000: {
                        key = keys[0];
                        break;
                    }
                    case 30000: {
                        key = keys[1];
                        break;
                    }
                    case 10000: 
                    case 20000: {
                        key = keys[2];
                    }
                }
                if (key != null) {
                    return CoreLoggingMessages.getString(key);
                }
                return "";
            }

            private String[] getCodeKeys(String loggerName) {
                String[] keys;
                block2: {
                    keys = (String[])RAMpatternLayout.this.codeMap.get(loggerName);
                    if (keys != null) {
                        return keys;
                    }
                    String workingLoggerName = loggerName;
                    int ndx = workingLoggerName.length();
                    while ((ndx = workingLoggerName.lastIndexOf(46, ndx)) >= 0) {
                        workingLoggerName = workingLoggerName.substring(0, ndx);
                        keys = (String[])RAMpatternLayout.this.codeMap.get(workingLoggerName);
                        if (keys == null) continue;
                        RAMpatternLayout.this.codeMap.putIfAbsent(loggerName, keys);
                        break block2;
                    }
                    keys = (String[])RAMpatternLayout.this.codeMap.get(RAMpatternLayout.ROOT_PATH);
                }
                return keys;
            }
        }
    }
}

