/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ram.internal.json.pojo;

import com.ibm.ram.common.emf.ConstraintMatch;
import com.ibm.ram.common.emf.RelationshipConstraint;
import com.ibm.ram.common.util.UtilitiesCommon;
import com.ibm.ram.internal.json.pojo.RelationshipEntry;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;

public class Constraint {
    private String name;
    private List<RelationshipEntry> relatedAssets = new ArrayList<RelationshipEntry>();
    private List<Constraint> constraints = new ArrayList<Constraint>();
    private boolean constraint;
    private boolean required;
    private int type;
    private int minCount = Integer.MIN_VALUE;
    private int maxCount = Integer.MAX_VALUE;
    private String assetTypeUri;
    private String assetTypeName;
    private String jsObjType;
    private String constraintString;

    public Constraint() {
        this.setName("Unconstrained");
        this.setJsObjType("unconstrained");
        this.setAssetTypeUri("");
    }

    public Constraint(RelationshipConstraint constraint, String assetTypeName) {
        this();
        String reqAssetTypeUri;
        this.setType(constraint.getCountType().getValue());
        if (constraint.getCountType() == ConstraintMatch.EXACTLY_LITERAL || constraint.getCountType() == ConstraintMatch.SAME_OR_MORE_LITERAL) {
            this.minCount = constraint.getCount();
        } else {
            this.maxCount = constraint.getCount();
        }
        this.setConstraint(true);
        this.setName("Constraint");
        this.setJsObjType("constraint");
        if (constraint.getCountType() == ConstraintMatch.EXACTLY_LITERAL || constraint.getCountType() == ConstraintMatch.SAME_OR_MORE_LITERAL) {
            boolean bl = this.required = constraint.getCount() > 0;
        }
        if (!UtilitiesCommon.isEmptyString(reqAssetTypeUri = constraint.getRequiredAssetType())) {
            this.assetTypeUri = "internal/types/" + reqAssetTypeUri;
        }
        this.assetTypeName = assetTypeName;
        this.refreshConstraintString();
    }

    private void refreshConstraintString() {
        String messageKey = null;
        boolean any = UtilitiesCommon.isEmptyString(this.getAssetTypeUri());
        messageKey = this.getMinCount() > Integer.MIN_VALUE && this.getMaxCount() < Integer.MAX_VALUE ? (any ? "(Between {0} and {1} of any type)" : "(Between {0} and {1} of type {2})") : (this.getType() == ConstraintMatch.EXACTLY_LITERAL.getValue() ? (any ? "({0} of any type)" : "({0} of type {2})") : (this.getType() == ConstraintMatch.SAME_OR_MORE_LITERAL.getValue() ? (any ? "({0} or more of any type)" : "({0} or more of type {2})") : (any ? "({1} or less of any type)" : "({1} or less of type {2})")));
        this.setConstraintString(MessageFormat.format(messageKey, this.getMinCount(), this.getMaxCount(), this.getAssetTypeName()));
    }

    public List<RelationshipEntry> getRelatedAssets() {
        return this.relatedAssets;
    }

    public void setRelatedAssets(List<RelationshipEntry> relatedAssets) {
        this.relatedAssets = relatedAssets;
    }

    public boolean isConstraint() {
        return this.constraint;
    }

    public void setConstraint(boolean isConstraint) {
        this.constraint = isConstraint;
    }

    public boolean isRequired() {
        return this.required;
    }

    public void setRequired(boolean isRequired) {
        this.required = isRequired;
    }

    public String getAssetTypeUri() {
        return this.assetTypeUri;
    }

    public void setAssetTypeUri(String assetTypeUri) {
        this.assetTypeUri = assetTypeUri;
    }

    public void addRelationshipEntry(RelationshipEntry r) {
        this.relatedAssets.add(r);
    }

    public void setConstraints(List<Constraint> constraints) {
        this.constraints = constraints;
    }

    public List<Constraint> getConstraints() {
        return this.constraints;
    }

    public void addConstraint(Constraint c) {
        this.constraints.add(c);
    }

    public void setType(int type) {
        this.type = type;
    }

    public int getType() {
        return this.type;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setJsObjType(String jsObjType) {
        this.jsObjType = jsObjType;
    }

    public String getJsObjType() {
        return this.jsObjType;
    }

    public void setMinCount(int count) {
        this.minCount = count;
        this.refreshConstraintString();
    }

    public int getMinCount() {
        return this.minCount;
    }

    public void setMaxCount(int maxCount) {
        this.maxCount = maxCount;
        this.refreshConstraintString();
    }

    public int getMaxCount() {
        return this.maxCount;
    }

    public void setAssetTypeName(String assetTypeName) {
        this.assetTypeName = assetTypeName;
    }

    public String getAssetTypeName() {
        return this.assetTypeName;
    }

    public void setConstraintString(String constraintString) {
        this.constraintString = constraintString;
    }

    public String getConstraintString() {
        return this.constraintString;
    }
}

