/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ram.internal.rest;

import com.ibm.ram.common.util.RAMURLDecoder;
import com.ibm.ram.internal.jaxb.util.Base64;
import com.ibm.ram.internal.jaxb.util.JAXButil;
import com.ibm.ram.internal.jaxb.util.SelectivePropertiesParser;
import com.ibm.ram.internal.rest.InputStreamRequest;
import com.ibm.ram.internal.rest.RAMRestException;
import com.ibm.ram.internal.rest.Request;
import com.ibm.ram.internal.rest.Response;
import com.ibm.ram.internal.rest.RestContext;
import com.ibm.ram.internal.rest.RestService;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public abstract class AbstractRestService
implements RestService {
    protected static final Logger logger = Logger.getLogger(AbstractRestService.class);
    public final String PARAM_QUERY = "q";
    public final String PARAM_RESOLVE_RELATIONSHIPS = "relationships";
    public final String PARAM_OSLC_QUERY = "query";
    public final String PARAM_OSLC_PROPERTIES = "properties";
    public final String PARAM_OSLC_PAGE_SIZE = "pageSize";
    public final String PARAM_OSLC_START_INDEX = "startIndex";
    public final String PARAM_OSLC_NAME = "name";
    public final String LINK_REL_NEXT = "next";
    public final String LINK_REL_PREVIOUS = "previous";
    public final String LINK_REL_FIRST = "first";
    public final String LINK_REL_LAST = "last";
    public final String LINK_REL_SELF = "self";
    protected static String FILE_DELIM = "/";
    private Boolean fResolveRelationships = null;
    protected String fQueryParam = null;
    private RestContext fContext;
    private Request fRequest;
    private List<SelectivePropertiesParser.Property> selectiveProperties;
    public static final String[] SUPPORTED_MEDIA_TYPES = new String[]{"application/xml", "text/xml", "application/json", "application/oslc+json", "application/zip", "application/ras", "application/x-jazz-compact-rendering", "application/x-ram-permissions", "application/oslc+xml"};

    public AbstractRestService() {
        this(null, null);
    }

    public AbstractRestService(RestContext context) {
        this(context, null);
    }

    public AbstractRestService(RestContext context, Request request) {
        this.fContext = context;
        this.fRequest = request;
    }

    public RestContext getContext() {
        return this.fContext;
    }

    public void setContext(RestContext context) {
        this.fContext = context;
    }

    protected URI getRelativeURI() throws URISyntaxException {
        return this.getRelatveURI(this.getRequest().getContext().getBaseURI(), this.getRequest().getRequestURI());
    }

    protected URI getRelatveURI(URI baseURI, URI requestURI) {
        return baseURI.relativize(requestURI);
    }

    protected String getResponseExtension(Response response) {
        String extension;
        switch (response.getSerializationFormat()) {
            case JSON: {
                extension = ".json";
                break;
            }
            case WML: {
                extension = ".wml";
                break;
            }
            case XHTML: {
                extension = ".xhtml";
                break;
            }
            case ZIP: 
            case RAS: {
                extension = ".zip";
                break;
            }
            case COMPACT_RENDERING: {
                extension = ".jcr";
                break;
            }
            case PERMISSIONS: {
                extension = ".perm";
                break;
            }
            default: {
                extension = ".xml";
            }
        }
        return extension;
    }

    private void parseQueryParams() throws URISyntaxException {
        String query = this.getRequest().getRequestURI().getRawQuery();
        if (query != null) {
            String[] pairs;
            String[] stringArray = pairs = query.split("&");
            int n = pairs.length;
            int n2 = 0;
            while (n2 < n) {
                String pair = stringArray[n2];
                String[] parts = pair.split("=");
                if (parts.length != 2) {
                    logger.error((Object)("Invalid query pair: " + pair));
                } else {
                    try {
                        String key = RAMURLDecoder.decode(parts[0]);
                        String value = RAMURLDecoder.decode(parts[1]);
                        this.getRequest().getParameterMap().put(key, value);
                    }
                    catch (Exception e) {
                        logger.error((Object)("Invalid query pair: " + pair), (Throwable)e);
                    }
                }
                ++n2;
            }
        }
    }

    protected boolean isCachedResponse(Request request, Response respose) {
        String[] h;
        boolean toCache = true;
        if (request.getIfModifiedSince() != -1L) {
            toCache = false;
            if (request.getIfModifiedSince() < respose.getLastModified()) {
                toCache = true;
            }
        }
        if (toCache && (h = request.getIfNoneMatch()) != null) {
            String[] stringArray = h;
            int n = h.length;
            int n2 = 0;
            while (n2 < n) {
                String s = stringArray[n2];
                if ("*".equals(s) || s.equals(respose.getEtag())) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    public String getQueryParam() {
        if (this.fQueryParam == null) {
            this.fQueryParam = this.getParameterValue("query");
            if (this.fQueryParam == null) {
                this.fQueryParam = this.getParameterValue("q");
            }
        }
        return this.fQueryParam;
    }

    public String getParameterValue(String paramName) {
        if (this.getRequest().getHeadersMap().containsKey(paramName)) {
            return this.getRequest().getHeadersMap().get(paramName);
        }
        if (this.getRequest().getParameterMap().containsKey(paramName)) {
            return this.getRequest().getParameterMap().get(paramName);
        }
        return null;
    }

    public boolean isResolveRelationships() throws URISyntaxException {
        if (this.fResolveRelationships == null) {
            String param = this.getRequestParameter("relationships");
            this.fResolveRelationships = param != null && param.equalsIgnoreCase("true") ? Boolean.TRUE : Boolean.FALSE;
        }
        return this.fResolveRelationships;
    }

    protected String getRequestParameter(String key) throws URISyntaxException {
        String ret = this.getRequest().getParameterMap().get(key);
        if (ret == null) {
            this.parseQueryParams();
            ret = this.getRequest().getParameterMap().get(key);
        }
        return ret;
    }

    public static Map<String, String> copyParameterMap(Map<String, String[]> pMap) {
        HashMap<String, String> map = new HashMap<String, String>(pMap.size());
        for (Map.Entry<String, String[]> entry : pMap.entrySet()) {
            String[] v = entry.getValue();
            if (v.length <= 0) continue;
            String key = entry.getKey();
            if (key.startsWith("oslc_asset.")) {
                key = key.substring("oslc_asset.".length());
            }
            map.put(key, v[0]);
        }
        return map;
    }

    public static Map<String, String> copyHeaderMap(Map<String, Enumeration<String>> pMap) {
        HashMap<String, String> map = new HashMap<String, String>(pMap.size());
        for (Map.Entry<String, Enumeration<String>> entry : pMap.entrySet()) {
            Enumeration<String> v = entry.getValue();
            if (!v.hasMoreElements()) continue;
            String key = entry.getKey().toLowerCase();
            if (key.startsWith("oslc_asset.")) {
                key = key.substring("oslc_asset.".length());
            }
            map.put(key, v.nextElement());
        }
        return map;
    }

    protected String parseLeafURLPart(Response response, String token) {
        if (token.toLowerCase().endsWith(".json")) {
            token = token.substring(0, token.length() - ".json".length());
        } else if (token.toLowerCase().endsWith(".wml")) {
            token = token.substring(0, token.length() - ".wml".length());
        } else if (token.toLowerCase().endsWith(".xhtml")) {
            token = token.substring(0, token.length() - ".xhtml".length());
        } else if (token.toLowerCase().endsWith(".xml")) {
            token = token.substring(0, token.length() - ".xml".length());
        } else if (token.toLowerCase().endsWith(".htm")) {
            token = token.substring(0, token.length() - ".htm".length());
        } else if (token.toLowerCase().endsWith(".zip")) {
            token = token.substring(0, token.length() - ".zip".length());
        } else if (token.toLowerCase().endsWith(".ras")) {
            token = token.substring(0, token.length() - ".ras".length());
        } else if (token.toLowerCase().endsWith(".jcr")) {
            token = token.substring(0, token.length() - ".jcr".length());
        } else if (token.toLowerCase().endsWith(".perm")) {
            token = token.substring(0, token.length() - ".perm".length());
        }
        return JAXButil.urlDecode(token);
    }

    public Request getRequest() {
        return this.fRequest;
    }

    public void setRequest(Request request) {
        this.fRequest = request;
    }

    protected String getEtag(long val) throws URISyntaxException {
        String tag = "";
        char[] array = this.getContext().getUser().getIdentifier().toCharArray();
        int i = 0;
        while (i < array.length) {
            val += (long)(10 * i + array[i]);
            ++i;
        }
        tag = Base64.stringToBase64(Long.toHexString(val));
        tag = this.getContext().getSerializationFormat() == RestContext.SerializationFormat.JSON ? String.valueOf(tag) + "j" : String.valueOf(tag) + "x";
        if (this.isResolveRelationships()) {
            tag = String.valueOf(tag) + "r";
        }
        return tag;
    }

    protected InputStream getStreamFromRequest() {
        InputStream ret = null;
        if (this.getRequest() instanceof InputStreamRequest) {
            InputStreamRequest isr = (InputStreamRequest)this.getRequest();
            ret = isr.getInputStream();
        }
        return ret;
    }

    public String[] getSupportedMediaTypes() {
        return SUPPORTED_MEDIA_TYPES;
    }

    public boolean isWSGetHTMLSupported() {
        return false;
    }

    @Override
    public Response doDelete() throws RAMRestException {
        throw new RAMRestException(405, "Method not supported");
    }

    @Override
    public Response doGet() throws RAMRestException {
        throw new RAMRestException(405, "Method not supported");
    }

    @Override
    public Response doHead() throws RAMRestException {
        throw new RAMRestException(405, "Method not supported");
    }

    @Override
    public Response doPost() throws RAMRestException {
        throw new RAMRestException(405, "Method not supported");
    }

    @Override
    public Response doPut() throws RAMRestException {
        throw new RAMRestException(405, "Method not supported");
    }

    @Override
    public InputStream doGetContent() throws RAMRestException {
        throw new RAMRestException(405, "Method not supported");
    }

    public List<SelectivePropertiesParser.Property> getSelectiveProperties() {
        if (this.selectiveProperties == null) {
            String param = this.getParameterValue("oslc.properties");
            this.selectiveProperties = param != null && param.length() > 0 ? SelectivePropertiesParser.parseSelectiveProperties(param) : new ArrayList<SelectivePropertiesParser.Property>();
        }
        return this.selectiveProperties;
    }
}

